/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.RandomAccessFile;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemDataKeeper;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.ext.replication.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.FileDescriptor;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.PacketListener;
import org.exoplatform.services.jcr.ext.replication.PendingBinaryFile;
import org.exoplatform.services.jcr.ext.replication.PendingChangesLog;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

public abstract class AbstractWorkspaceDataReceiver
implements PacketListener {
    private static Log log = ExoLogger.getLogger((String)"ext.AbstractWorkspaceDataReceiver");
    public static final int INIT_MODE = -1;
    public static final int NORMAL_MODE = 0;
    public static final int RECOVERY_MODE = 1;
    private static final int START_TIMEOUT = 1000;
    private int state = -1;
    private String systemId;
    private ChannelManager channelManager;
    private HashMap<String, PendingChangesLog> mapPendingChangesLog;
    private HashMap<String, PendingBinaryFile> mapPendingBinaryFile;
    protected ItemDataKeeper dataKeeper;
    private FileCleaner fileCleaner = new FileCleaner(30030L);
    private String ownName;
    private RecoveryManager recoveryManager;

    public AbstractWorkspaceDataReceiver() throws RepositoryConfigurationException {
        this.mapPendingChangesLog = new HashMap();
        this.mapPendingBinaryFile = new HashMap();
    }

    public void init(ChannelManager channelManager, String systemId, String ownName, RecoveryManager recoveryManager) {
        this.systemId = systemId;
        this.channelManager = channelManager;
        this.channelManager.addPacketListener(this);
        this.ownName = ownName;
        this.recoveryManager = recoveryManager;
    }

    public void start() {
        try {
            Packet memberStartedPacket = new Packet(26, IdGenerator.generate(), this.ownName);
            this.channelManager.sendPacket(memberStartedPacket);
            Thread.sleep(1000L);
            Packet initedPacket = new Packet(21, IdGenerator.generate(), this.ownName);
            this.channelManager.sendPacket(initedPacket);
        }
        catch (Exception e) {
            log.error((Object)"Can't initialized AbstractWorkspaceDataReceiver", (Throwable)e);
        }
    }

    public void receive(ItemStateChangesLog itemStatechangesLog, String identifier) throws Exception {
        TransactionChangesLog changesLog = (TransactionChangesLog)itemStatechangesLog;
        if (changesLog.getSystemId() == null) {
            throw new Exception("Invalid or same systemId " + changesLog.getSystemId());
        }
        if (!changesLog.getSystemId().equals(this.systemId) && this.state != 1) {
            if (log.isDebugEnabled()) {
                ChangesLogIterator logIterator = changesLog.getLogIterator();
                while (logIterator.hasNextLog()) {
                    PlainChangesLog pcl = logIterator.nextLog();
                    log.info((Object)pcl.dump());
                }
            }
            this.dataKeeper.save((ItemStateChangesLog)changesLog);
            Packet packet = new Packet(13, identifier, this.ownName);
            this.channelManager.sendPacket(packet);
            if (log.isDebugEnabled()) {
                log.info((Object)("After save message: the owner systemId --> " + changesLog.getSystemId()));
                log.info((Object)("After save message: --> " + this.systemId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Packet packet) {
        try {
            Packet bigPacket = null;
            switch (packet.getPacketType()) {
                case 1: {
                    TransactionChangesLog changesLog = PendingChangesLog.getAsItemDataChangesLog(packet.getByteArray());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Received-->ItemDataChangesLog_without_Streams-->");
                        log.debug((Object)"---------------------");
                        log.debug((Object)("Size of received packet --> " + packet.getByteArray().length));
                        log.debug((Object)("Size of ItemStates          --> " + changesLog.getAllStates().size()));
                        log.debug((Object)"---------------------");
                    }
                    this.receive((ItemStateChangesLog)changesLog, packet.getIdentifier());
                    break;
                }
                case 2: {
                    TransactionChangesLog changesLog = PendingChangesLog.getAsItemDataChangesLog(packet.getByteArray());
                    PendingChangesLog container = new PendingChangesLog(changesLog, packet.getIdentifier(), 2, this.fileCleaner);
                    this.mapPendingChangesLog.put(packet.getIdentifier(), container);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)"Item DataChangesLog of type 'ItemDataChangesLog first whith stream'");
                    break;
                }
                case 10: {
                    PendingChangesLog bigChangesLogWhithStream = new PendingChangesLog(packet.getIdentifier(), (int)packet.getSize());
                    bigChangesLogWhithStream.putData((int)packet.getOffset(), packet.getByteArray());
                    this.mapPendingChangesLog.put(packet.getIdentifier(), bigChangesLogWhithStream);
                    break;
                }
                case 11: {
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) == null) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.putData((int)packet.getOffset(), packet.getByteArray());
                    break;
                }
                case 12: {
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) == null) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.putData((int)packet.getOffset(), packet.getByteArray());
                    TransactionChangesLog tempChangesLog = PendingChangesLog.getAsItemDataChangesLog(container.getData());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Recive-->Big ItemDataChangesLog_without_Streams-->");
                        log.debug((Object)"---------------------");
                        log.debug((Object)("Size of recive damp --> " + container.getData().length));
                        log.debug((Object)("ItemStates          --> " + tempChangesLog.getAllStates().size()));
                        log.debug((Object)"---------------------");
                        log.debug((Object)"Item big DataChangesLog of type 'ItemDataChangesLog only'");
                    }
                    this.mapPendingChangesLog.remove(packet.getIdentifier());
                    container = new PendingChangesLog(tempChangesLog, packet.getIdentifier(), 2, this.fileCleaner);
                    this.mapPendingChangesLog.put(packet.getIdentifier(), container);
                    break;
                }
                case 3: {
                    PendingChangesLog container;
                    if (!this.mapPendingChangesLog.containsKey(packet.getIdentifier())) break;
                    PendingChangesLog tempChangesLog = container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    synchronized (tempChangesLog) {
                        container.addNewStream(packet.getFixupStream());
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)"First pocket of stream");
                    break;
                }
                case 4: {
                    if (!this.mapPendingChangesLog.containsKey(packet.getIdentifier())) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    RandomAccessFile randomAccessFile = container.getRandomAccessFile(packet.getFixupStream());
                    if (randomAccessFile != null) {
                        randomAccessFile.seek(packet.getOffset());
                        randomAccessFile.write(packet.getByteArray());
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Pocket of stream : " + packet.getByteArray().length + " bytes"));
                    break;
                }
                case 5: {
                    if (!this.mapPendingChangesLog.containsKey(packet.getIdentifier())) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    RandomAccessFile randomAccessFile = container.getRandomAccessFile(packet.getFixupStream());
                    if (randomAccessFile != null) {
                        randomAccessFile.seek(packet.getOffset());
                        randomAccessFile.write(packet.getByteArray());
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Last pocket of stream : " + packet.getByteArray().length + " bytes"));
                    break;
                }
                case 6: {
                    TransactionChangesLog dataChangesLog;
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) != null) {
                        this.mapPendingChangesLog.get(packet.getIdentifier()).restore();
                    }
                    if ((dataChangesLog = this.mapPendingChangesLog.get(packet.getIdentifier()).getItemDataChangesLog()) == null) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Send-->ItemDataChangesLog_with_Streams-->");
                        log.debug((Object)"---------------------");
                        log.debug((Object)("ItemStates   --> " + dataChangesLog.getAllStates().size()));
                        log.debug((Object)("Streams      --> " + this.mapPendingChangesLog.get(packet.getIdentifier()).getInputStreams().size()));
                        log.debug((Object)"---------------------");
                    }
                    this.receive((ItemStateChangesLog)dataChangesLog, packet.getIdentifier());
                    this.mapPendingChangesLog.remove(packet.getIdentifier());
                    break;
                }
                case 7: {
                    PendingChangesLog bigChangesLog = new PendingChangesLog(packet.getIdentifier(), (int)packet.getSize());
                    bigChangesLog.putData((int)packet.getOffset(), packet.getByteArray());
                    this.mapPendingChangesLog.put(packet.getIdentifier(), bigChangesLog);
                    break;
                }
                case 8: {
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) == null) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.putData((int)packet.getOffset(), packet.getByteArray());
                    break;
                }
                case 9: {
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) == null) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.putData((int)packet.getOffset(), packet.getByteArray());
                    TransactionChangesLog tempChangesLog = PendingChangesLog.getAsItemDataChangesLog(container.getData());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Recive-->Big ItemDataChangesLog_without_Streams-->");
                        log.debug((Object)"---------------------");
                        log.debug((Object)("Size of recive damp --> " + container.getData().length));
                        log.debug((Object)("ItemStates          --> " + tempChangesLog.getAllStates().size()));
                        log.debug((Object)"---------------------");
                        log.debug((Object)"Item big DataChangesLog of type 'ItemDataChangesLog only'");
                    }
                    this.receive((ItemStateChangesLog)tempChangesLog, packet.getIdentifier());
                    this.mapPendingChangesLog.remove(packet.getIdentifier());
                    break;
                }
                case 27: {
                    PendingChangesLog bigLog = new PendingChangesLog(packet.getIdentifier(), (int)packet.getSize());
                    bigLog.putData((int)packet.getOffset(), packet.getByteArray());
                    this.mapPendingChangesLog.put(packet.getIdentifier(), bigLog);
                    break;
                }
                case 28: {
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) == null) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.putData((int)packet.getOffset(), packet.getByteArray());
                    break;
                }
                case 29: {
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) == null) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.putData((int)packet.getOffset(), packet.getByteArray());
                    bigPacket = Packet.getAsPacket(container.getData());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Recive-->Big packet-->");
                        log.debug((Object)"---------------------");
                        log.debug((Object)("Size of recive damp --> " + container.getData().length));
                        log.debug((Object)"---------------------");
                    }
                    this.mapPendingChangesLog.remove(packet.getIdentifier());
                    break;
                }
                case 32: {
                    PendingBinaryFile pbf;
                    if (!this.mapPendingBinaryFile.containsKey(packet.getIdentifier())) {
                        this.mapPendingBinaryFile.put(packet.getIdentifier(), new PendingBinaryFile());
                    }
                    PendingBinaryFile pendingBinaryFile = pbf = this.mapPendingBinaryFile.get(packet.getIdentifier());
                    synchronized (pendingBinaryFile) {
                        pbf.addBinaryFile(packet.getOwnerName(), packet.getFileName(), packet.getSystemId());
                        break;
                    }
                }
                case 33: {
                    if (!this.mapPendingBinaryFile.containsKey(packet.getIdentifier())) break;
                    PendingBinaryFile pbf = this.mapPendingBinaryFile.get(packet.getIdentifier());
                    FileDescriptor fd = pbf.getFileDescriptor(packet.getOwnerName(), packet.getFileName());
                    RandomAccessFile randomAccessFile = fd.getRandomAccessFile();
                    if (randomAccessFile != null) {
                        if (log.isDebugEnabled()) {
                            log.info((Object)("Offset : BinaryFile_Middle_Packet :" + packet.getOffset()));
                        }
                        randomAccessFile.seek(packet.getOffset());
                        randomAccessFile.write(packet.getByteArray());
                        break;
                    }
                    log.warn((Object)("Can't find the RandomAccessFile : \nowner - \t" + packet.getOwnerName() + "\nfile name - \t" + packet.getFileName()));
                    break;
                }
                case 34: {
                    if (!this.mapPendingBinaryFile.containsKey(packet.getIdentifier())) break;
                    PendingBinaryFile pbf = this.mapPendingBinaryFile.get(packet.getIdentifier());
                    RandomAccessFile randomAccessFile = pbf.getRandomAccessFile(packet.getOwnerName(), packet.getFileName());
                    if (randomAccessFile != null) {
                        if (log.isDebugEnabled()) {
                            log.info((Object)("Offset : BinaryFile_Last_Packet :" + packet.getOffset()));
                        }
                        randomAccessFile.seek(packet.getOffset());
                        randomAccessFile.write(packet.getByteArray());
                        randomAccessFile.close();
                        FileDescriptor fd = pbf.getFileDescriptor(packet.getOwnerName(), packet.getFileName());
                        this.saveChangesLog(fd, packet.getIdentifier());
                        this.fileCleaner.addFile(fd.getFile());
                        this.mapPendingBinaryFile.remove(packet.getIdentifier());
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)("Last packet of file has been received : " + packet.getFileName()));
                        break;
                    }
                    log.warn((Object)("Can't find the RandomAccessFile : \nowner - \t" + packet.getOwnerName() + "\nfile name - \t" + packet.getFileName()));
                    break;
                }
            }
            if (bigPacket != null) {
                this.state = this.recoveryManager.processing(bigPacket, this.state);
                bigPacket = null;
            } else {
                this.state = this.recoveryManager.processing(packet, this.state);
            }
        }
        catch (Exception e) {
            log.error((Object)"An error in processing packet : ", (Throwable)e);
        }
    }

    public ItemDataKeeper getDataKeeper() {
        return this.dataKeeper;
    }

    private void saveChangesLog(FileDescriptor fileDescriptor, String identifire) throws Exception {
        TransactionChangesLog transactionChangesLog = this.recoveryManager.getRecoveryReader().getChangesLog(fileDescriptor.getFile().getAbsolutePath());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save to JCR : " + fileDescriptor.getFile().getAbsolutePath()));
            log.debug((Object)("SystemID : " + transactionChangesLog.getSystemId()));
        }
        if (log.isDebugEnabled()) {
            ChangesLogIterator logIterator = transactionChangesLog.getLogIterator();
            while (logIterator.hasNextLog()) {
                PlainChangesLog pcl = logIterator.nextLog();
                log.debug((Object)pcl.dump());
            }
        }
        this.receive((ItemStateChangesLog)transactionChangesLog, identifire);
    }
}

