/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.UserProfileImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;

public class UserProfileHandlerImpl
extends CommonHandler
implements UserProfileHandler {
    public static final String EXO_ATTRIBUTES = "exo:attributes";
    protected final List<UserProfileEventListener> listeners = new ArrayList<UserProfileEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.UserProfileHandlerImpl");

    UserProfileHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners.add(listener);
    }

    public UserProfile createUserProfileInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.createUserProfileInstance() method is started");
        }
        return new UserProfileImpl();
    }

    public UserProfile createUserProfileInstance(String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.createUserProfileInstance(String) method is started");
        }
        return new UserProfileImpl(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile findUserProfileByName(String userName) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            UserProfile userProfile = this.findUserProfileByName(session, userName);
            return userProfile;
        }
        finally {
            session.logout();
        }
    }

    private UserProfile findUserProfileByName(Session session, String userName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.findUserProfileByName method is started");
        }
        try {
            String attrPath = this.service.getStoragePath() + "/" + "exo:users" + "/" + userName + "/" + "exo:profile" + "/" + EXO_ATTRIBUTES;
            if (!session.itemExists(attrPath)) {
                return null;
            }
            Node attrNode = (Node)session.getItem(attrPath);
            UserProfileImpl userProfile = new UserProfileImpl(userName);
            PropertyIterator props = attrNode.getProperties();
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                if (prop.getName().startsWith("jcr:") || prop.getName().startsWith("exo:")) continue;
                userProfile.setAttribute(prop.getName(), prop.getString());
            }
            return userProfile;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find user profile", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findUserProfiles() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findUserProfiles(session);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findUserProfiles(Session session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.findUserProfiles method is started");
        }
        try {
            ArrayList<UserProfile> types = new ArrayList<UserProfile>();
            Node storagePath = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users");
            NodeIterator nodes = storagePath.getNodes();
            while (nodes.hasNext()) {
                Node uNode = nodes.nextNode();
                UserProfile userProfile = this.findUserProfileByName(session, uNode.getName());
                if (userProfile == null) continue;
                types.add(userProfile);
            }
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find user profiles", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            UserProfile userProfile = this.removeUserProfile(session, userName, broadcast);
            return userProfile;
        }
        finally {
            session.logout();
        }
    }

    private UserProfile removeUserProfile(Session session, String userName, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.removeUserProfile method is started");
        }
        try {
            UserProfile userProfile = this.findUserProfileByName(session, userName);
            if (userProfile == null) {
                return null;
            }
            Node profileNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users" + "/" + userName + "/" + "exo:profile");
            if (broadcast) {
                this.preDelete(userProfile);
            }
            profileNode.remove();
            session.save();
            if (broadcast) {
                this.postDelete(userProfile);
            }
            return userProfile;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove '" + userName + "' profile", e);
        }
    }

    public void removeUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.saveUserProfile(session, profile, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void saveUserProfile(Session session, UserProfile profile, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.saveUserProfile method is started");
        }
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users" + "/" + profile.getUserName());
            try {
                uNode.getNode("exo:profile");
            }
            catch (PathNotFoundException e) {
                uNode.addNode("exo:profile");
            }
            Node profileNode = uNode.getNode("exo:profile");
            try {
                profileNode.getNode(EXO_ATTRIBUTES);
            }
            catch (PathNotFoundException e) {
                profileNode.addNode(EXO_ATTRIBUTES);
            }
            Node attrNode = profileNode.getNode(EXO_ATTRIBUTES);
            if (broadcast) {
                this.preSave(profile, false);
            }
            Object[] keys = profile.getUserInfoMap().keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)keys[i];
                attrNode.setProperty(key, profile.getAttribute(key));
            }
            session.save();
            if (broadcast) {
                this.postSave(profile, false);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not save '" + profile.getUserName() + "' profile", e);
        }
    }

    private void preSave(UserProfile userProfile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.preSave(userProfile, isNew);
        }
    }

    private void postSave(UserProfile userProfile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.postSave(userProfile, isNew);
        }
    }

    private void preDelete(UserProfile userProfile) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.preDelete(userProfile);
        }
    }

    private void postDelete(UserProfile userProfile) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.postDelete(userProfile);
        }
    }
}

