/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.metadata;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.jcr.PathNotFoundException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.QName;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.document.HandlerNotFoundException;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitions;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.log.ExoLogger;

public class AddMetadataAction
implements Action {
    private static Log log = ExoLogger.getLogger((String)"ext.AddMetadataAction");

    public boolean execute(Context ctx) throws Exception {
        DocumentReaderService readerService;
        PropertyImpl property = (PropertyImpl)ctx.get((Object)"currentItem");
        NodeImpl parent = property.getParent();
        if (!parent.isNodeType("nt:resource")) {
            throw new Exception("incoming node is not nt:resource type");
        }
        InputStream data = null;
        String mimeType = null;
        if (property.getInternalName().equals((Object)Constants.JCR_DATA)) {
            data = ((ValueData)((TransientPropertyData)property.getData()).getValues().get(0)).getAsStream();
            try {
                mimeType = parent.getProperty("jcr:mimeType").getString();
            }
            catch (PathNotFoundException e) {
                return false;
            }
        } else if (property.getInternalName().equals((Object)Constants.JCR_MIMETYPE)) {
            mimeType = property.getString();
            try {
                PropertyImpl propertyImpl = (PropertyImpl)parent.getProperty("jcr:data");
                data = ((ValueData)((TransientPropertyData)propertyImpl.getData()).getValues().get(0)).getAsStream();
            }
            catch (PathNotFoundException e) {
                return false;
            }
        } else {
            return false;
        }
        if (!parent.isNodeType("dc:elementSet")) {
            parent.addMixin("dc:elementSet");
        }
        if ((readerService = (DocumentReaderService)((ExoContainer)ctx.get((Object)"exocontainer")).getComponentInstanceOfType(DocumentReaderService.class)) == null) {
            throw new NullPointerException("No DocumentReaderService configured for current container");
        }
        Properties props = new Properties();
        try {
            props = readerService.getDocumentReader(mimeType).getProperties(data);
        }
        catch (HandlerNotFoundException e) {
            log.debug((Object)e.getMessage());
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            QName qname = (QName)entry.getKey();
            JCRName jcrName = property.getSession().getLocationFactory().createJCRName(new InternalQName(qname.getNamespace(), qname.getName()));
            PropertyDefinitions pds = parent.getSession().getWorkspace().getNodeTypeManager().findPropertyDefinitions(jcrName.getInternalName(), ((NodeData)parent.getData()).getPrimaryTypeName(), ((NodeData)parent.getData()).getMixinTypeNames());
            if (pds.getDefinition(true) != null) {
                Value[] values = new Value[]{this.createValue(entry.getValue(), (ValueFactory)property.getSession().getValueFactory())};
                parent.setProperty(jcrName.getAsString(), values);
                continue;
            }
            parent.setProperty(jcrName.getAsString(), this.createValue(entry.getValue(), (ValueFactory)property.getSession().getValueFactory()));
        }
        return false;
    }

    private Value createValue(Object obj, ValueFactory factory) throws ValueFormatException {
        if (obj instanceof String) {
            return factory.createValue((String)obj);
        }
        if (obj instanceof Calendar) {
            return factory.createValue((Calendar)obj);
        }
        if (obj instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)obj);
            return factory.createValue(cal);
        }
        throw new ValueFormatException("Unsupported value type " + obj.getClass());
    }
}

