/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.replication.FixupStream;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.PacketListener;
import org.exoplatform.services.jcr.ext.replication.ReplicationException;
import org.exoplatform.services.log.ExoLogger;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;

public class ChannelManager
implements RequestHandler {
    private static Log log = ExoLogger.getLogger((String)"ext.ChannelManager");
    private JChannel channel;
    private MessageDispatcher dispatcher;
    private final String channelConfig;
    private final String channelName;
    private String testChannelName;
    private MembershipListener membershipListener;
    private MessageListener messageListener;
    private List<PacketListener> packetListeners;
    private ChannelListener channelListener;

    public ChannelManager(String channelConfig, String channelName) {
        this.channelConfig = channelConfig;
        this.channelName = channelName;
        this.packetListeners = new ArrayList<PacketListener>();
    }

    public synchronized void init() throws ReplicationException {
        try {
            if (this.channel == null) {
                this.channel = new JChannel(this.channelConfig);
                this.channel.setOpt(5, (Object)Boolean.TRUE);
                this.channel.setOpt(6, (Object)Boolean.TRUE);
                this.dispatcher = new MessageDispatcher((Channel)this.channel, null, null, null);
                if (this.channelListener != null) {
                    this.channel.addChannelListener(this.channelListener);
                }
                if (this.membershipListener != null) {
                    this.dispatcher.setMembershipListener(this.membershipListener);
                }
                if (this.messageListener != null) {
                    this.dispatcher.setMessageListener(this.messageListener);
                }
                this.dispatcher.setRequestHandler((RequestHandler)this);
            }
        }
        catch (ChannelException e) {
            throw new ReplicationException("Can't create JGroups channel", e);
        }
    }

    public synchronized void connect() throws ReplicationException {
        log.info((Object)("channalName : " + this.channelName));
        if (log.isDebugEnabled()) {
            log.info((Object)("testChannalName == " + this.testChannelName));
        }
        try {
            if (this.testChannelName == null) {
                this.channel.connect(this.channelName);
            } else {
                this.channel.connect(this.testChannelName);
            }
        }
        catch (ChannelException e) {
            throw new ReplicationException("Can't connect to JGroups channel", e);
        }
    }

    public void closeChannel() {
        if (this.dispatcher != null) {
            this.dispatcher.setRequestHandler(null);
            this.dispatcher.setMembershipListener(null);
            this.dispatcher.stop();
            this.dispatcher = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"dispatcher stopped");
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.error((Object)("The interapted on disconnect : " + e), (Throwable)e);
            }
        }
        if (this.channel != null) {
            this.channel.disconnect();
            if (log.isDebugEnabled()) {
                log.debug((Object)"channel disconnected");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error((Object)("The interapted on disconnect : " + e), (Throwable)e);
            }
            this.channel.close();
            this.channel = null;
        }
    }

    public void setMembershipListener(MembershipListener membershipListener) {
        this.membershipListener = membershipListener;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void addPacketListener(PacketListener packetListener) {
        this.packetListeners.add(packetListener);
    }

    public void setChannelListener(ChannelListener channelListener) {
        this.channelListener = channelListener;
    }

    public MessageDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void sendPacket(Packet packet) throws Exception {
        byte[] buffer = Packet.getAsByteArray(packet);
        Message msg = new Message(null, null, buffer);
        this.dispatcher.castMessage(null, msg, 6, 0L);
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public synchronized void send(byte[] buffer) {
        Message msg = new Message(null, null, buffer);
        this.dispatcher.castMessage(null, msg, 6, 0L);
    }

    public synchronized void sendBigPacket(byte[] data, Packet packet) throws Exception {
        long offset = 0L;
        byte[] tempBuffer = new byte[16384];
        this.cutData(data, offset, tempBuffer);
        Packet firsPacket = new Packet(27, data.length, tempBuffer, packet.getIdentifier());
        firsPacket.setOwnName(packet.getOwnerName());
        firsPacket.setOffset(offset);
        this.sendPacket(firsPacket);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send of damp --> " + firsPacket.getByteArray().length));
        }
        offset += (long)tempBuffer.length;
        while ((long)data.length - offset > 16384L) {
            this.cutData(data, offset, tempBuffer);
            Packet middlePacket = new Packet(28, data.length, tempBuffer, packet.getIdentifier());
            middlePacket.setOwnName(packet.getOwnerName());
            middlePacket.setOffset(offset);
            Thread.sleep(1L);
            this.sendPacket(middlePacket);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Send of damp --> " + middlePacket.getByteArray().length));
            }
            offset += (long)tempBuffer.length;
        }
        byte[] lastBuffer = new byte[data.length - (int)offset];
        this.cutData(data, offset, lastBuffer);
        Packet lastPacket = new Packet(29, data.length, lastBuffer, packet.getIdentifier());
        lastPacket.setOwnName(packet.getOwnerName());
        lastPacket.setOffset(offset);
        this.sendPacket(lastPacket);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send of damp --> " + lastPacket.getByteArray().length));
        }
    }

    private void cutData(byte[] sourceData, long startPos, byte[] destination) {
        for (int i = 0; i < destination.length; ++i) {
            destination[i] = sourceData[i + (int)startPos];
        }
    }

    public synchronized void sendBinaryFile(String filePath, String ownerName, String identifier, String systemId, int firstPacketType, int middlePocketType, int lastPocketType) throws Exception {
        int len;
        long count = 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Begin send : " + filePath));
        }
        File f = new File(filePath);
        FileInputStream in = new FileInputStream(f);
        Packet packet = new Packet(firstPacketType, identifier, ownerName, f.getName());
        packet.setSystemId(systemId);
        packet.setSize(count);
        ++count;
        this.sendPacket(packet);
        byte[] buf = new byte[16384];
        long offset = 0L;
        while ((len = ((InputStream)in).read(buf)) > 0 && len == 16384) {
            packet = new Packet(middlePocketType, new FixupStream(), identifier, buf);
            packet.setOffset(offset);
            packet.setOwnName(ownerName);
            packet.setFileName(f.getName());
            packet.setSize(count);
            ++count;
            this.sendPacket(packet);
            offset += (long)len;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Send  --> " + offset));
            }
            Thread.sleep(1L);
        }
        if (len < 16384) {
            len = len == -1 ? 0 : len;
            byte[] buffer = new byte[len];
            for (int i = 0; i < len; ++i) {
                buffer[i] = buf[i];
            }
            packet = new Packet(lastPocketType, new FixupStream(), identifier, buffer);
            packet.setOffset(offset);
            packet.setOwnName(ownerName);
            packet.setFileName(f.getName());
            packet.setSize(count);
            ++count;
            this.sendPacket(packet);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("End send : " + filePath));
        }
        ((InputStream)in).close();
    }

    public Object handle(Message message) {
        try {
            Packet packet = Packet.getAsPacket(message.getBuffer());
            for (PacketListener handler : this.packetListeners) {
                handler.receive(packet);
            }
        }
        catch (IOException e) {
            log.error((Object)"An error in processing packet : ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"An error in processing packet : ", (Throwable)e);
        }
        return new String("Success !");
    }

    public void setAllowConnect(boolean allowConnect) {
        this.testChannelName = !allowConnect ? this.channelName + Math.round(Math.random() * 127.0) : null;
    }

    public void setAllowConnect(boolean allowConnect, int id) {
        this.testChannelName = !allowConnect ? this.channelName + id : null;
    }
}

