/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.priority;

import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.replication.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.priority.AbstractPriorityChecker;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicPriorityChecker
extends AbstractPriorityChecker {
    private static Log log = ExoLogger.getLogger((String)"ext.DynamicPriorityChecker");
    private int previousParticipantsCount;
    private int previousMaxPriority;

    public DynamicPriorityChecker(ChannelManager channelManager, int ownPriority, String ownName, List<String> otherParticipants) {
        super(channelManager, ownPriority, ownName, otherParticipants);
    }

    @Override
    public void receive(Packet packet) {
        if (log.isDebugEnabled()) {
            log.info((Object)(" ------->>> MessageListener.receive(), byte == " + packet.getByteArray()));
        }
        try {
            if (!this.ownName.equals(packet.getOwnerName())) {
                switch (packet.getPacketType()) {
                    case 30: {
                        Packet pktMyPriority = new Packet(31, this.ownName, this.ownPriority, packet.getIdentifier());
                        super.waitView();
                        this.channelManager.sendPacket(pktMyPriority);
                        break;
                    }
                    case 31: {
                        if (this.identifier != null && this.identifier.equals(packet.getIdentifier())) {
                            this.currentParticipants.put(packet.getOwnerName(), (int)packet.getSize());
                            if (log.isDebugEnabled()) {
                                log.info((Object)(this.channelManager.getChannel().getClusterName() + " : " + this.identifier + " : added member :"));
                                log.info((Object)("   +" + packet.getOwnerName() + ":" + this.currentParticipants.get(packet.getOwnerName())));
                            }
                        }
                        if (!log.isDebugEnabled()) break;
                        this.printOnlineMembers();
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"An error in processing packet : ", (Throwable)e);
        }
    }

    @Override
    public void informAll() {
        this.previousParticipantsCount = this.currentParticipants.size() + 1;
        this.previousMaxPriority = this.getCurrentMaxPriority();
        super.informAll();
    }

    private int getCurrentMaxPriority() {
        int max = Integer.MIN_VALUE;
        for (String nodeName : this.currentParticipants.keySet()) {
            if ((Integer)this.currentParticipants.get(nodeName) <= max) continue;
            max = (Integer)this.currentParticipants.get(nodeName);
        }
        if (this.ownPriority > max) {
            max = this.ownPriority;
        }
        return max == Integer.MIN_VALUE ? this.ownPriority : max;
    }

    @Override
    public boolean isMaxPriority() {
        if (this.otherParticipants.size() == 1) {
            return this.ownPriority == 100;
        }
        if (this.otherParticipants.size() > 1 && this.currentParticipants.size() == 0 && this.ownPriority == 100) {
            return false;
        }
        return this.otherParticipants.size() <= 1 || this.currentParticipants.size() != 0 || this.previousMaxPriority == this.ownPriority || this.previousParticipantsCount <= 1;
    }
}

