/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.StringTokenizer;
import org.exoplatform.services.jcr.datamodel.Identifier;

public class UnifiedNodeReference {
    public static final String JCR_SCHEME = "jcr";
    private String repository;
    private String workspace;
    private Identifier id;
    private String path;
    private static URLStreamHandler handler;

    public UnifiedNodeReference(String spec) throws URISyntaxException, MalformedURLException {
        this(new URL(null, spec, UnifiedNodeReference.getURLStreamHandler()));
    }

    public UnifiedNodeReference(URL url) throws URISyntaxException {
        this(url.toURI());
    }

    public UnifiedNodeReference(URI uri) throws URISyntaxException {
        String scheme = uri.getScheme();
        if (uri.getScheme() == null) {
            scheme = JCR_SCHEME;
        }
        if (!scheme.equals(JCR_SCHEME)) {
            throw new URISyntaxException(scheme, "Only 'jcr' scheme is acceptable!");
        }
        this.repository = uri.getHost();
        this.workspace = UnifiedNodeReference.parseWorkpace(uri);
        String fragment = uri.getFragment();
        if (fragment != null) {
            if (fragment.startsWith("/")) {
                this.path = fragment;
            } else {
                this.id = new Identifier(uri.getFragment());
            }
        } else {
            throw new URISyntaxException(fragment, "Neither Path nor Identifier defined!");
        }
    }

    public UnifiedNodeReference(URI uri, String defaultRepository, String defaultWorkspace) throws URISyntaxException {
        String fragment;
        String scheme = uri.getScheme();
        if (uri.getScheme() == null) {
            scheme = JCR_SCHEME;
        }
        if (!scheme.equals(JCR_SCHEME)) {
            throw new URISyntaxException(scheme, "Only 'jcr' scheme is acceptable!");
        }
        this.repository = uri.getHost();
        if (this.repository == null) {
            this.repository = defaultRepository;
        }
        this.workspace = UnifiedNodeReference.parseWorkpace(uri);
        if (this.workspace == null || this.workspace.length() == 0) {
            this.workspace = defaultWorkspace;
        }
        if ((fragment = uri.getFragment()) != null) {
            if (fragment.startsWith("/")) {
                this.path = fragment;
            } else {
                this.id = new Identifier(uri.getFragment());
            }
        } else {
            throw new URISyntaxException(fragment, "Neither Path nor Identifier defined!");
        }
    }

    public UnifiedNodeReference(String repository, String workspace, Identifier identifier) {
        this.repository = repository;
        this.workspace = workspace;
        this.id = identifier;
    }

    public UnifiedNodeReference(String repository, String workspace, String path) {
        this.repository = repository;
        this.workspace = workspace;
        this.path = path;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public Identifier getIdentitifier() {
        return this.id;
    }

    public boolean isIdentitifier() {
        return this.id != null;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isPath() {
        return this.path != null;
    }

    public URI getURI() throws URISyntaxException {
        if (this.id != null) {
            return new URI(JCR_SCHEME, null, this.repository, -1, '/' + this.workspace, null, this.id.getString());
        }
        if (this.path != null) {
            return new URI(JCR_SCHEME, null, this.repository, -1, '/' + this.workspace, null, this.path);
        }
        throw new URISyntaxException("", "Path or Idenfifier is not defined!");
    }

    public URL getURL() throws MalformedURLException {
        URI uri;
        try {
            uri = this.getURI();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException();
        }
        try {
            return new URL(uri.toString());
        }
        catch (MalformedURLException e) {
            return new URL(null, uri.toString(), UnifiedNodeReference.getURLStreamHandler());
        }
    }

    public static URLStreamHandler getURLStreamHandler() {
        if (handler != null) {
            return handler;
        }
        String packagePrefixList = System.getProperty("java.protocol.handler.pkgs");
        if (packagePrefixList == null) {
            return null;
        }
        StringTokenizer packagePrefixIter = new StringTokenizer(packagePrefixList, "|");
        while (handler == null && packagePrefixIter.hasMoreTokens()) {
            String packagePrefix = packagePrefixIter.nextToken().trim();
            try {
                Class<?> cls;
                block9: {
                    String clsName = packagePrefix + "." + JCR_SCHEME + ".Handler";
                    cls = null;
                    try {
                        cls = Class.forName(clsName);
                    }
                    catch (ClassNotFoundException e1) {
                        try {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            cls = cl.loadClass(clsName);
                        }
                        catch (ClassNotFoundException e2) {
                            ClassLoader cl = ClassLoader.getSystemClassLoader();
                            if (cl == null) break block9;
                            cls = cl.loadClass(clsName);
                        }
                    }
                }
                if (cls == null) continue;
                handler = (URLStreamHandler)cls.newInstance();
            }
            catch (Exception exception) {}
        }
        return handler;
    }

    private static String parseWorkpace(URI uri) {
        String path = uri.getPath();
        int sl = path.indexOf(47, 1);
        if (sl <= 0) {
            return path.substring(1);
        }
        return path.substring(1, sl);
    }
}

