/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestLoader;

public class GroovyScript2RestUpdateListener
implements EventListener {
    private String repository;
    private String workspace;
    private GroovyScript2RestLoader groovyScript2RestLoader;
    private Session session;

    public GroovyScript2RestUpdateListener(String repository, String workspace, GroovyScript2RestLoader groovyScript2RestLoader, Session session) {
        this.repository = repository;
        this.workspace = workspace;
        this.groovyScript2RestLoader = groovyScript2RestLoader;
        this.session = session;
    }

    public void onEvent(EventIterator eventIterator) {
        try {
            while (eventIterator.hasNext()) {
                String unifiedNodePath;
                Node node;
                Event event = eventIterator.nextEvent();
                String path = event.getPath();
                if (path.endsWith("/jcr:data") && (node = this.session.getItem(path).getParent()).getProperty("exo:autoload").getBoolean()) {
                    unifiedNodePath = new UnifiedNodeReference(this.repository, this.workspace, node.getPath()).getURL().toString();
                    if (event.getType() == 16) {
                        this.groovyScript2RestLoader.unloadScript(unifiedNodePath);
                        this.groovyScript2RestLoader.loadScript(unifiedNodePath, node.getProperty("jcr:data").getStream());
                    } else {
                        this.groovyScript2RestLoader.loadScript(unifiedNodePath, node.getProperty("jcr:data").getStream());
                    }
                }
                if (!path.endsWith("/exo:autoload") || event.getType() != 16) continue;
                node = this.session.getItem(path).getParent();
                unifiedNodePath = new UnifiedNodeReference(this.repository, this.workspace, node.getPath()).getURL().toString();
                if (node.getProperty("exo:autoload").getBoolean()) {
                    this.groovyScript2RestLoader.loadScript(unifiedNodePath, node.getProperty("jcr:data").getStream());
                    continue;
                }
                this.groovyScript2RestLoader.unloadScript(unifiedNodePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

