/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * Created by The eXo Platform SAS.
 * 
 * <br/>Date:
 * 
 * @author <a href="karpenko.sergiy@gmail.com">Karpenko Sergiy</a>
 * @version $Id: SimpleOutputChangesFile.java 27995 2009-02-06 15:04:44Z serg $
 */
public class SimpleOutputChangesFile extends SimpleChangesFile implements EditableChangesFile {

  public SimpleOutputChangesFile(File file, byte[] crc, long id, ResourcesHolder resHolder) {
    super(file, crc, id, resHolder);
  }

  public OutputStream getOutputStream() throws IOException {
    OutputStream out = new FileOutputStream(file);
    this.resHolder.add(out);
    return out;
  }
}
