/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.server.WorkspaceRestoreExeption;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class JobWorkspaceRestore
extends Thread {
    private static Log log = ExoLogger.getLogger((String)"ext.JobWorkspaceRestore");
    public static final int RESTORE_STARTED = 1;
    public static final int RESTORE_SUCCESSFUL = 2;
    public static final int RESTORE_FAIL = 3;
    public static final int RESTORE_INITIALIZED = 4;
    private int stateRestore;
    private final String repositoryName;
    private final String workspaceName;
    private final String path;
    private final InputStream wEntry;
    private final RepositoryService repositoryService;
    private final BackupManager backupManager;
    private Throwable restoreException = null;
    private Calendar startTime;
    private Calendar endTime;
    private BackupChainLog backupChainLog;

    public JobWorkspaceRestore(RepositoryService repositoryService, BackupManager backupManager, String repositoryName, String workspaceName, String logPath, InputStream wEntry) {
        this.repositoryService = repositoryService;
        this.backupManager = backupManager;
        this.repositoryName = repositoryName;
        this.workspaceName = workspaceName;
        this.path = logPath;
        this.wEntry = wEntry;
        this.stateRestore = 4;
    }

    public void run() {
        try {
            this.stateRestore = 1;
            this.startTime = Calendar.getInstance();
            this.restore();
            this.stateRestore = 2;
            this.endTime = Calendar.getInstance();
        }
        catch (Throwable t) {
            this.stateRestore = 3;
            this.restoreException = t;
            log.error((Object)"The restore was fail", t);
        }
    }

    private void restore() throws Throwable {
        try {
            RepositoryImpl repository = (RepositoryImpl)this.repositoryService.getRepository(this.repositoryName);
            RepositoryEntry reEntry = repository.getConfiguration();
            WorkspaceEntry wsEntry = this.getWorkspaceEntry(this.wEntry, this.workspaceName);
            repository.configWorkspace(wsEntry);
            try {
                File backLog = new File(this.path);
                this.backupChainLog = new BackupChainLog(backLog);
                this.backupManager.restore(this.backupChainLog, reEntry, wsEntry);
            }
            catch (Throwable t) {
                this.removeWorkspace((ManageableRepository)repository, this.workspaceName);
                throw new WorkspaceRestoreExeption("Can not be restored the workspace '/" + this.repositoryName + "/" + this.workspaceName + "' :", t);
            }
        }
        catch (Throwable t) {
            throw new WorkspaceRestoreExeption("Can not be restored the workspace  '/" + this.repositoryName + "/" + this.workspaceName + "' :", t);
        }
    }

    private WorkspaceEntry getWorkspaceEntry(InputStream wEntryStream, String workspaceName) throws FileNotFoundException, JiBXException, RepositoryConfigurationException {
        WorkspaceEntry wsEntry = null;
        IBindingFactory factory = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
        IUnmarshallingContext uctx = factory.createUnmarshallingContext();
        RepositoryServiceConfiguration conf = (RepositoryServiceConfiguration)uctx.unmarshalDocument(wEntryStream, null);
        RepositoryEntry rEntry = conf.getRepositoryConfiguration(this.repositoryName);
        for (WorkspaceEntry wEntry : rEntry.getWorkspaceEntries()) {
            if (!wEntry.getName().equals(workspaceName)) continue;
            wsEntry = wEntry;
        }
        if (wsEntry == null) {
            throw new RuntimeException("Can not find the workspace '" + workspaceName + "' in configuration.");
        }
        return wsEntry;
    }

    private void removeWorkspace(ManageableRepository mr, String workspaceName) throws RepositoryException {
        if (!mr.canRemoveWorkspace(workspaceName)) {
            WorkspaceContainerFacade wc = mr.getWorkspaceContainer(workspaceName);
            SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
            sessionRegistry.closeSessions(workspaceName);
        }
        mr.removeWorkspace(workspaceName);
    }

    public Throwable getRestoreException() {
        return this.restoreException;
    }

    public int getStateRestore() {
        return this.stateRestore;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public BackupChainLog getBackupChainLog() {
        return this.backupChainLog;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }
}

