/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.ext.replication.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.jgroups.Address;
import org.jgroups.MembershipListener;
import org.jgroups.View;

public class WorkspaceDataTransmitter
implements ItemsPersistenceListener,
MembershipListener {
    private static Log log = ExoLogger.getLogger((String)"ext.WorksapeDataTransmitter");
    private String systemId;
    private ChannelManager channelManager;
    private FileCleaner fileCleaner;
    private Vector<Address> members;
    private RecoveryManager recoveryManager;
    private String ownName;

    public WorkspaceDataTransmitter(CacheableWorkspaceDataManager dataManager) throws RepositoryConfigurationException {
        dataManager.addItemPersistenceListener((ItemsPersistenceListener)this);
        this.fileCleaner = new FileCleaner(30030L);
    }

    public void init(ChannelManager channelManager, String systemId, String ownName, RecoveryManager recoveryManager) {
        this.systemId = systemId;
        this.channelManager = channelManager;
        this.ownName = ownName;
        this.recoveryManager = recoveryManager;
        log.info((Object)("Own name  : " + ownName));
        log.info((Object)("System ID : " + systemId));
    }

    public void onSaveItems(ItemStateChangesLog isChangesLog) {
        TransactionChangesLog changesLog = (TransactionChangesLog)isChangesLog;
        if (changesLog.getSystemId() == null && !this.isSessionNull(changesLog)) {
            changesLog.setSystemId(this.systemId);
            try {
                if (log.isDebugEnabled()) {
                    ChangesLogIterator logIterator = changesLog.getLogIterator();
                    while (logIterator.hasNextLog()) {
                        PlainChangesLog pcl = logIterator.nextLog();
                        log.info((Object)pcl.dump());
                    }
                }
                String identifier = this.sendAsBinaryFile((ItemStateChangesLog)changesLog);
                if (log.isDebugEnabled()) {
                    log.info((Object)("After send message: the owner systemId --> " + changesLog.getSystemId()));
                    log.info((Object)("After send message: --> " + this.systemId));
                }
            }
            catch (Exception e) {
                log.error((Object)"Can not sent ChangesLog ...", (Throwable)e);
            }
        }
    }

    private String sendAsBinaryFile(ItemStateChangesLog isChangesLog) throws Exception {
        TransactionChangesLog changesLog = (TransactionChangesLog)isChangesLog;
        String identifier = IdGenerator.generate();
        this.recoveryManager.save(isChangesLog, identifier);
        File f = File.createTempFile("cl_", ".tmp");
        this.recoveryManager.getRecoveryWriter().save(f, changesLog);
        this.channelManager.sendBinaryFile(f.getCanonicalPath(), this.ownName, identifier, this.systemId, 32);
        if (!f.delete()) {
            this.fileCleaner.addFile(f);
        }
        return identifier;
    }

    public void suspect(Address suspectedMbr) {
    }

    public void block() {
    }

    private boolean isSessionNull(TransactionChangesLog changesLog) {
        boolean isSessionNull = false;
        ChangesLogIterator logIterator = changesLog.getLogIterator();
        while (logIterator.hasNextLog()) {
            if (logIterator.nextLog().getSessionId() != null) continue;
            isSessionNull = true;
            break;
        }
        return isSessionNull;
    }

    public void viewAccepted(View views) {
        Address localIpAddres = this.channelManager.getChannel().getLocalAddress();
        this.members = new Vector();
        for (int i = 0; i < views.getMembers().size(); ++i) {
            Address address = (Address)views.getMembers().get(i);
            if (address.compareTo((Object)localIpAddres) == 0) continue;
            this.members.add(address);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.members.size());
        }
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }
}

