/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.ext.replication.async.MergeManager;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporter;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.log.ExoLogger;

public abstract class AbstractMergeManager
implements MergeManager {
    protected final RemoteExporter exporter;
    protected final DataManager dataManager;
    protected final NodeTypeDataManager ntManager;
    protected final ResourcesHolder resHolder = new ResourcesHolder();
    protected final String storageDir;
    protected volatile boolean run = true;
    protected Member localMember = null;
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.MergerManager");

    AbstractMergeManager(RemoteExporter exporter, DataManager dataManager, NodeTypeDataManager ntManager, String storageDir) {
        this.exporter = exporter;
        this.dataManager = dataManager;
        this.ntManager = ntManager;
        this.storageDir = storageDir;
    }

    public void setLocalMember(Member localMember) {
        this.localMember = localMember;
    }

    public void cancel() {
        this.run = false;
    }

    public void cleanup() {
        this.run = false;
        try {
            this.resHolder.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Cannot close merge data streams " + e), (Throwable)e);
        }
        File dir = new File(this.storageDir);
        if (dir.exists()) {
            File[] files;
            for (File f : files = dir.listFiles()) {
                this.deleteStorage(f);
            }
        }
    }

    protected File makePath(Member first, Member second) {
        File dir = new File(this.storageDir, first.getPriority() + "-" + second.getPriority());
        dir.mkdirs();
        return dir;
    }

    protected File makePath(String dirName) {
        File dir = new File(this.storageDir, dirName);
        dir.mkdirs();
        return dir;
    }

    private void deleteStorage(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.deleteStorage(f);
            }
        }
        if (!file.delete()) {
            LOG.warn((Object)("Cannot delete file " + file.getAbsolutePath()));
        }
    }
}

