/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.ext.replication.ReplicationException;
import org.exoplatform.services.jcr.ext.replication.async.AsyncInitializer;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReceiverImpl;
import org.exoplatform.services.jcr.ext.replication.async.AsyncStartChangesListener;
import org.exoplatform.services.jcr.ext.replication.async.AsyncTransmitterImpl;
import org.exoplatform.services.jcr.ext.replication.async.ChangesPublisherImpl;
import org.exoplatform.services.jcr.ext.replication.async.ChangesSaveErrorLog;
import org.exoplatform.services.jcr.ext.replication.async.ChangesSubscriberImpl;
import org.exoplatform.services.jcr.ext.replication.async.ConnectionListener;
import org.exoplatform.services.jcr.ext.replication.async.MergeDataManager;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportServerImpl;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporterImpl;
import org.exoplatform.services.jcr.ext.replication.async.WorkspaceSynchronizerImpl;
import org.exoplatform.services.jcr.ext.replication.async.config.AsyncWorkspaceConfig;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChecksumNotFoundException;
import org.exoplatform.services.jcr.ext.replication.async.storage.IncomeStorageImpl;
import org.exoplatform.services.jcr.ext.replication.async.storage.LocalStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.LocalStorageImpl;
import org.exoplatform.services.jcr.ext.replication.async.storage.SystemLocalStorageImpl;
import org.exoplatform.services.jcr.ext.replication.async.storage.WorkspaceNullListener;
import org.exoplatform.services.jcr.ext.replication.async.transport.AsyncChannelManager;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.WorkspaceFileCleanerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncReplication
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"ext.AsyncReplication");
    public static final String IP_ADRESS_TEMPLATE = "[$]bind-ip-address";
    public final int FILE_CLEANER_PERIOD = 150000;
    protected final RepositoryService repoService;
    protected LinkedHashMap<StorageKey, String> incomeStoragePaths;
    protected LinkedHashMap<StorageKey, LocalStorageImpl> localStorages;
    protected LinkedHashMap<StorageKey, ReaderSpoolFileHolder> holderList;
    protected Set<AsyncWorker> currentWorkers;
    protected final LinkedHashMap<StorageKey, WorkspaceNullListener> nullWorkspaces;
    protected List<AsyncWorkspaceConfig> asyncWorkspaceConfigs;

    public AsyncReplication(RepositoryService repoService, InitParams params) throws RepositoryException, RepositoryConfigurationException {
        this.repoService = repoService;
        this.nullWorkspaces = new LinkedHashMap();
        this.localStorages = new LinkedHashMap();
        this.holderList = new LinkedHashMap();
        this.incomeStoragePaths = new LinkedHashMap();
        this.asyncWorkspaceConfigs = new ArrayList<AsyncWorkspaceConfig>();
        this.currentWorkers = new LinkedHashSet<AsyncWorker>();
    }

    AsyncReplication(RepositoryService repoService, List<AsyncWorkspaceConfig> configs) throws RepositoryException, RepositoryConfigurationException {
        this.repoService = repoService;
        this.nullWorkspaces = new LinkedHashMap();
        this.localStorages = new LinkedHashMap();
        this.holderList = new LinkedHashMap();
        this.incomeStoragePaths = new LinkedHashMap();
        this.asyncWorkspaceConfigs = new ArrayList<AsyncWorkspaceConfig>();
        this.asyncWorkspaceConfigs.addAll(configs);
        this.currentWorkers = new LinkedHashSet<AsyncWorker>();
    }

    public boolean isActive() {
        return this.currentWorkers.size() > 0;
    }

    public synchronized boolean synchronize() throws RepositoryException, RepositoryConfigurationException, IOException {
        if (this.isActive()) {
            LOG.error((Object)"[ERROR] Asynchronous replication service already active. Wait for current synchronization finish.");
            return false;
        }
        if (this.asyncWorkspaceConfigs != null && this.asyncWorkspaceConfigs.size() > 0) {
            for (AsyncWorkspaceConfig config : this.asyncWorkspaceConfigs) {
                this.synchronize(config);
            }
            return true;
        }
        LOG.error((Object)"[ERROR] Asynchronous replication service is not proper initializer or started. Repositories list empty. Check log for details.");
        return false;
    }

    protected void synchronize(AsyncWorkspaceConfig config) throws RepositoryException, RepositoryConfigurationException, IOException {
        if (this.hasChangesSaveError(config)) {
            LOG.error((Object)"[ERROR] Synchronization not started. The previous synchronisation have errors.");
            return;
        }
        if (this.hasLocalSorageError(config)) {
            LOG.error((Object)"[ERROR] Synchronization not started. Loacal storage have errors.");
            return;
        }
        ManageableRepository repository = this.repoService.getRepository(config.getRepositoryName());
        WorkspaceContainerFacade syswsc = repository.getWorkspaceContainer(repository.getConfiguration().getSystemWorkspaceName());
        PersistentDataManager sysdm = (PersistentDataManager)syswsc.getComponent(PersistentDataManager.class);
        WorkspaceContainerFacade wsc = repository.getWorkspaceContainer(config.getWorkspaceName());
        NodeTypeDataManager ntm = (NodeTypeDataManager)wsc.getComponent(NodeTypeDataManager.class);
        PersistentDataManager dm = (PersistentDataManager)wsc.getComponent(PersistentDataManager.class);
        WorkspaceDataContainer dc = (WorkspaceDataContainer)wsc.getComponent(WorkspaceDataContainer.class);
        WorkspaceEntry wconf = (WorkspaceEntry)wsc.getComponent(WorkspaceEntry.class);
        int maxBufferSize = wconf.getContainer().getParameterInteger("max-buffer-size", Integer.valueOf(204800));
        WorkspaceFileCleanerHolder wfcleaner = (WorkspaceFileCleanerHolder)wsc.getComponent(WorkspaceFileCleanerHolder.class);
        FileCleaner fileCleaner = wfcleaner.getFileCleaner();
        StorageKey skey = new StorageKey(config.getRepositoryName(), config.getWorkspaceName());
        LocalStorageImpl localStorage = this.localStorages.get(skey);
        ReaderSpoolFileHolder holder = this.holderList.get(skey);
        IncomeStorageImpl incomeStorage = new IncomeStorageImpl(this.incomeStoragePaths.get(skey), fileCleaner, maxBufferSize, holder);
        AsyncWorker synchWorker = new AsyncWorker(dm, sysdm, ntm, dc, localStorage, incomeStorage, config, config.getRepositoryName() + "_" + config.getWorkspaceName(), wconf, wfcleaner, holder);
        synchWorker.run();
        this.currentWorkers.add(synchWorker);
    }

    public void start() {
        try {
            ManageableRepository repository;
            for (AsyncWorkspaceConfig config : this.asyncWorkspaceConfigs) {
                repository = this.repoService.getRepository(config.getRepositoryName());
                String systemWSName = repository.getConfiguration().getSystemWorkspaceName();
                if (!systemWSName.equals(config.getWorkspaceName())) continue;
                this.addStorageToWorkspace(repository, config.getRepositoryName(), systemWSName, systemWSName, config.getLocalStorageDir(), config.getIncomeStorageDir());
            }
            for (AsyncWorkspaceConfig config : this.asyncWorkspaceConfigs) {
                repository = this.repoService.getRepository(config.getRepositoryName());
                String wsName = config.getWorkspaceName();
                String systemWSName = repository.getConfiguration().getSystemWorkspaceName();
                if (this.isReplicableWorkspace(config.getRepositoryName(), wsName)) {
                    if (wsName.equals(systemWSName)) continue;
                    this.addStorageToWorkspace(repository, config.getRepositoryName(), wsName, systemWSName, config.getLocalStorageDir(), config.getIncomeStorageDir());
                    continue;
                }
                if (wsName.equals(systemWSName)) {
                    LOG.warn((Object)("System workspace " + wsName + " configured as non-replicable. It's added to replication process for default."));
                    continue;
                }
                this.addWorkspaceNullListener(repository, config.getRepositoryName(), wsName, systemWSName);
            }
        }
        catch (Throwable e) {
            LOG.error((Object)("Asynchronous replication start fails" + e), e);
            throw new RuntimeException("Asynchronous replication start fails " + e, e);
        }
    }

    public void stop() {
    }

    private boolean hasLocalSorageError(AsyncWorkspaceConfig config) throws RepositoryConfigurationException, RepositoryException, IOException {
        boolean hasLocalSorageError = false;
        LocalStorage localStorage = this.localStorages.get(new StorageKey(config.getRepositoryName(), config.getWorkspaceName()));
        String[] storageError = localStorage.getErrors();
        if (storageError.length > 0) {
            hasLocalSorageError = true;
            LOG.error((Object)("The local storage '" + config.getRepositoryName() + "@" + config.getWorkspaceName() + "' have errors : "));
            for (String error : storageError) {
                LOG.error((Object)error);
            }
        }
        return hasLocalSorageError;
    }

    private boolean hasChangesSaveError(AsyncWorkspaceConfig config) throws RepositoryConfigurationException, RepositoryException, IOException {
        boolean hasChangesSaveError = false;
        ChangesSaveErrorLog errorLog = new ChangesSaveErrorLog(config.getStorageDir(), config.getRepositoryName(), config.getWorkspaceName());
        String[] changesSaveErrors = errorLog.getErrors();
        if (changesSaveErrors.length > 0) {
            hasChangesSaveError = true;
            LOG.error((Object)("The errors log file : " + errorLog.getErrorLog()));
            LOG.error((Object)("The previous save on '" + config.getRepositoryName() + "@" + config.getWorkspaceName() + "' have errors : "));
            for (String error : changesSaveErrors) {
                LOG.error((Object)error);
            }
        }
        return hasChangesSaveError;
    }

    private void addStorageToWorkspace(ManageableRepository repository, String repositoryName, String wsName, String systemWSName, String localStorageDir, String incomeStorageDir) throws ChecksumNotFoundException, NoSuchAlgorithmException, RepositoryException, RepositoryConfigurationException {
        StorageKey skey = new StorageKey(repositoryName, wsName);
        WorkspaceContainerFacade wsc = repository.getWorkspaceContainer(wsName);
        WorkspaceEntry wconf = (WorkspaceEntry)wsc.getComponent(WorkspaceEntry.class);
        int maxBufferSize = wconf.getContainer().getParameterInteger("max-buffer-size", Integer.valueOf(204800));
        WorkspaceFileCleanerHolder wfcleaner = (WorkspaceFileCleanerHolder)wsc.getComponent(WorkspaceFileCleanerHolder.class);
        FileCleaner fileCleaner = wfcleaner.getFileCleaner();
        File localDirPerWorkspace = new File(localStorageDir + File.separator + repositoryName + File.separator + wsName);
        localDirPerWorkspace.mkdirs();
        LocalStorageImpl localStorage = null;
        ReaderSpoolFileHolder holder = new ReaderSpoolFileHolder();
        if (wsName.equals(systemWSName)) {
            localStorage = new SystemLocalStorageImpl(localDirPerWorkspace.getAbsolutePath(), fileCleaner, maxBufferSize, holder);
            if (!this.isReplicableWorkspace(repositoryName, wsName)) {
                LOG.warn((Object)("System workspace " + wsName + " configured as non-replicable. It's added to replication process."));
            }
        } else {
            SystemLocalStorageImpl systemLocalStorage = (SystemLocalStorageImpl)this.localStorages.get(new StorageKey(repositoryName, systemWSName));
            localStorage = new LocalStorageImpl(localDirPerWorkspace.getAbsolutePath(), fileCleaner, maxBufferSize, holder, systemLocalStorage);
        }
        this.localStorages.put(skey, localStorage);
        this.holderList.put(skey, holder);
        AsyncStartChangesListener asyncStartChangesListener = (AsyncStartChangesListener)wsc.getComponent(AsyncStartChangesListener.class);
        PersistentDataManager dm = (PersistentDataManager)wsc.getComponent(PersistentDataManager.class);
        dm.addItemPersistenceListener((ItemsPersistenceListener)localStorage);
        if (asyncStartChangesListener != null) {
            localStorage.saveStartChanges(asyncStartChangesListener.getChanges());
            asyncStartChangesListener.clear();
        }
        File incomeDirPerWorkspace = new File(incomeStorageDir + File.separator + repositoryName + File.separator + wsName);
        incomeDirPerWorkspace.mkdirs();
        this.incomeStoragePaths.put(new StorageKey(repositoryName, wsName), incomeDirPerWorkspace.getAbsolutePath());
    }

    private boolean isReplicableWorkspace(String repoName, String wsName) {
        for (AsyncWorkspaceConfig config : this.asyncWorkspaceConfigs) {
            if (!repoName.endsWith(config.getRepositoryName()) || !wsName.equals(config.getWorkspaceName())) continue;
            return true;
        }
        return false;
    }

    private void addWorkspaceNullListener(ManageableRepository repository, String repositoryName, String wsName, String systemWSName) {
        SystemLocalStorageImpl systemLocalStorage = (SystemLocalStorageImpl)this.localStorages.get(new StorageKey(repositoryName, systemWSName));
        WorkspaceNullListener listener = new WorkspaceNullListener(systemLocalStorage);
        this.nullWorkspaces.put(new StorageKey(repositoryName, wsName), listener);
        WorkspaceContainerFacade wsc = repository.getWorkspaceContainer(wsName);
        PersistentDataManager dm = (PersistentDataManager)wsc.getComponent(PersistentDataManager.class);
        dm.addItemPersistenceListener((ItemsPersistenceListener)listener);
        AsyncStartChangesListener asyncStartChangesListener = (AsyncStartChangesListener)wsc.getComponent(AsyncStartChangesListener.class);
        if (asyncStartChangesListener != null) {
            for (int i = 0; i < asyncStartChangesListener.getChanges().size(); ++i) {
                listener.onSaveItems(asyncStartChangesListener.getChanges().get(i));
            }
            asyncStartChangesListener.clear();
        }
    }

    public void addAsyncWorkspaceConfig(AsyncWorkspaceConfig config) {
        this.asyncWorkspaceConfigs.add(config);
    }

    protected class StorageKey {
        private final String repositoryName;
        private final String workspaceName;

        public StorageKey(String repositoryName, String workspaceName) {
            this.repositoryName = repositoryName;
            this.workspaceName = workspaceName;
        }

        public boolean equals(Object o) {
            StorageKey k = (StorageKey)o;
            return this.repositoryName.equals(k.repositoryName) && this.workspaceName.equals(k.workspaceName);
        }

        public int hashCode() {
            return this.repositoryName.hashCode() ^ this.workspaceName.hashCode();
        }
    }

    class AsyncWorker
    implements ConnectionListener {
        protected final AsyncChannelManager channel;
        protected final AsyncInitializer initializer;
        protected final ChangesPublisherImpl publisher;
        protected final ChangesSubscriberImpl subscriber;
        protected final WorkspaceSynchronizerImpl synchronyzer;
        protected final AsyncTransmitterImpl transmitter;
        protected final AsyncReceiverImpl receiver;
        protected final RemoteExporterImpl exporter;
        protected final RemoteExportServerImpl exportServer;
        protected final ChangesSaveErrorLog changesSaveErrorLog;
        protected final MergeDataManager mergeManager;
        protected final PersistentDataManager dataManager;
        protected final PersistentDataManager systemDataManager;
        protected final WorkspaceDataContainer dataContainer;
        protected final NodeTypeDataManager ntManager;
        protected final LocalStorageImpl localStorage;
        protected final IncomeStorageImpl incomeStorage;

        AsyncWorker(PersistentDataManager dataManager, PersistentDataManager systemDataManager, NodeTypeDataManager ntManager, WorkspaceDataContainer dataContainer, LocalStorageImpl localStorage, IncomeStorageImpl incomeStorage, AsyncWorkspaceConfig config, String chanelNameSufix, WorkspaceEntry workspaceConfig, WorkspaceFileCleanerHolder workspaceCleanerHolder, ReaderSpoolFileHolder holder) {
            int maxBufferSize = workspaceConfig.getContainer().getParameterInteger("max-buffer-size", Integer.valueOf(204800));
            FileCleaner fileCleaner = workspaceCleanerHolder.getFileCleaner();
            this.channel = new AsyncChannelManager(config.getChannelConfig(), config.getChannelName() + "_" + chanelNameSufix, config.getOtherParticipantsPriority().size() + 1);
            this.dataManager = dataManager;
            this.systemDataManager = systemDataManager;
            this.ntManager = ntManager;
            this.dataContainer = dataContainer;
            this.localStorage = localStorage;
            this.incomeStorage = incomeStorage;
            this.transmitter = new AsyncTransmitterImpl(this.channel, config.getPriority());
            this.synchronyzer = new WorkspaceSynchronizerImpl(dataManager, systemDataManager, this.localStorage, workspaceConfig, workspaceCleanerHolder);
            this.exportServer = new RemoteExportServerImpl(this.transmitter, (DataManager)dataManager, (DataManager)systemDataManager, ntManager);
            this.changesSaveErrorLog = new ChangesSaveErrorLog(config.getStorageDir(), config.getRepositoryName(), config.getWorkspaceName());
            this.receiver = new AsyncReceiverImpl(this.channel, this.exportServer, config.getOtherParticipantsPriority());
            this.exporter = new RemoteExporterImpl(this.transmitter, this.receiver, config.getMergeTempDir(), fileCleaner, maxBufferSize, holder);
            this.mergeManager = new MergeDataManager(this.exporter, (DataManager)dataManager, ntManager, config.getMergeTempDir(), fileCleaner, maxBufferSize, holder);
            this.initializer = new AsyncInitializer(this.channel, config.getPriority(), config.getOtherParticipantsPriority(), config.getWaitAllMembersTimeout(), true);
            this.publisher = new ChangesPublisherImpl(this.initializer, this.transmitter, this.localStorage);
            this.subscriber = new ChangesSubscriberImpl(this.initializer, this.transmitter, this.synchronyzer, this.mergeManager, this.incomeStorage, this.changesSaveErrorLog, config.getWaitAllMembersTimeout(), config.getPriority(), config.getOtherParticipantsPriority().size() + 1, fileCleaner, maxBufferSize, holder);
            this.channel.addPacketListener(this.receiver);
            this.channel.addPacketListener(this.initializer);
            this.channel.addStateListener(this.initializer);
            this.channel.addConnectionListener(this);
            this.receiver.setChangesSubscriber(this.subscriber);
            this.initializer.addRemoteListener(this.localStorage);
            this.initializer.addRemoteListener(this.incomeStorage);
            this.initializer.addRemoteListener(this.publisher);
            this.initializer.addRemoteListener(this.exportServer);
            this.initializer.addRemoteListener(this.subscriber);
            this.publisher.addLocalListener(this.localStorage);
            this.publisher.addLocalListener(this.incomeStorage);
            this.publisher.addLocalListener(this.exportServer);
            this.publisher.addLocalListener(this.subscriber);
            this.publisher.addLocalListener(this.initializer);
            this.subscriber.addLocalListener(this.localStorage);
            this.subscriber.addLocalListener(this.incomeStorage);
            this.subscriber.addLocalListener(this.publisher);
            this.subscriber.addLocalListener(this.exportServer);
            this.subscriber.addLocalListener(this.initializer);
        }

        public void onDisconnect() {
            this.doFinalyze();
        }

        private void doFinalyze() {
            this.receiver.setChangesSubscriber(null);
            this.publisher.removeLocalListener(this.exportServer);
            this.publisher.removeLocalListener(this.subscriber);
            this.publisher.removeLocalListener(this.initializer);
            this.publisher.removeLocalListener(this.localStorage);
            this.publisher.removeLocalListener(this.incomeStorage);
            this.subscriber.removeLocalListener(this.publisher);
            this.subscriber.removeLocalListener(this.exportServer);
            this.subscriber.removeLocalListener(this.initializer);
            this.subscriber.removeLocalListener(this.localStorage);
            this.subscriber.removeLocalListener(this.incomeStorage);
            this.initializer.removeRemoteListener(this.subscriber);
            this.initializer.removeRemoteListener(this.publisher);
            this.initializer.removeRemoteListener(this.exportServer);
            this.initializer.removeRemoteListener(this.localStorage);
            this.initializer.removeRemoteListener(this.incomeStorage);
            this.channel.removePacketListener(this.receiver);
            this.channel.removePacketListener(this.initializer);
            this.channel.removeStateListener(this.initializer);
            this.exporter.cleanup();
            AsyncReplication.this.currentWorkers.remove(this);
            this.dataContainer.setReadOnly(false);
            LOG.info((Object)"Synchronization done.");
        }

        public void run() {
            try {
                this.dataContainer.setReadOnly(true);
                this.channel.connect();
            }
            catch (ReplicationException e) {
                LOG.error((Object)("Synchronization start error " + e), (Throwable)e);
                this.doFinalyze();
            }
        }
    }
}

