/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.util.Calendar;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Workspace;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.picocontainer.Startable;

@Path(value="/async-test/")
public class AsyncTestAdapter
implements Startable,
ResourceContainer {
    private static final String ASYNC_ROOT_NODE = "AsyncFolder";
    protected SessionImpl session;
    protected Workspace workspace;
    protected RepositoryImpl repository;
    protected RepositoryService repositoryService;
    protected Node root;

    public AsyncTestAdapter(RepositoryService repositoryService, OrganizationService orgService) throws Exception {
        this.repositoryService = repositoryService;
    }

    @GET
    @Path(value="/addAsyncFolder")
    public void addAsyncFolder() throws Exception {
        this.root.addNode(ASYNC_ROOT_NODE, "nt:folder");
        this.session.save();
    }

    @GET
    @Path(value="/addFileA")
    public void addFileA() throws Exception {
        Node node = this.root.getNode(ASYNC_ROOT_NODE).addNode("fileA.txt", "nt:file");
        node.addMixin("mix:versionable");
        Node content = node.addNode("jcr:content", "nt:resource");
        content.addMixin("dc:elementSet");
        content.setProperty("jcr:mimeType", "text/plain");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        this.setValue(node, "version1");
        this.session.save();
    }

    @GET
    @Path(value="/addFolder1")
    public void addFolder1() throws Exception {
        this.root.getNode(ASYNC_ROOT_NODE).addNode("folder1", "nt:folder");
        this.session.save();
    }

    @GET
    @Path(value="/checkinCheckoutFileA")
    public void checkinCheckoutFileA() throws Exception {
        Node node = this.getFileA();
        node.checkin();
        node.checkout();
        this.setValue(node, "version2");
        this.session.save();
    }

    @GET
    @Path(value="/restoreFileA")
    public void restoreFileA() throws Exception {
        this.getFileA().restore("1", false);
        this.session.save();
    }

    @GET
    @Path(value="/deleteFileA")
    public void deleteFileA() throws Exception {
        this.getFileA().remove();
        this.session.save();
    }

    @GET
    @Path(value="/moveFileA2Folder1")
    public void moveFileA() throws Exception {
        this.session.move("/AsyncFolder/fileA.txt", "/AsyncFolder/folder1/fileA.txt");
        this.session.save();
    }

    @GET
    @Path(value="/editFileASetValueL")
    public void editFileASetValueL() throws Exception {
        this.setValue(this.getFileA(), "valueL");
        this.session.save();
    }

    @GET
    @Path(value="/editFileASetValueH")
    public void editFileASetValueH() throws Exception {
        this.setValue(this.getFileA(), "valueH");
        this.session.save();
    }

    @GET
    @Path(value="/clean")
    public void clean() throws Exception {
        this.root.getNode(ASYNC_ROOT_NODE).remove();
        this.session.save();
    }

    private Node getFileA() throws Exception {
        Node node;
        try {
            node = this.root.getNode(ASYNC_ROOT_NODE).getNode("fileA.txt");
        }
        catch (PathNotFoundException e) {
            node = this.root.getNode(ASYNC_ROOT_NODE).getNode("folder1").getNode("fileA.txt");
        }
        return node;
    }

    private void setValue(Node node, String value) throws Exception {
        node.getNode("jcr:content").setProperty("jcr:data", value);
    }

    public void start() {
        try {
            this.repository = (RepositoryImpl)this.repositoryService.getDefaultRepository();
            CredentialsImpl credentials = new CredentialsImpl("root", "exo".toCharArray());
            this.session = (SessionImpl)this.repository.login((Credentials)credentials, this.repository.getSystemWorkspaceName());
            this.workspace = this.session.getWorkspace();
            this.root = this.session.getRootNode();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initilize data", e);
        }
    }

    public void stop() {
    }
}

