/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.IOException;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.ext.replication.async.AbstractMergeManager;
import org.exoplatform.services.jcr.ext.replication.async.MergeDataManagerException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporter;
import org.exoplatform.services.jcr.ext.replication.async.analyze.AddAnalyzer;
import org.exoplatform.services.jcr.ext.replication.async.analyze.DeleteAnalyzer;
import org.exoplatform.services.jcr.ext.replication.async.analyze.MixinAnalyzer;
import org.exoplatform.services.jcr.ext.replication.async.analyze.RenameAnalyzer;
import org.exoplatform.services.jcr.ext.replication.async.analyze.UpdateAnalyzer;
import org.exoplatform.services.jcr.ext.replication.async.resolve.ConflictResolver;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.CompositeItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.MemberChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeDataManager
extends AbstractMergeManager {
    protected final FileCleaner fileCleaner;
    protected final int maxBufferSize;
    private final ReaderSpoolFileHolder holder;

    MergeDataManager(RemoteExporter exporter, DataManager dataManager, NodeTypeDataManager ntManager, String storageDir, FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) {
        super(exporter, dataManager, ntManager, storageDir);
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangesStorage<ItemState> merge(Iterator<MemberChangesStorage<ItemState>> membersChanges) throws RepositoryException, RemoteExportException, IOException, ClassCastException, ClassNotFoundException, MergeDataManagerException, StorageRuntimeException {
        try {
            MemberChangesStorage<ItemState> first = membersChanges.next();
            CompositeItemStatesStorage<Object> accumulated = new CompositeItemStatesStorage<ItemState>(this.makePath("accumulated-" + first.getMember().getPriority()), first.getMember(), this.resHolder, this.fileCleaner, this.maxBufferSize, this.holder);
            CompositeItemStatesStorage<ItemState> result = new CompositeItemStatesStorage<ItemState>(this.makePath("result"), this.localMember, this.resHolder, this.fileCleaner, this.maxBufferSize, this.holder);
            if (this.localMember.getPriority() == first.getMember().getPriority()) {
                accumulated.addAll(first);
            }
            while (membersChanges.hasNext() && this.run) {
                MemberChangesStorage<ItemState> local;
                MemberChangesStorage<ItemState> income;
                boolean isLocalPriority;
                MemberChangesStorage<ItemState> second = membersChanges.next();
                boolean bl = isLocalPriority = this.localMember.getPriority() >= second.getMember().getPriority();
                if (isLocalPriority) {
                    income = first;
                    local = second;
                } else {
                    income = second;
                    local = first;
                }
                LOG.info((Object)("Merge changes (local=" + isLocalPriority + ") from " + first.getMember().getPriority() + " (" + first.getMember().getAddress() + ") and " + second.getMember().getPriority() + " (" + second.getMember().getAddress() + ") members"));
                CompositeItemStatesStorage<ItemState> iteration = new CompositeItemStatesStorage<ItemState>(this.makePath(first.getMember(), second.getMember()), second.getMember(), this.resHolder, this.fileCleaner, this.maxBufferSize, this.holder);
                this.exporter.setRemoteMember(second.getMember().getAddress());
                ConflictResolver conflictResolver = new ConflictResolver(isLocalPriority, local, income, this.exporter, this.dataManager, this.ntManager);
                AddAnalyzer addAnalyzer = new AddAnalyzer(isLocalPriority, this.dataManager, this.ntManager);
                RenameAnalyzer renameAnalyzer = new RenameAnalyzer(isLocalPriority, this.dataManager, this.ntManager);
                UpdateAnalyzer updateAnalyzer = new UpdateAnalyzer(isLocalPriority, this.dataManager, this.ntManager);
                MixinAnalyzer mixinAnalyzer = new MixinAnalyzer(isLocalPriority, this.dataManager, this.ntManager);
                DeleteAnalyzer deleteAnalyzer = new DeleteAnalyzer(isLocalPriority, this.dataManager, this.ntManager);
                if (!this.run) continue;
                Iterator changes = income.getChanges();
                if (changes.hasNext()) {
                    while (changes.hasNext() && this.run) {
                        ItemState incomeChange = (ItemState)changes.next();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("\t\tAnalyzing income item " + ItemState.nameFromValue((int)incomeChange.getState()) + " " + incomeChange.getData().getQPath().getAsString()));
                        }
                        if (!incomeChange.getData().isNode() && (incomeChange.getData().getQPath().getName().equals((Object)Constants.JCR_LOCKISDEEP) || incomeChange.getData().getQPath().getName().equals((Object)Constants.JCR_LOCKOWNER)) || incomeChange.getData().getIdentifier().equals("00exo0jcr0root0uuid0000000000000")) continue;
                        switch (incomeChange.getState()) {
                            case 1: {
                                addAnalyzer.analyze(incomeChange, local, income, conflictResolver);
                                break;
                            }
                            case 4: {
                                if (incomeChange.isPersisted()) {
                                    deleteAnalyzer.analyze(incomeChange, local, income, conflictResolver);
                                    break;
                                }
                                Object nextIncomeChange = income.findNextState(incomeChange, incomeChange.getData().getIdentifier());
                                if (nextIncomeChange != null && nextIncomeChange.getState() == 32) {
                                    renameAnalyzer.analyze(incomeChange, local, income, conflictResolver);
                                    break;
                                }
                                if (nextIncomeChange != null && nextIncomeChange.getState() == 2) {
                                    updateAnalyzer.analyze(incomeChange, local, income, conflictResolver);
                                    break;
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Income changes log: " + income.dump()));
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Local changes log: " + local.dump()));
                                }
                                throw new MergeDataManagerException("Can not resolve merge. Unknown DELETE sequence.[path=" + incomeChange.getData().getQPath().getAsString() + "][identifier=" + incomeChange.getData().getIdentifier() + "][parentIdentifier=" + incomeChange.getData().getParentIdentifier() + "]");
                            }
                            case 2: {
                                if (incomeChange.getData().isNode()) break;
                                updateAnalyzer.analyze(incomeChange, local, income, conflictResolver);
                                break;
                            }
                            case 16: {
                                mixinAnalyzer.analyze(incomeChange, local, income, conflictResolver);
                            }
                        }
                    }
                    conflictResolver.restore(iteration);
                    conflictResolver.applyIncomeChanges(iteration);
                }
                if (isLocalPriority) {
                    accumulated.delete();
                    accumulated = new CompositeItemStatesStorage(this.makePath("accumulated-" + second.getMember().getPriority()), second.getMember(), this.resHolder, this.fileCleaner, this.maxBufferSize, this.holder);
                    accumulated.addAll(second);
                    accumulated.addAll(iteration);
                    if (this.localMember.getPriority() == second.getMember().getPriority()) {
                        result.addAll(iteration);
                    }
                } else {
                    accumulated.addAll(iteration);
                    result.addAll(iteration);
                }
                first = accumulated;
            }
            CompositeItemStatesStorage<ItemState> compositeItemStatesStorage = result;
            return compositeItemStatesStorage;
        }
        finally {
            this.run = true;
        }
    }
}

