/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReceiver;
import org.exoplatform.services.jcr.ext.replication.async.AsyncTransmitter;
import org.exoplatform.services.jcr.ext.replication.async.IncomeDataContext;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportClient;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportError;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportResponce;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporter;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.RandomChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.transport.MemberAddress;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteExporterImpl
implements RemoteExporter,
RemoteExportClient {
    public static final String FILE_PREFIX = "exporter";
    private static final Log LOG = ExoLogger.getLogger((String)"ext.RemoteExporterImpl");
    protected final AsyncTransmitter transmitter;
    protected final AsyncReceiver receiver;
    protected final ResourcesHolder resHolder = new ResourcesHolder();
    protected final File tempDir;
    protected final ReaderSpoolFileHolder holder;
    protected MemberAddress remoteMember;
    private IncomeDataContext context;
    private CountDownLatch latch;
    private RemoteExportException exception = null;
    protected final FileCleaner fileCleaner;
    protected final int maxBufferSize;

    RemoteExporterImpl(AsyncTransmitter transmitter, AsyncReceiver receiver, String tempDir, FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) {
        this.transmitter = transmitter;
        this.receiver = receiver;
        this.tempDir = new File(tempDir);
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
    }

    @Override
    public ChangesStorage<ItemState> exportItem(String nodeId) throws RemoteExportException {
        LOG.info((Object)("Remote EXPORT from member " + this.remoteMember + ", node " + nodeId));
        this.receiver.setRemoteExportListener(this);
        try {
            this.transmitter.sendGetExport(nodeId, this.remoteMember);
        }
        catch (IOException e) {
            throw new RemoteExportException(e);
        }
        this.latch = new CountDownLatch(1);
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RemoteExportException(e);
        }
        finally {
            this.receiver.removeRemoteExportListener();
            if (this.exception != null) {
                try {
                    throw new RemoteExportException(this.exception);
                }
                catch (Throwable throwable) {
                    this.exception = null;
                    throw throwable;
                }
            }
        }
        LOG.info((Object)("Remote EXPORT DONE from member " + this.remoteMember + ", node " + nodeId));
        try {
            RandomChangesFile changesFile = this.context.getChangesFile();
            changesFile.validate();
            if (this.context.getMember() == null) {
                throw new RemoteExportException("Changes owner (member) is not set");
            }
            ItemStatesStorage<ItemState> itemStatesStorage = new ItemStatesStorage<ItemState>(changesFile, this.context.getMember(), this.fileCleaner, this.maxBufferSize, this.holder);
            return itemStatesStorage;
        }
        catch (IOException e) {
            throw new RemoteExportException(e);
        }
        finally {
            this.context = null;
        }
    }

    @Override
    public void setRemoteMember(MemberAddress address) {
        this.remoteMember = address;
    }

    @Override
    public void onRemoteExport(RemoteExportResponce event) {
        try {
            if (this.context == null) {
                RandomChangesFile changesFile;
                try {
                    changesFile = new RandomChangesFile(File.createTempFile(FILE_PREFIX, "-" + event.getTimeStamp()), event.getCRC(), event.getTimeStamp(), this.resHolder);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException(e.getMessage());
                }
                this.context = new IncomeDataContext(changesFile, event.getMember(), event.getPacketsCount());
            }
            this.context.writeData(event.getBuffer(), event.getOffset());
            if (this.context.isFinished()) {
                this.latch.countDown();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Cannot save export changes", (Throwable)e);
            this.exception = new RemoteExportException(e);
            this.latch.countDown();
        }
    }

    @Override
    public void onRemoteError(RemoteExportError event) {
        this.exception = new RemoteExportException(event.getErrorMessage());
        this.latch.countDown();
    }

    @Override
    public void cleanup() {
        try {
            this.resHolder.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Error of data fiels close " + e), (Throwable)e);
        }
        for (File f : this.tempDir.listFiles()) {
            if (f.delete()) continue;
            LOG.warn((Object)("Cannot delete exporter temp file " + f.getAbsolutePath()));
        }
    }
}

