/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.analyze;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.ext.replication.async.analyze.AbstractAnalyzer;
import org.exoplatform.services.jcr.ext.replication.async.resolve.ConflictResolver;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAnalyzer
extends AbstractAnalyzer {
    public AddAnalyzer(boolean localPriority, DataManager dataManager, NodeTypeDataManager ntManager) {
        super(localPriority, dataManager, ntManager);
    }

    @Override
    public void analyze(ItemState incomeChange, ChangesStorage<ItemState> local, ChangesStorage<ItemState> income, ConflictResolver confilictResolver) throws IOException, ClassCastException, ClassNotFoundException, RepositoryException {
        Iterator<ItemState> liter = local.getChanges();
        block12: while (liter.hasNext()) {
            QPath nextLocNodePath;
            QPath locNodePath;
            List<ItemState> updateSeq;
            ItemState nextLocalState;
            String parentIdentifier;
            InternalQName propertyName;
            ItemState localState = liter.next();
            ItemData incomeData = incomeChange.getData();
            ItemData localData = localState.getData();
            if (!localData.isNode() && (localData.getQPath().getName().equals((Object)Constants.JCR_LOCKISDEEP) || localData.getQPath().getName().equals((Object)Constants.JCR_LOCKOWNER)) || localData.getIdentifier().equals("00exo0jcr0root0uuid0000000000000")) continue;
            if (this.isLocalPriority()) {
                switch (localState.getState()) {
                    case 1: {
                        if (localData.isNode()) {
                            if (incomeData.isNode()) {
                                if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                                confilictResolver.add(incomeData.getQPath());
                                confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                                break;
                            }
                            if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                            propertyName = !incomeData.isNode() ? incomeData.getQPath().getName() : localData.getQPath().getName();
                            if (this.isPropertyAllowed(propertyName, (NodeData)this.dataManager.getItemData(parentIdentifier = !incomeData.isNode() ? incomeData.getParentIdentifier() : localData.getParentIdentifier()))) continue block12;
                            confilictResolver.add(incomeData.getQPath());
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            break;
                        }
                        if (!incomeData.isNode()) {
                            if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                            confilictResolver.add(incomeData.getQPath());
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            break;
                        }
                        if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                        propertyName = !incomeData.isNode() ? incomeData.getQPath().getName() : localData.getQPath().getName();
                        if (this.isPropertyAllowed(propertyName, (NodeData)this.dataManager.getItemData(parentIdentifier = !incomeData.isNode() ? incomeData.getParentIdentifier() : localData.getParentIdentifier()))) continue block12;
                        confilictResolver.add(incomeData.getQPath());
                        confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                        break;
                    }
                    case 4: {
                        if (localState.isPersisted()) {
                            if (!localData.isNode()) break;
                            if (incomeData.isNode()) {
                                if (!incomeData.getQPath().isDescendantOf(localData.getQPath()) && !incomeData.getQPath().equals((Object)localData.getQPath())) break;
                                confilictResolver.add(incomeData.getQPath());
                                confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                                break;
                            }
                            if (!incomeData.getQPath().isDescendantOf(localData.getQPath())) break;
                            confilictResolver.add(incomeData.getQPath());
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            break;
                        }
                        nextLocalState = local.findNextState(localState, localData.getIdentifier());
                        if (nextLocalState != null && nextLocalState.getState() == 2) {
                            updateSeq = local.getUpdateSequence(localState);
                            for (ItemState item : updateSeq) {
                                if (!incomeData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                                confilictResolver.add(incomeData.getQPath());
                                confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                                break;
                            }
                        }
                        if (nextLocalState != null && nextLocalState.getState() == 32) {
                            locNodePath = localData.isNode() ? localData.getQPath() : localData.getQPath().makeParentPath();
                            QPath qPath = nextLocNodePath = localData.isNode() ? nextLocalState.getData().getQPath() : nextLocalState.getData().getQPath().makeParentPath();
                            if (incomeData.getQPath().isDescendantOf(locNodePath) || incomeData.getQPath().equals((Object)locNodePath) || incomeData.getQPath().isDescendantOf(nextLocNodePath) || incomeData.getQPath().equals((Object)nextLocNodePath) || nextLocNodePath.isDescendantOf(incomeData.getQPath()) || nextLocNodePath.equals((Object)incomeData.getQPath())) {
                                confilictResolver.add(incomeData.getQPath());
                                confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                                break;
                            }
                        }
                    }
                    case 2: {
                        break;
                    }
                    case 32: {
                        break;
                    }
                }
                continue;
            }
            switch (localState.getState()) {
                case 1: {
                    if (localData.isNode()) {
                        if (incomeData.isNode()) {
                            if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                            confilictResolver.add(localData.getQPath());
                            break;
                        }
                        if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                        propertyName = !incomeData.isNode() ? incomeData.getQPath().getName() : localData.getQPath().getName();
                        if (this.isPropertyAllowed(propertyName, (NodeData)this.dataManager.getItemData(parentIdentifier = !incomeData.isNode() ? incomeData.getParentIdentifier() : localData.getParentIdentifier()))) continue block12;
                        confilictResolver.add(localData.getQPath());
                        break;
                    }
                    if (!incomeData.isNode()) {
                        if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                        confilictResolver.add(localData.getQPath());
                        break;
                    }
                    if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                    propertyName = !incomeData.isNode() ? incomeData.getQPath().getName() : localData.getQPath().getName();
                    if (this.isPropertyAllowed(propertyName, (NodeData)this.dataManager.getItemData(parentIdentifier = !incomeData.isNode() ? incomeData.getParentIdentifier() : localData.getParentIdentifier()))) continue block12;
                    confilictResolver.add(localData.getQPath());
                    break;
                }
                case 4: {
                    if (localState.isPersisted()) {
                        if (!localData.isNode()) break;
                        if (incomeData.isNode()) {
                            if (!incomeData.getQPath().isDescendantOf(localData.getQPath()) && !incomeData.getQPath().equals((Object)localData.getQPath())) break;
                            confilictResolver.add(localData.getQPath());
                            break;
                        }
                        if (!incomeData.getQPath().isDescendantOf(localData.getQPath())) break;
                        confilictResolver.add(localData.getQPath());
                        break;
                    }
                    nextLocalState = local.findNextState(localState, localData.getIdentifier());
                    if (nextLocalState != null && nextLocalState.getState() == 2) {
                        updateSeq = local.getUpdateSequence(localState);
                        for (ItemState st : updateSeq) {
                            if (!incomeData.getQPath().isDescendantOf(st.getData().getQPath())) continue;
                            confilictResolver.add(st.getData().getQPath());
                        }
                        continue block12;
                    }
                    if (nextLocalState != null && nextLocalState.getState() == 32) {
                        locNodePath = localData.isNode() ? localData.getQPath() : localData.getQPath().makeParentPath();
                        QPath qPath = nextLocNodePath = localData.isNode() ? nextLocalState.getData().getQPath() : nextLocalState.getData().getQPath().makeParentPath();
                        if (!incomeData.getQPath().isDescendantOf(locNodePath) && !incomeData.getQPath().equals((Object)locNodePath) && !incomeData.getQPath().isDescendantOf(nextLocNodePath) && !incomeData.getQPath().equals((Object)nextLocNodePath) && !nextLocNodePath.isDescendantOf(incomeData.getQPath()) && !nextLocNodePath.equals((Object)incomeData.getQPath())) break;
                        confilictResolver.addAll(local.getUniquePathesByUUID(localData.isNode() ? localData.getIdentifier() : localData.getParentIdentifier()));
                        break;
                    }
                }
                case 2: {
                    break;
                }
                case 32: {
                    break;
                }
            }
        }
    }
}

