/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.analyze;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.ext.replication.async.analyze.AbstractAnalyzer;
import org.exoplatform.services.jcr.ext.replication.async.resolve.ConflictResolver;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateAnalyzer
extends AbstractAnalyzer {
    public UpdateAnalyzer(boolean localPriority, DataManager dataManager, NodeTypeDataManager ntManager) {
        super(localPriority, dataManager, ntManager);
    }

    @Override
    public void analyze(ItemState incomeChange, ChangesStorage<ItemState> local, ChangesStorage<ItemState> income, ConflictResolver confilictResolver) throws IOException, ClassCastException, ClassNotFoundException {
        List<ItemState> incUpdateSeq = income.getUpdateSequence(incomeChange);
        Iterator<ItemState> liter = local.getChanges();
        block14: while (liter.hasNext()) {
            List<ItemState> locUpdateSeq;
            QPath nextLocNodePath;
            QPath locNodePath;
            ItemState nextLocalState;
            ItemState localState = liter.next();
            ItemData incomeData = incomeChange.getData();
            ItemData localData = localState.getData();
            if (!localData.isNode() && (localData.getQPath().getName().equals((Object)Constants.JCR_LOCKISDEEP) || localData.getQPath().getName().equals((Object)Constants.JCR_LOCKOWNER)) || localData.getIdentifier().equals("00exo0jcr0root0uuid0000000000000")) continue;
            if (this.isLocalPriority()) {
                switch (localState.getState()) {
                    case 1: {
                        if (!incomeData.isNode()) break;
                        for (ItemState st : incUpdateSeq) {
                            if (!localData.getQPath().isDescendantOf(st.getData().getQPath())) continue;
                            confilictResolver.add(st.getData().getQPath());
                            confilictResolver.addSkippedVSChanges(st.getData().getIdentifier());
                        }
                        continue block14;
                    }
                    case 4: {
                        if (localState.isPersisted()) {
                            if (localData.isNode()) {
                                if (incomeData.isNode()) {
                                    for (ItemState item : incUpdateSeq) {
                                        if (!item.getData().getQPath().isDescendantOf(localData.getQPath()) && !item.getData().getQPath().equals((Object)localData.getQPath()) && !localData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                                        confilictResolver.add(item.getData().getQPath());
                                        confilictResolver.addSkippedVSChanges(item.getData().getIdentifier());
                                    }
                                    continue block14;
                                }
                                if (!incomeData.getQPath().isDescendantOf(localData.getQPath())) break;
                                confilictResolver.add(incomeData.getQPath());
                                confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                                break;
                            }
                            if (incomeData.isNode()) {
                                for (ItemState item : incUpdateSeq) {
                                    if (!localData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                                    confilictResolver.add(item.getData().getQPath());
                                    confilictResolver.addSkippedVSChanges(item.getData().getIdentifier());
                                }
                                continue block14;
                            }
                            if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                            confilictResolver.add(incomeData.getQPath());
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            break;
                        }
                        nextLocalState = local.findNextState(localState, localData.getIdentifier());
                        if (nextLocalState != null && nextLocalState.getState() == 32) {
                            locNodePath = localData.isNode() ? localData.getQPath() : localData.getQPath().makeParentPath();
                            QPath qPath = nextLocNodePath = localData.isNode() ? nextLocalState.getData().getQPath() : nextLocalState.getData().getQPath().makeParentPath();
                            if (incomeData.isNode()) {
                                for (ItemState item : incUpdateSeq) {
                                    if (!item.getData().getQPath().isDescendantOf(locNodePath) && !item.getData().getQPath().equals((Object)locNodePath) && !locNodePath.isDescendantOf(item.getData().getQPath()) && !nextLocNodePath.isDescendantOf(item.getData().getQPath())) continue;
                                    confilictResolver.add(item.getData().getQPath());
                                    confilictResolver.addSkippedVSChanges(item.getData().getIdentifier());
                                }
                                continue block14;
                            }
                            if (!incomeData.getQPath().isDescendantOf(locNodePath)) break;
                            confilictResolver.add(incomeData.getQPath());
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            break;
                        }
                        if (nextLocalState != null && nextLocalState.getState() == 2) {
                            locUpdateSeq = local.getUpdateSequence(localState);
                            if (incomeData.isNode()) {
                                for (ItemState locSt : locUpdateSeq) {
                                    for (ItemState incSt : incUpdateSeq) {
                                        if (!locSt.getData().getQPath().isDescendantOf(incSt.getData().getQPath()) && !locSt.getData().getQPath().equals((Object)incSt.getData().getQPath()) && !incSt.getData().getQPath().isDescendantOf(locSt.getData().getQPath())) continue;
                                        confilictResolver.add(incSt.getData().getQPath());
                                        confilictResolver.addSkippedVSChanges(incSt.getData().getIdentifier());
                                    }
                                }
                                continue block14;
                            }
                            for (ItemState locSt : locUpdateSeq) {
                                if (!incomeData.getQPath().isDescendantOf(locSt.getData().getQPath())) continue;
                                confilictResolver.add(incomeData.getQPath());
                                confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            }
                            continue block14;
                        }
                    }
                    case 2: {
                        if (localData.isNode()) break;
                        if (incomeData.isNode()) {
                            for (ItemState item : incUpdateSeq) {
                                if (!localData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                                confilictResolver.add(item.getData().getQPath());
                                confilictResolver.addSkippedVSChanges(item.getData().getIdentifier());
                            }
                            continue block14;
                        }
                        if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                        confilictResolver.add(incomeData.getQPath());
                        confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 16: {
                        if (!incomeData.isNode()) break;
                        for (ItemState st : incUpdateSeq) {
                            if (!localData.getQPath().isDescendantOf(st.getData().getQPath()) && !localData.getQPath().equals((Object)st.getData().getQPath())) continue;
                            confilictResolver.add(incomeData.getQPath());
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                        }
                        break;
                    }
                }
                continue;
            }
            block7 : switch (localState.getState()) {
                case 1: {
                    if (!incomeData.isNode()) break;
                    for (ItemState st : incUpdateSeq) {
                        if (!localData.getQPath().isDescendantOf(st.getData().getQPath())) continue;
                        confilictResolver.add(localData.getQPath());
                        break block7;
                    }
                    continue block14;
                }
                case 4: {
                    if (localState.isPersisted()) {
                        if (localData.isNode()) {
                            if (incomeData.isNode()) {
                                for (ItemState item : incUpdateSeq) {
                                    if (!item.getData().getQPath().equals((Object)localData.getQPath()) && !localData.getQPath().isDescendantOf(item.getData().getQPath()) && !item.getData().getQPath().isDescendantOf(localData.getQPath())) continue;
                                    confilictResolver.add(localData.getQPath());
                                }
                                continue block14;
                            }
                            if (!incomeData.getQPath().isDescendantOf(localData.getQPath())) break;
                            confilictResolver.add(localData.getQPath());
                            break;
                        }
                        if (incomeData.isNode()) {
                            for (ItemState item : incUpdateSeq) {
                                if (!localData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                                confilictResolver.add(localData.getQPath());
                            }
                            continue block14;
                        }
                        if (!localData.getQPath().equals((Object)incomeData.getQPath())) break;
                        confilictResolver.add(localData.getQPath());
                        break;
                    }
                    nextLocalState = local.findNextState(localState, localData.getIdentifier());
                    if (nextLocalState != null && nextLocalState.getState() == 2) {
                        locUpdateSeq = local.getUpdateSequence(localState);
                        if (incomeData.isNode()) {
                            for (ItemState locSt : locUpdateSeq) {
                                for (ItemState incSt : incUpdateSeq) {
                                    if (!locSt.getData().getQPath().isDescendantOf(incSt.getData().getQPath()) && !locSt.getData().getQPath().equals((Object)incSt.getData().getQPath()) && !incSt.getData().getQPath().isDescendantOf(locSt.getData().getQPath())) continue;
                                    confilictResolver.add(localData.getQPath());
                                }
                            }
                            continue block14;
                        }
                        for (ItemState locSt : locUpdateSeq) {
                            if (!incomeData.getQPath().isDescendantOf(locSt.getData().getQPath())) continue;
                            confilictResolver.add(locSt.getData().getQPath());
                        }
                        continue block14;
                    }
                    if (nextLocalState != null && nextLocalState.getState() == 32) {
                        locNodePath = localData.isNode() ? localData.getQPath() : localData.getQPath().makeParentPath();
                        QPath qPath = nextLocNodePath = localData.isNode() ? nextLocalState.getData().getQPath() : nextLocalState.getData().getQPath().makeParentPath();
                        if (incomeData.isNode()) {
                            for (ItemState st : incUpdateSeq) {
                                if (!st.getData().getQPath().isDescendantOf(locNodePath) && !st.getData().getQPath().equals((Object)locNodePath) && !locNodePath.isDescendantOf(st.getData().getQPath()) && !nextLocNodePath.isDescendantOf(st.getData().getQPath())) continue;
                                confilictResolver.addAll(local.getUniquePathesByUUID(localData.isNode() ? localData.getIdentifier() : localData.getParentIdentifier()));
                            }
                            continue block14;
                        }
                        if (!incomeData.getQPath().isDescendantOf(locNodePath)) break;
                        confilictResolver.addAll(local.getUniquePathesByUUID(localData.isNode() ? localData.getIdentifier() : localData.getParentIdentifier()));
                        break;
                    }
                }
                case 2: {
                    if (!localData.isNode()) {
                        if (!incomeData.isNode()) break;
                        for (ItemState item : incUpdateSeq) {
                            if (!localData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                            confilictResolver.add(localData.getQPath());
                        }
                        continue block14;
                    }
                    if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                    confilictResolver.add(localData.getQPath());
                    break;
                }
                case 32: {
                    break;
                }
                case 16: {
                    if (!incomeData.isNode()) break;
                    for (ItemState st : incUpdateSeq) {
                        if (!localData.getQPath().isDescendantOf(st.getData().getQPath()) && !localData.getQPath().equals((Object)st.getData().getQPath())) continue;
                        confilictResolver.add(localData.getQPath());
                    }
                    break;
                }
            }
        }
    }
}

