/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncWorkspaceConfig
extends BaseComponentPlugin {
    private static final int ONE_SECOND = 1000;
    protected final int priority;
    protected final List<Integer> otherParticipantsPriority;
    protected final String bindIPAddress;
    protected final String channelConfig;
    protected final String channelName;
    protected final int waitAllMembersTimeout;
    protected final String mergeTempDir;
    protected final String storageDir;
    protected final String localStorageDir;
    protected final String incomeStorageDir;
    protected final String repositoryName;
    protected final String workspaceName;

    public AsyncWorkspaceConfig(InitParams params) {
        PropertiesParam pps = params.getPropertiesParam("async-workspca-config");
        if (pps == null) {
            throw new RuntimeException("replication-properties not specified");
        }
        this.repositoryName = pps.getProperty("repository-name");
        if (this.repositoryName == null) {
            throw new RuntimeException("repository-name not specified");
        }
        this.workspaceName = pps.getProperty("workspace-name");
        if (this.workspaceName == null) {
            throw new RuntimeException("workspace-name not specified");
        }
        if (pps.getProperty("priority") == null) {
            throw new RuntimeException("priority not specified");
        }
        this.priority = Integer.parseInt(pps.getProperty("priority"));
        this.bindIPAddress = pps.getProperty("bind-ip-address");
        String chConfig = pps.getProperty("channel-config");
        if (chConfig == null) {
            throw new RuntimeException("channel-config not specified");
        }
        this.channelConfig = chConfig.replaceAll("[$]bind-ip-address", this.bindIPAddress);
        this.channelName = pps.getProperty("channel-name");
        if (this.channelName == null) {
            throw new RuntimeException("channel-config not specified");
        }
        if (pps.getProperty("wait-all-members") == null) {
            throw new RuntimeException("wait-all-members timeout not specified");
        }
        this.waitAllMembersTimeout = Integer.parseInt(pps.getProperty("wait-all-members")) * 1000;
        this.storageDir = pps.getProperty("storage-dir");
        if (this.storageDir == null) {
            throw new RuntimeException("storage-dir not specified");
        }
        String sOtherParticipantsPriority = pps.getProperty("other-participants-priority");
        if (sOtherParticipantsPriority == null) {
            throw new RuntimeException("other-participants-priority not specified");
        }
        this.otherParticipantsPriority = new ArrayList<Integer>();
        for (String sPriority : sOtherParticipantsPriority.split(",")) {
            this.otherParticipantsPriority.add(Integer.valueOf(sPriority));
        }
        if (this.hasDuplicatePriority(this.otherParticipantsPriority, this.priority)) {
            throw new RuntimeException("The value of priority is duplicated : Priority = " + this.priority + " ; " + "Other participants priority = " + this.otherParticipantsPriority);
        }
        File incomeDir = new File(this.storageDir + "/income");
        incomeDir.mkdirs();
        this.incomeStorageDir = incomeDir.getAbsolutePath();
        File localDir = new File(this.storageDir + "/local");
        localDir.mkdirs();
        this.localStorageDir = localDir.getAbsolutePath();
        File mergeTempDir = new File(this.storageDir + "/merge-temp");
        mergeTempDir.mkdirs();
        this.mergeTempDir = mergeTempDir.getAbsolutePath();
    }

    private boolean hasDuplicatePriority(List<Integer> other, int ownPriority) {
        if (other.contains(ownPriority)) {
            return true;
        }
        for (int i = 0; i < other.size(); ++i) {
            int pri = other.get(i);
            ArrayList<Integer> oth = new ArrayList<Integer>(other);
            oth.remove(i);
            if (!oth.contains(pri)) continue;
            return true;
        }
        return false;
    }

    public int getPriority() {
        return this.priority;
    }

    public List<Integer> getOtherParticipantsPriority() {
        return this.otherParticipantsPriority;
    }

    public String getBindIPAddress() {
        return this.bindIPAddress;
    }

    public String getChannelConfig() {
        return this.channelConfig;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public int getWaitAllMembersTimeout() {
        return this.waitAllMembersTimeout;
    }

    public String getMergeTempDir() {
        return this.mergeTempDir;
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public String getLocalStorageDir() {
        return this.localStorageDir;
    }

    public String getIncomeStorageDir() {
        return this.incomeStorageDir;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }
}

