/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.resolve;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.QName;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporter;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.EditableChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.MemberChangesStorage;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictResolver {
    private final MemberChangesStorage<ItemState> local;
    private final MemberChangesStorage<ItemState> income;
    private final List<QPath> conflictedPathes;
    private final List<QPath> VSSkippedPathes = new ArrayList<QPath>();
    private final RemoteExporter exporter;
    private final DataManager dataManager;
    private final NodeTypeDataManager ntManager;
    private final boolean isLocalPriority;
    private static final Log LOG = ExoLogger.getLogger((String)"jcr.ConflictResolver");

    public ConflictResolver(boolean isLocalPriority, MemberChangesStorage<ItemState> local, MemberChangesStorage<ItemState> income, RemoteExporter exporter, DataManager dataManager, NodeTypeDataManager ntManager) {
        this.conflictedPathes = new ArrayList<QPath>();
        this.local = local;
        this.income = income;
        this.exporter = exporter;
        this.isLocalPriority = isLocalPriority;
        this.dataManager = dataManager;
        this.ntManager = ntManager;
    }

    public void addSkippedVSChanges(String identifier) throws ClassCastException, IOException, ClassNotFoundException {
        QPath skippedPath = this.income.findVSChanges(identifier);
        if (skippedPath != null) {
            this.VSSkippedPathes.add(skippedPath);
        }
    }

    public void add(QPath path) {
        for (int i = this.conflictedPathes.size() - 1; i >= 0; --i) {
            if (path.equals((Object)this.conflictedPathes.get(i)) || path.isDescendantOf(this.conflictedPathes.get(i))) {
                return;
            }
            if (!this.conflictedPathes.get(i).isDescendantOf(path)) continue;
            this.conflictedPathes.remove(i);
        }
        this.conflictedPathes.add(path);
    }

    public void addAll(List<QPath> pathes) {
        block0: for (int j = 0; j < pathes.size(); ++j) {
            QPath path = pathes.get(j);
            for (int i = this.conflictedPathes.size() - 1; i >= 0; --i) {
                if (path.equals((Object)this.conflictedPathes.get(i)) || path.isDescendantOf(this.conflictedPathes.get(i))) continue block0;
                if (!this.conflictedPathes.get(i).isDescendantOf(path)) continue;
                this.conflictedPathes.remove(i);
            }
            this.conflictedPathes.add(path);
        }
    }

    public void restore(EditableChangesStorage<ItemState> iteration) throws ClassCastException, IOException, ClassNotFoundException, RemoteExportException, RepositoryException {
        if (!this.isLocalPriority) {
            this.restoreAddedItems(iteration);
            this.restoreDeletedItems(iteration);
            this.restoreUpdatedSNSItems(iteration);
        }
    }

    public void applyIncomeChanges(EditableChangesStorage<ItemState> iteration) throws ClassCastException, IOException, ClassNotFoundException, RepositoryException {
        if (this.isLocalPriority) {
            Iterator itemStates = this.income.getChanges();
            while (itemStates.hasNext()) {
                ItemState item = (ItemState)itemStates.next();
                if (item.getData().getQPath().getName().equals((Object)Constants.JCR_LOCKISDEEP) || item.getData().getQPath().getName().equals((Object)Constants.JCR_LOCKOWNER) || item.getData().getIdentifier().equals("00exo0jcr0root0uuid0000000000000") || this.isChangesConflicted(item.getData().getQPath()) || this.isVSChangesConflicted(item.getData().getQPath())) continue;
                if (item.getState() == 4 && item.isPersisted() && item.isNode()) {
                    for (ItemState itemState : this.deleleLockProperties((NodeData)item.getData())) {
                        iteration.add(itemState);
                    }
                }
                iteration.add(item);
            }
        } else {
            Iterator itemStates = this.income.getChanges();
            while (itemStates.hasNext()) {
                ItemState item = (ItemState)itemStates.next();
                if (item.getData().getQPath().getName().equals((Object)Constants.JCR_LOCKISDEEP) || item.getData().getQPath().getName().equals((Object)Constants.JCR_LOCKOWNER) || item.getData().getIdentifier().equals("00exo0jcr0root0uuid0000000000000")) continue;
                if (item.getState() == 4 && item.isPersisted() && item.isNode()) {
                    for (ItemState itemState : this.deleleLockProperties((NodeData)item.getData())) {
                        iteration.add(itemState);
                    }
                }
                iteration.add(item);
            }
        }
    }

    private void restoreAddedItems(EditableChangesStorage<ItemState> iteration) throws ClassCastException, IOException, ClassNotFoundException, RepositoryException {
        for (int i = 0; i < this.conflictedPathes.size(); ++i) {
            List<ItemState> localChanges = this.local.getChanges(this.conflictedPathes.get(i));
            for (int j = localChanges.size() - 1; j >= 0; --j) {
                ItemState item = (ItemState)localChanges.get(j);
                if (item.getState() != 1 && item.getState() != 32 || this.hasState(localChanges, j + 1, item.getData().getIdentifier(), 4)) continue;
                if (item.isNode()) {
                    for (ItemState itemState : this.deleleLockProperties((NodeData)item.getData())) {
                        iteration.add(itemState);
                    }
                }
                if (item.getData().isNode()) {
                    NodeData node = (NodeData)item.getData();
                    TransientNodeData newNode = new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), node.getACL());
                    iteration.add(new ItemState((ItemData)newNode, 4, true, item.getData().getQPath()));
                    continue;
                }
                PropertyData prop = (PropertyData)item.getData();
                TransientPropertyData newProp = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued());
                iteration.add(new ItemState((ItemData)newProp, 4, true, item.getData().getQPath()));
            }
        }
    }

    private void restoreDeletedItems(EditableChangesStorage<ItemState> iteration) throws ClassCastException, IOException, ClassNotFoundException, RemoteExportException {
        for (int i = 0; i < this.conflictedPathes.size(); ++i) {
            List<ItemState> localChanges = this.local.getChanges(this.conflictedPathes.get(i));
            ArrayList<ItemState> restoredItems = new ArrayList<ItemState>();
            HashSet<QPath> needExportItem = new HashSet<QPath>();
            QPath rootExportPath = null;
            String rootExportIdentifier = null;
            HashSet<String> needExportItemVH = new HashSet<String>();
            for (int j = localChanges.size() - 1; j >= 0; --j) {
                Object incomeChange;
                ItemState item = (ItemState)localChanges.get(j);
                if (item.getState() == 4) {
                    QPath nodePath;
                    Object nextIncomeChange;
                    Object nextItem = this.local.findNextState(item, item.getData().getIdentifier());
                    if (nextItem != null && nextItem.getState() == 2 || this.getPrevState(localChanges, j, item.getData().getIdentifier()) != -1 && !this.hasPrevOnlyUpdateState(localChanges, j - 1, item.getData().getIdentifier())) continue;
                    if (nextItem != null && nextItem.getState() == 32) {
                        if (item.getData().isNode()) {
                            NodeData node = (NodeData)item.getData();
                            TransientNodeData newNode = new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), node.getACL());
                            restoredItems.add(new ItemState((ItemData)newNode, 1, true, node.getQPath()));
                            continue;
                        }
                        PropertyData prop = (PropertyData)item.getData();
                        TransientPropertyData newProp = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued());
                        newProp.setValues(((PropertyData)nextItem.getData()).getValues());
                        restoredItems.add(new ItemState((ItemData)newProp, 1, true, prop.getQPath()));
                        continue;
                    }
                    Object incomeChange2 = this.income.findItemState(item.getData().getIdentifier(), item.getData().getQPath(), 4);
                    if (incomeChange2 != null && ((nextIncomeChange = this.income.findNextState((ItemState)incomeChange2, incomeChange2.getData().getIdentifier())) == null || nextIncomeChange.getState() != 2)) {
                        restoredItems.add(new ItemState(item.getData(), 1, true, item.getData().getQPath()));
                        if (nextIncomeChange == null || nextIncomeChange.getState() != 32) continue;
                        if (incomeChange2.getData().isNode()) {
                            NodeData node = (NodeData)incomeChange2.getData();
                            TransientNodeData newNode = new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), node.getACL());
                            restoredItems.add(new ItemState((ItemData)newNode, 2, true, item.getData().getQPath()));
                            needExportItemVH.add(incomeChange2.getData().getIdentifier());
                            continue;
                        }
                        PropertyData prop = (PropertyData)incomeChange2.getData();
                        TransientPropertyData newProp = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued());
                        newProp.setValues(((PropertyData)nextIncomeChange.getData()).getValues());
                        restoredItems.add(new ItemState((ItemData)newProp, 2, true, item.getData().getQPath()));
                        continue;
                    }
                    if (!item.getData().isNode() && this.income.hasState(item.getData().getIdentifier(), item.getData().getQPath(), 2)) {
                        restoredItems.add(new ItemState(item.getData(), 1, true, item.getData().getQPath()));
                        continue;
                    }
                    needExportItem.add(item.getData().getQPath());
                    QPath qPath = nodePath = item.isNode() ? item.getData().getQPath() : item.getData().getQPath().makeParentPath();
                    if (rootExportPath != null && !rootExportPath.isDescendantOf(nodePath)) continue;
                    rootExportPath = nodePath;
                    rootExportIdentifier = item.isNode() ? item.getData().getIdentifier() : item.getData().getParentIdentifier();
                    continue;
                }
                if (item.getState() != 2 || item.getData().isNode() || this.getLastState(localChanges, item.getData().getIdentifier()) == 4 || this.getPrevState(localChanges, j, item.getData().getIdentifier()) != -1 || (incomeChange = this.income.findItemState(item.getData().getIdentifier(), item.getData().getQPath(), 2)) != null) continue;
                incomeChange = this.income.findItemState(item.getData().getIdentifier(), item.getData().getQPath(), 4);
                if (incomeChange != null) {
                    Object nextIncomeState = this.income.findNextState((ItemState)incomeChange, incomeChange.getData().getIdentifier());
                    if (nextIncomeState == null || nextIncomeState.getState() != 32) continue;
                    restoredItems.add(new ItemState(nextIncomeState.getData(), 2, true, item.getData().getQPath()));
                    continue;
                }
                needExportItem.add(item.getData().getQPath());
                QPath nodePath = item.getData().getQPath().makeParentPath();
                if (rootExportPath != null && !rootExportPath.isDescendantOf(nodePath)) continue;
                rootExportPath = nodePath;
                rootExportIdentifier = item.getData().getParentIdentifier();
            }
            if (rootExportIdentifier != null) {
                ChangesStorage<ItemState> exportedItems = this.exporter.exportItem(rootExportIdentifier);
                Iterator<ItemState> itemStates = exportedItems.getChanges();
                while (itemStates.hasNext()) {
                    ItemState item = itemStates.next();
                    if (!needExportItem.contains(item.getData().getQPath())) continue;
                    iteration.add(item);
                }
            }
            for (String uuid : needExportItemVH) {
                String vhUuid = this.income.findVHProperty(uuid);
                if (vhUuid == null) continue;
                iteration.addAll(this.exporter.exportItem(vhUuid));
            }
            for (int k = 0; k < restoredItems.size(); ++k) {
                iteration.add((ItemState)restoredItems.get(k));
            }
        }
    }

    private void restoreUpdatedSNSItems(EditableChangesStorage<ItemState> iteration) throws ClassCastException, IOException, ClassNotFoundException {
        for (int i = 0; i < this.conflictedPathes.size(); ++i) {
            List localChanges = this.local.getChanges(this.conflictedPathes.get(i));
            for (int j = localChanges.size() - 1; j >= 0; --j) {
                Object nextItem;
                ItemState curItem = (ItemState)localChanges.get(j);
                if (curItem.getState() != 4 || curItem.isPersisted() || (nextItem = this.local.findNextState(curItem, curItem.getData().getIdentifier())) == null || nextItem.getState() != 2) continue;
                List updateSeq = this.local.getUpdateSequence(curItem);
                for (int k = 1; k <= updateSeq.size() - 1; ++k) {
                    TransientNodeData newItem;
                    QPath name;
                    ItemState item = (ItemState)updateSeq.get(k);
                    NodeData node = (NodeData)item.getData();
                    if (k == 1) {
                        iteration.add(new ItemState(item.getData(), 4, item.isEventFire(), item.getData().getQPath(), item.isInternallyCreated(), false));
                    } else {
                        name = QPath.makeChildPath((QPath)node.getQPath().makeParentPath(), (QName)node.getQPath().getName(), (int)(node.getQPath().getIndex() - 1));
                        newItem = new TransientNodeData(name, node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), node.getACL());
                        iteration.add(new ItemState((ItemData)newItem, 2, item.isEventFire(), name, item.isInternallyCreated()));
                    }
                    if (k != updateSeq.size() - 1) continue;
                    item = (ItemState)updateSeq.get(1);
                    node = (NodeData)item.getData();
                    name = QPath.makeChildPath((QPath)node.getQPath().makeParentPath(), (QName)node.getQPath().getName(), (int)(updateSeq.size() - 1));
                    newItem = new TransientNodeData(name, node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), node.getACL());
                    iteration.add(new ItemState((ItemData)newItem, 2, item.isEventFire(), name, item.isInternallyCreated()));
                }
            }
        }
    }

    private int getLastState(List<ItemState> changes, String identifier) {
        for (int i = changes.size() - 1; i >= 0; --i) {
            if (!changes.get(i).getData().getIdentifier().equals(identifier)) continue;
            return changes.get(i).getState();
        }
        return -1;
    }

    private boolean hasState(List<ItemState> changes, int firstIndex, String identifier, int state) {
        for (int i = firstIndex; i < changes.size(); ++i) {
            if (changes.get(i).getState() != state || !changes.get(i).getData().getIdentifier().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPrevOnlyUpdateState(List<ItemState> changes, int lastIndex, String identifier) {
        for (int i = lastIndex; i >= 0; --i) {
            if (!changes.get(i).getData().getIdentifier().equals(identifier) || changes.get(i).getState() == 2) continue;
            return false;
        }
        return true;
    }

    private int getPrevState(List<ItemState> changes, int index, String identifier) {
        for (int i = index - 1; i >= 0; --i) {
            if (!changes.get(i).getData().getIdentifier().equals(identifier)) continue;
            return changes.get(i).getState();
        }
        return -1;
    }

    private List<ItemState> deleleLockProperties(NodeData node) throws RepositoryException {
        ArrayList<ItemState> result = new ArrayList<ItemState>();
        InternalQName[] mixinTypeNames = node.getMixinTypeNames();
        InternalQName primaryTypeName = node.getPrimaryTypeName();
        if (mixinTypeNames != null && primaryTypeName != null && this.ntManager.isNodeType(Constants.MIX_LOCKABLE, primaryTypeName, mixinTypeNames)) {
            ItemData item = this.dataManager.getItemData(node, new QPathEntry(Constants.JCR_LOCKISDEEP, 1));
            if (item != null) {
                result.add(new ItemState(item, 4, true, node.getQPath()));
            }
            if ((item = this.dataManager.getItemData(node, new QPathEntry(Constants.JCR_LOCKOWNER, 1))) != null) {
                result.add(new ItemState(item, 4, true, node.getQPath()));
            }
        }
        return result;
    }

    private boolean isChangesConflicted(QPath path) {
        for (int i = 0; i < this.conflictedPathes.size(); ++i) {
            if (!path.equals((Object)this.conflictedPathes.get(i)) && !path.isDescendantOf(this.conflictedPathes.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isVSChangesConflicted(QPath path) {
        for (int i = 0; i < this.VSSkippedPathes.size(); ++i) {
            if (!path.equals((Object)this.VSSkippedPathes.get(i)) && !path.isDescendantOf(this.VSSkippedPathes.get(i))) continue;
            return true;
        }
        return false;
    }
}

