/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.ext.replication.async.LocalEventListener;
import org.exoplatform.services.jcr.ext.replication.async.RemoteEventListener;
import org.exoplatform.services.jcr.ext.replication.async.SynchronizationLifeCycle;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFileComparator;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFilenameFilter;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesLogStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.IncomeChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.IncomeStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.storage.MemberChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.RandomChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.transport.MemberAddress;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomeStorageImpl
extends SynchronizationLifeCycle
implements IncomeStorage,
LocalEventListener,
RemoteEventListener {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.IncomeStorageImpl");
    protected final String storagePath;
    protected final Map<Integer, MemberChanges> changes = new HashMap<Integer, MemberChanges>();
    protected final ResourcesHolder resHolder = new ResourcesHolder();
    private final FileCleaner fileCleaner;
    private final int maxBufferSize;
    private final ReaderSpoolFileHolder holder;

    public IncomeStorageImpl(String storagePath, FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) {
        this.storagePath = storagePath;
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
    }

    @Override
    public synchronized void addMemberChanges(Member member, ChangesFile changesFile) throws IOException {
        changesFile.validate();
        MemberChanges mch = this.changes.get(member.getPriority());
        if (mch == null) {
            mch = new MemberChanges(member, new ArrayList<ChangesFile>());
            this.changes.put(member.getPriority(), mch);
        }
        mch.changes.add(changesFile);
    }

    @Override
    public synchronized RandomChangesFile createChangesFile(byte[] crc, long id, Member member) throws IOException {
        File dir = new File(this.storagePath, Integer.toString(member.getPriority()));
        dir.mkdirs();
        File cf = new File(dir, Long.toString(id));
        try {
            return new RandomChangesFile(cf, crc, id, this.resHolder);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public List<MemberChangesStorage<ItemState>> getChanges() throws IOException {
        if (this.isStopped()) {
            throw new IOException("Incom storage already stopped.");
        }
        return this.getChangesFromMap();
    }

    private List<MemberChangesStorage<ItemState>> getChangesFromMap() {
        ArrayList<MemberChangesStorage<ItemState>> result = new ArrayList<MemberChangesStorage<ItemState>>();
        for (Map.Entry<Integer, MemberChanges> entry : this.changes.entrySet()) {
            result.add(new IncomeChangesStorage(new ChangesLogStorage(entry.getValue().changes, this.fileCleaner, this.maxBufferSize, this.holder), entry.getValue().member, this.fileCleaner, this.maxBufferSize, this.holder));
        }
        Collections.sort(result, new Comparator<MemberChangesStorage<ItemState>>(){

            @Override
            public int compare(MemberChangesStorage<ItemState> m1, MemberChangesStorage<ItemState> m2) {
                return m1.getMember().getPriority() - m2.getMember().getPriority();
            }
        });
        return result;
    }

    @Deprecated
    private List<ChangesStorage<ItemState>> getChangesFromFS() throws IOException {
        File incomStorage = new File(this.storagePath);
        File[] memberDirs = incomStorage.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File fdir = new File(dir, name);
                return fdir.isDirectory();
            }
        });
        ArrayList<ChangesStorage<ItemState>> changeStorages = new ArrayList<ChangesStorage<ItemState>>();
        for (File memberDir : memberDirs) {
            try {
                int memberPriority = Integer.parseInt(memberDir.getName());
                File[] files = memberDir.listFiles(new ChangesFilenameFilter(false));
                Arrays.sort(files, new ChangesFileComparator());
                ArrayList<ChangesFile> chFiles = new ArrayList<ChangesFile>();
                for (int j = 0; j < files.length; ++j) {
                    File ch = new File(memberDir, files[j].getName());
                    try {
                        chFiles.add(new RandomChangesFile(ch, new byte[0], Long.parseLong(files[j].getName()), this.resHolder));
                        continue;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The ChangesFiles in IncomeStorage = " + chFiles.size()));
                }
                IncomeChangesStorage storage = new IncomeChangesStorage(new ChangesLogStorage(chFiles, this.fileCleaner, this.maxBufferSize, this.holder), null, this.fileCleaner, this.maxBufferSize, this.holder);
                changeStorages.add(storage);
            }
            catch (NumberFormatException e) {
                throw new IOException("Cannot read file name: " + e.getMessage()){

                    public Throwable getCause() {
                        return e;
                    }
                };
            }
        }
        return changeStorages;
    }

    @Override
    public void clean() {
        try {
            this.resHolder.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Error of data streams close " + e), (Throwable)e);
        }
        File dir = new File(this.storagePath);
        if (dir.exists()) {
            this.deleteStorage(dir);
        }
    }

    @Override
    public void onDisconnectMembers(List<Member> members) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("On DisconnectMembers " + members));
        }
        for (Member member : members) {
            this.changes.remove(member.getPriority());
        }
        Iterator<Member> memIt = members.iterator();
        while (memIt.hasNext()) {
            File dir = new File(this.storagePath, Integer.toString(memIt.next().getPriority()));
            this.deleteStorage(dir);
        }
    }

    @Override
    public void onCancel() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"On CANCEL");
        }
        if (this.isStarted()) {
            this.doStop();
        } else {
            LOG.warn((Object)"Not started or already stopped");
        }
    }

    @Override
    public void onStart(List<MemberAddress> members) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"On START");
        }
        this.clean();
        this.doStart();
    }

    @Override
    public void onStop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"On STOP");
        }
        if (this.isStarted()) {
            this.doStop();
        } else {
            LOG.warn((Object)"Not started or already stopped");
        }
    }

    @Override
    public void doStop() {
        super.doStop();
        this.changes.clear();
        this.clean();
    }

    private void deleteStorage(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.deleteStorage(f);
            }
        }
        if (!file.delete()) {
            LOG.warn((Object)("Cannot delete file " + file.getAbsolutePath()));
        }
    }

    @Override
    public void onMerge(MemberAddress member) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MemberChanges {
        final Member member;
        final List<ChangesFile> changes;

        MemberChanges(Member member, List<ChangesFile> changes) {
            this.member = member;
            this.changes = changes;
        }
    }
}

