/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PairChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;
import org.exoplatform.services.jcr.dataflow.serialization.UnknownClassIdException;
import org.exoplatform.services.jcr.ext.replication.async.LocalEventListener;
import org.exoplatform.services.jcr.ext.replication.async.RemoteEventListener;
import org.exoplatform.services.jcr.ext.replication.async.SynchronizationLifeCycle;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFileComparator;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFilenameFilter;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesLogStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChecksumNotFoundException;
import org.exoplatform.services.jcr.ext.replication.async.storage.LocalStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.storage.SimpleChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.SynchronizerChangesLog;
import org.exoplatform.services.jcr.ext.replication.async.storage.VersionLogHolder;
import org.exoplatform.services.jcr.ext.replication.async.transport.MemberAddress;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectWriterImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.dataflow.serialization.TransactionChangesLogWriter;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalStorageImpl
extends SynchronizationLifeCycle
implements LocalStorage,
LocalEventListener,
RemoteEventListener {
    public static final String INTERNAL_CHANGES_FILE_TAG = "i";
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.LocalStorageImpl");
    private static final String EXTERNALIZATION_SYSTEM_ID = "".intern();
    private static final String EXTERNALIZATION_SESSION_ID = "".intern();
    private static final String ERROR_FILENAME = "errors";
    private static final String DIRECTORY_NAME = "changes";
    private static final String DIGESTFILE_EXTENTION = ".md5";
    private static final long ERROR_TIMEOUT = 10000L;
    private static final long MAX_FILE_SIZE = 0x2000000L;
    private final String storagePath;
    private final FileCleaner fileCleaner;
    protected final ConcurrentLinkedQueue<TransactionChangesLog> changesQueue = new ConcurrentLinkedQueue();
    protected ChangesSpooler changesSpooler = null;
    private final ResourcesHolder resHolder = new ResourcesHolder();
    private File currentDir = null;
    private File currentFile = null;
    private MessageDigest digest;
    private ObjectWriter currentOut = null;
    private VersionLogHolder versionLogHolder = null;
    private boolean incorrectPreviouslySavedData = false;
    private final int maxBufferSize;
    private final ReaderSpoolFileHolder holder;
    private Long index = new Long(0L);

    public LocalStorageImpl(String storagePath, FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) throws NoSuchAlgorithmException, ChecksumNotFoundException {
        this.storagePath = storagePath;
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
        this.digest = MessageDigest.getInstance("MD5");
        String[] dirs = this.getSubStorageNames(storagePath);
        if (dirs.length > 1) {
            LOG.warn((Object)"Local storage contains more than one sub-directory!");
        }
        this.currentDir = new File(storagePath, DIRECTORY_NAME);
        if (!this.currentDir.exists()) {
            this.currentDir.mkdirs();
        }
        File[] files = this.currentDir.listFiles(new ChangesFilenameFilter(false));
        Arrays.sort(files, new ChangesFileComparator());
        for (int j = 0; j < files.length; ++j) {
            File curFile = files[j];
            File dFile = new File(this.currentDir, curFile.getName() + DIGESTFILE_EXTENTION);
            if (dFile.exists() && dFile.length() != 0L) continue;
            LOG.warn((Object)(curFile.getName() + " does not have digest file. File may be uncomplete!"));
            this.incorrectPreviouslySavedData = true;
        }
        this.doStop();
    }

    public LocalStorageImpl(String storagePath, FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder, VersionLogHolder versionLogHolder) throws NoSuchAlgorithmException, ChecksumNotFoundException {
        this(storagePath, fileCleaner, maxBufferSize, holder);
        this.versionLogHolder = versionLogHolder;
    }

    @Override
    public ChangesStorage<ItemState> getLocalChanges(boolean skipInternal) throws IOException {
        if (this.isStopped()) {
            throw new IOException("Local storage already stopped.");
        }
        if (this.currentDir != null) {
            ArrayList<ChangesFile> chFiles = new ArrayList<ChangesFile>();
            File[] files = this.currentDir.listFiles(new ChangesFilenameFilter(skipInternal));
            Arrays.sort(files, new ChangesFileComparator());
            for (int j = 0; j < files.length; ++j) {
                try {
                    File curFile = files[j];
                    File dFile = new File(this.currentDir, curFile.getName() + DIGESTFILE_EXTENTION);
                    if (!dFile.exists() || dFile.length() == 0L) {
                        throw new ChecksumNotFoundException(curFile.getName() + " does not have digest file. File may be uncomplete!");
                    }
                    FileInputStream din = new FileInputStream(dFile);
                    byte[] crc = new byte[(int)dFile.length()];
                    din.read(crc);
                    din.close();
                    String curFileName = curFile.getName().endsWith(INTERNAL_CHANGES_FILE_TAG) ? curFile.getName().substring(0, curFile.getName().length() - INTERNAL_CHANGES_FILE_TAG.length()) : curFile.getName();
                    chFiles.add(new SimpleChangesFile(curFile, crc, Long.parseLong(curFileName), this.resHolder));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IOException(e.getMessage());
                }
            }
            return new ChangesLogStorage<ItemState>(chFiles, this.fileCleaner, this.maxBufferSize, this.holder);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSaveItems(ItemStateChangesLog itemStates) {
        LocalStorageImpl localStorageImpl = this;
        synchronized (localStorageImpl) {
            if (!this.incorrectPreviouslySavedData) {
                this.saveItems(itemStates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStartChanges(List<ItemStateChangesLog> listItemStates) {
        LocalStorageImpl localStorageImpl = this;
        synchronized (localStorageImpl) {
            int curSize = listItemStates.size();
            for (int i = 0; i < curSize; ++i) {
                this.saveItems(listItemStates.get(i));
            }
        }
    }

    protected void saveItems(ItemStateChangesLog itemStates) {
        if (!(itemStates instanceof SynchronizerChangesLog)) {
            TransactionChangesLog tLog = (TransactionChangesLog)itemStates;
            ChangesLogIterator cLogs = tLog.getLogIterator();
            if (!cLogs.hasNextLog()) {
                this.changesQueue.add(tLog);
            } else {
                while (cLogs.hasNextLog()) {
                    PlainChangesLog cLog = cLogs.nextLog();
                    if (cLog instanceof PairChangesLog) {
                        this.processedPairChangesLog((PairChangesLog)cLog, tLog.getSystemId());
                        continue;
                    }
                    TransactionChangesLog t = new TransactionChangesLog(cLog);
                    t.setSystemId(tLog.getSystemId());
                    this.changesQueue.add(t);
                }
            }
            if (this.changesSpooler == null) {
                ChangesSpooler csp = this.changesSpooler = new ChangesSpooler();
                csp.start();
            }
        }
    }

    protected void processedPairChangesLog(PairChangesLog pcLog, String systemId) {
        if (this.versionLogHolder != null) {
            TransactionChangesLog t = new TransactionChangesLog((PlainChangesLog)this.versionLogHolder.getPairLog(pcLog.getPairId()));
            t.setSystemId(systemId);
            this.changesQueue.add(t);
        }
        this.changesQueue.add(new TransactionChangesLog((PlainChangesLog)pcLog));
    }

    private String[] getSubStorageNames(String rootPath) {
        File storage = new File(rootPath);
        String[] dirNames = storage.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                return file.isDirectory();
            }
        });
        return dirNames;
    }

    protected void reportException(Throwable e) {
        try {
            BufferedWriter errorOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.storagePath, ERROR_FILENAME), true), "UTF-8"));
            errorOut.write(e.getMessage() + "\n");
            errorOut.flush();
            errorOut.close();
        }
        catch (IOException ex) {
            LOG.warn((Object)"Exception on write to error storage file: ", (Throwable)ex);
        }
    }

    @Override
    public String[] getErrors() throws IOException {
        String s;
        File err = new File(this.storagePath, ERROR_FILENAME);
        if (!err.exists()) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(err), "UTF-8"));
        while ((s = br.readLine()) != null) {
            list.add(s);
        }
        br.close();
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void onStop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"On STOP");
        }
        if (this.isStarted()) {
            File[] subfiles;
            try {
                this.resHolder.close();
            }
            catch (IOException e) {
                LOG.error((Object)("Error of data streams close " + e), (Throwable)e);
            }
            for (File f : subfiles = this.currentDir.listFiles()) {
                if (f.delete()) continue;
                LOG.warn((Object)("Canot delete file " + f.getAbsolutePath()));
                this.reportException(new Exception("Cannot delete file " + f.getAbsolutePath()));
            }
            this.index = new Long(0L);
        } else {
            LOG.warn((Object)"Not started or already stopped");
        }
        this.doStop();
    }

    @Override
    public void onCancel() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"On CANCEL");
        }
        if (this.isStarted()) {
            this.doStop();
        } else {
            LOG.warn((Object)"Not started or already stopped");
        }
    }

    @Override
    public void onStart(List<MemberAddress> members) {
        String[] subfiles;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"On START");
        }
        if ((subfiles = this.currentDir.list(new ChangesFilenameFilter(false))).length == 0) {
            this.onSaveItems((ItemStateChangesLog)new TransactionChangesLog());
        }
        this.flushChanges();
        this.doStart();
    }

    private void flushChanges() {
        ChangesSpooler csp = this.changesSpooler;
        if (csp != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Waitig for the changes spooler done.");
            }
            try {
                csp.join();
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Waitig for the changes spooler fails. Data still can be not spooled to the file. Error " + e), (Throwable)e);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    LOG.error((Object)("Sleep error " + e), (Throwable)e);
                }
            }
        }
        try {
            this.closeCurrentOutput();
        }
        catch (IOException e) {
            LOG.error((Object)("Can't close current output stream " + e), (Throwable)e);
            this.reportException(e);
        }
        this.currentFile = null;
    }

    @Override
    public void onDisconnectMembers(List<Member> member) {
    }

    @Override
    public void onMerge(MemberAddress member) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextFileId() {
        long fileId = 0L;
        Long l = this.index;
        synchronized (l) {
            Long l2 = this.index;
            Long l3 = this.index = Long.valueOf(this.index + 1L);
            fileId = l2;
        }
        return fileId;
    }

    private void closeCurrentOutput() throws IOException {
        if (this.currentOut != null) {
            this.currentOut.close();
            File digestFile = new File(this.currentDir, this.currentFile.getName() + DIGESTFILE_EXTENTION);
            FileOutputStream foutDigest = new FileOutputStream(digestFile);
            byte[] crc = this.digest.digest();
            foutDigest.write(crc);
            foutDigest.close();
            this.digest.reset();
            this.currentOut = null;
        }
    }

    class ChangesSpooler
    extends Thread {
        ChangesSpooler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                TransactionChangesLog chl = LocalStorageImpl.this.changesQueue.poll();
                while (chl != null) {
                    this.writeLog(this.prepareChangesLog(chl));
                    Thread.yield();
                    chl = LocalStorageImpl.this.changesQueue.poll();
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Cannot spool changes queue. I/O error " + e), (Throwable)e);
                LocalStorageImpl.this.reportException(e);
            }
            catch (Throwable e) {
                LOG.error((Object)("Cannot spool changes queue. Error " + e), e);
                LocalStorageImpl.this.reportException(e);
            }
            finally {
                LocalStorageImpl.this.changesSpooler = null;
            }
        }

        private TransactionChangesLog prepareChangesLog(TransactionChangesLog log) throws IOException {
            ChangesLogIterator chIt = log.getLogIterator();
            TransactionChangesLog result = new TransactionChangesLog();
            result.setSystemId(log.getSystemId() == null ? EXTERNALIZATION_SYSTEM_ID : log.getSystemId());
            while (chIt.hasNextLog()) {
                PlainChangesLog plog = chIt.nextLog();
                result.addLog((PlainChangesLog)new PlainChangesLogImpl(plog.getAllStates(), plog.getSessionId() == null ? EXTERNALIZATION_SESSION_ID : plog.getSessionId(), plog.getEventType()));
            }
            return result;
        }

        private void writeLog(TransactionChangesLog itemStates) throws IOException, UnknownClassIdException {
            if (itemStates.getSystemId() == null || !itemStates.getSystemId().equals("JCR_CORE_RESOTRE_WORKSPACE_INITIALIZER_SYSTEM_ID")) {
                long id;
                if (LocalStorageImpl.this.currentFile == null) {
                    id = LocalStorageImpl.this.getNextFileId();
                    LocalStorageImpl.this.currentFile = new File(LocalStorageImpl.this.currentDir, Long.toString(id));
                    LocalStorageImpl.this.currentOut = (ObjectWriter)new ObjectWriterImpl((OutputStream)new DigestOutputStream(new FileOutputStream(LocalStorageImpl.this.currentFile), LocalStorageImpl.this.digest));
                } else if (LocalStorageImpl.this.currentFile.length() > 0x2000000L) {
                    LocalStorageImpl.this.closeCurrentOutput();
                    id = LocalStorageImpl.this.getNextFileId();
                    LocalStorageImpl.this.currentFile = new File(LocalStorageImpl.this.currentDir, Long.toString(id));
                    if (LocalStorageImpl.this.currentFile.exists()) {
                        LOG.warn((Object)("Changes file :" + LocalStorageImpl.this.currentFile.getAbsolutePath() + " already exist and will be rewrited."));
                    }
                    LocalStorageImpl.this.currentOut = (ObjectWriter)new ObjectWriterImpl((OutputStream)new DigestOutputStream(new FileOutputStream(LocalStorageImpl.this.currentFile), LocalStorageImpl.this.digest));
                }
                TransactionChangesLogWriter writer = new TransactionChangesLogWriter();
                writer.write(LocalStorageImpl.this.currentOut, itemStates);
            } else {
                if (LocalStorageImpl.this.currentFile != null) {
                    LocalStorageImpl.this.closeCurrentOutput();
                    LocalStorageImpl.this.currentFile = null;
                }
                long id = LocalStorageImpl.this.getNextFileId();
                LocalStorageImpl.this.currentFile = new File(LocalStorageImpl.this.currentDir, Long.toString(id) + LocalStorageImpl.INTERNAL_CHANGES_FILE_TAG);
                LocalStorageImpl.this.currentOut = (ObjectWriter)new ObjectWriterImpl((OutputStream)new DigestOutputStream(new FileOutputStream(LocalStorageImpl.this.currentFile), LocalStorageImpl.this.digest));
                TransactionChangesLogWriter writer = new TransactionChangesLogWriter();
                writer.write(LocalStorageImpl.this.currentOut, itemStates);
                LocalStorageImpl.this.closeCurrentOutput();
                LocalStorageImpl.this.currentFile = null;
            }
        }
    }
}

