/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PairChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.ext.replication.async.storage.SynchronizerChangesLog;
import org.exoplatform.services.jcr.ext.replication.async.storage.VersionLogHolder;
import org.exoplatform.services.log.ExoLogger;

public class WorkspaceNullListener
implements ItemsPersistenceListener {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.WorkspaceNullListener");
    private VersionLogHolder versionLogHolder;

    public WorkspaceNullListener(VersionLogHolder versionLogHolder) {
        this.versionLogHolder = versionLogHolder;
    }

    public void onSaveItems(ItemStateChangesLog itemStates) {
        if (!(itemStates instanceof SynchronizerChangesLog)) {
            TransactionChangesLog tLog = (TransactionChangesLog)itemStates;
            ChangesLogIterator cLogs = tLog.getLogIterator();
            while (cLogs.hasNextLog()) {
                PlainChangesLog cLog = cLogs.nextLog();
                if (!(cLog instanceof PairChangesLog)) continue;
                if (this.versionLogHolder != null) {
                    this.versionLogHolder.getPairLog(((PairChangesLog)cLog).getPairId());
                    continue;
                }
                LOG.warn((Object)"Got PairChangesLog but there is no any versionHolder.");
            }
        }
    }
}

