/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.transport;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.ext.replication.async.transport.AbstractPacket;

public class ChangesPacket
extends AbstractPacket {
    private long totalPacketsCount;
    private long id;
    private byte[] crc;
    private int fileCount;
    private long offset;
    private byte[] buffer;

    public ChangesPacket(int type, int priority, long totalPacketsCount, byte[] checksum, long id, int fileCount, long offset, byte[] buffer) {
        super(type, priority);
        this.totalPacketsCount = totalPacketsCount;
        this.crc = checksum;
        this.id = id;
        this.fileCount = fileCount;
        this.offset = offset;
        this.buffer = buffer;
    }

    public ChangesPacket() {
    }

    public long getPacketsCount() {
        return this.totalPacketsCount;
    }

    public byte[] getCRC() {
        return this.crc;
    }

    public long getTimeStamp() {
        return this.id;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getOffset() {
        return this.offset;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.totalPacketsCount);
        if (this.crc != null) {
            out.writeInt(1);
            out.writeInt(this.crc.length);
            out.write(this.crc);
        } else {
            out.writeInt(-1);
        }
        out.writeLong(this.id);
        out.writeInt(this.fileCount);
        out.writeLong(this.offset);
        if (this.buffer != null) {
            out.writeInt(1);
            out.writeInt(this.buffer.length);
            out.write(this.buffer);
        } else {
            out.writeInt(-1);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.totalPacketsCount = in.readLong();
        if (in.readInt() == 1) {
            this.crc = new byte[in.readInt()];
            in.readFully(this.crc);
        } else {
            this.crc = null;
        }
        this.id = in.readLong();
        this.fileCount = in.readInt();
        this.offset = in.readLong();
        if (in.readInt() == 1) {
            int bufSize = in.readInt();
            this.buffer = new byte[bufSize];
            in.readFully(this.buffer);
        } else {
            this.buffer = null;
        }
    }

    public String toString() {
        return super.toString() + " [fc:" + this.getFileCount() + ", id:" + this.getTimeStamp() + "]";
    }
}

