/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.transport;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.ext.replication.async.transport.MessagePacket;

public class ErrorPacket
extends MessagePacket {
    private String errorMessage;

    public ErrorPacket(int type, String message, int priority) {
        super(type, priority);
        this.errorMessage = message;
    }

    public ErrorPacket() {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.errorMessage != null) {
            byte[] b = this.errorMessage.getBytes("UTF-8");
            out.writeInt(1);
            out.writeInt(b.length);
            out.write(b);
        } else {
            out.writeInt(-1);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (in.readInt() == 1) {
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            this.errorMessage = new String(buf, "UTF-8");
        } else {
            this.errorMessage = null;
        }
    }
}

