/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.util.List;

import org.exoplatform.services.jcr.ext.replication.async.transport.MemberAddress;

/**
 * Created by The eXo Platform SAS.
 * 
 * <br/>Date: 14.01.2009
 * 
 * @author <a href="mailto:peter.nedonosko@exoplatform.com.ua">Peter Nedonosko</a>
 * @version $Id: SynchronizationEventListener.java 27475 2009-01-26 17:26:00Z pnedonosko $
 */
public interface SynchronizationEventListener {

  /**
   * On sycnhronization Start event action. <br/> operations.
   * <ul>
   * <li>Publisher will start send changes.</li>
   * <li>Subscriber will prepare the storage for memebers changes.</li>
   * </ul>
   * 
   */
  void onStart(List<MemberAddress> members);

  /**
   * On sycnhronization Cancel event action. <br/> operations.
   * <ul>
   * <li>Publisher will not send more changes.</li>
   * <li>Subscriber will stops changes receive process or stops the merge of received changes. Then
   * all income changes will be deleted.</li>
   * </ul>
   */
  void onCancel();

}
