/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;
import org.exoplatform.services.jcr.ext.replication.recovery.AbstractFSAccess;
import org.exoplatform.services.jcr.ext.replication.recovery.FileNameFactory;
import org.exoplatform.services.jcr.ext.replication.recovery.FileRemover;
import org.exoplatform.services.jcr.ext.replication.recovery.PendingConfirmationChengesLog;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectWriterImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.TransactionChangesLogWriter;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveryWriter
extends AbstractFSAccess {
    private static Log log = ExoLogger.getLogger((String)"ext.RecoveryWriter");
    private static final long REMOVER_TIMEOUT = 300000L;
    private final FileCleaner fileCleaner;
    private FileNameFactory fileNameFactory;
    private File recoveryDir;
    private File recoveryDirDate;
    private FileRemover fileRemover;

    public RecoveryWriter(File recoveryDir, FileNameFactory fileNameFactory, FileCleaner fileCleaner, String ownName) throws IOException {
        this.fileCleaner = fileCleaner;
        this.recoveryDir = recoveryDir;
        this.fileNameFactory = fileNameFactory;
        this.recoveryDirDate = new File(this.recoveryDir.getCanonicalPath() + File.separator + "data");
        if (!this.recoveryDirDate.exists()) {
            this.recoveryDirDate.mkdirs();
        }
        this.fileRemover = new FileRemover(300000L, recoveryDir, fileCleaner, ownName);
        this.fileRemover.start();
    }

    public String saveDataInfo(PendingConfirmationChengesLog confirmationChengesLog) throws IOException {
        if (confirmationChengesLog.getNotConfirmationList().size() > 0) {
            File f = new File(confirmationChengesLog.getDataFilePath());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Write info : " + f.getAbsolutePath()));
            }
            this.writeNotConfirmationInfo(f, confirmationChengesLog.getNotConfirmationList());
            return f.getName();
        }
        return null;
    }

    public String saveDataFile(Calendar timeStamp, String identifier, TransactionChangesLog tcLog) throws IOException {
        String fileName = this.fileNameFactory.getTimeStampName(timeStamp) + "_" + identifier;
        File dir = new File(this.recoveryDirDate.getCanonicalPath() + File.separator + this.fileNameFactory.getRandomSubPath());
        dir.mkdirs();
        File f = new File(dir.getCanonicalPath() + File.separator + File.separator + fileName);
        this.save(f, tcLog);
        return f.getCanonicalPath();
    }

    public String save(File f, TransactionChangesLog changesLog) throws IOException {
        ObjectWriterImpl out = new ObjectWriterImpl((OutputStream)new FileOutputStream(f));
        TransactionChangesLogWriter wr = new TransactionChangesLogWriter();
        wr.write((ObjectWriter)out, changesLog);
        out.flush();
        out.close();
        return f.getName();
    }

    private synchronized void writeNotConfirmationInfo(File dataFile, List<String> participantsClusterList) throws IOException {
        for (String name : participantsClusterList) {
            File metaDataFile = new File(this.recoveryDir.getCanonicalPath() + File.separator + name);
            if (!metaDataFile.exists()) {
                metaDataFile.createNewFile();
            }
            RandomAccessFile raf = new RandomAccessFile(metaDataFile, "rw");
            raf.seek(metaDataFile.length());
            raf.write((dataFile.getCanonicalPath() + "\n").getBytes());
            raf.close();
        }
    }

    public synchronized void removeChangesLog(String identifier, String ownerName) throws IOException {
        String fileName;
        File metaDataFile = new File(this.recoveryDir.getAbsolutePath() + File.separator + ownerName);
        RandomAccessFile raf = new RandomAccessFile(metaDataFile, "rw");
        while ((fileName = raf.readLine()) != null) {
            if (fileName.indexOf(identifier) == -1) continue;
            raf.seek(raf.getFilePointer() - (long)(fileName.length() + 1));
            String s = new String(fileName);
            s = s.replaceAll(".", "-");
            raf.writeBytes(s);
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove metadata : " + fileName));
                log.debug((Object)("remove changes log form fs : " + identifier));
            }
            this.saveRemoveChangesLog(new File(fileName).getCanonicalPath());
            break;
        }
        raf.close();
    }

    public long removeChangesLog(List<String> fileNameList, String ownerName) throws IOException {
        String fName;
        long removeCounter = 0L;
        File metaDataFile = new File(this.recoveryDir.getAbsolutePath() + File.separator + ownerName);
        RandomAccessFile raf = new RandomAccessFile(metaDataFile, "rw");
        HashMap<String, String> fileNameMap = new HashMap<String, String>();
        for (String fileName : fileNameList) {
            fileNameMap.put(fileName, fileName);
        }
        while ((fName = raf.readLine()) != null) {
            File f;
            if (fName.startsWith("---") || !fileNameMap.containsKey((f = new File(fName)).getName())) continue;
            raf.seek(raf.getFilePointer() - (long)(fName.length() + 1));
            String s = new String(fName);
            s = s.replaceAll(".", "-");
            raf.writeBytes(s);
            ++removeCounter;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("remove metadata : " + fName));
            log.debug((Object)("remove changeslogs form fs : " + fileNameList.size()));
        }
        raf.close();
        this.saveRemoveChangesLog(fileNameList, ownerName);
        return removeCounter;
    }

    public void saveRemoveChangesLog(String filePath) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Seve removable changeslogs form fs : " + filePath));
        }
        File removeDataFile = new File(this.recoveryDir.getAbsolutePath() + File.separator + "data" + File.separator + IdGenerator.generate() + ".remove");
        removeDataFile.createNewFile();
        BufferedWriter bw = new BufferedWriter(new FileWriter(removeDataFile));
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove  : " + filePath));
        }
        bw.write(filePath + "\n");
        bw.flush();
        bw.close();
    }

    private void saveRemoveChangesLog(List<String> fileNameList, String ownerName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Seve removable changeslogs form fs : " + fileNameList.size()));
        }
        File removeDataFile = new File(this.recoveryDir.getAbsolutePath() + File.separator + "data" + File.separator + IdGenerator.generate() + ".remove");
        removeDataFile.createNewFile();
        BufferedWriter bw = new BufferedWriter(new FileWriter(removeDataFile));
        for (String fileName : fileNameList) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove  : " + fileName));
            }
            bw.write(fileName + "\n");
        }
        bw.flush();
        bw.close();
    }

    public void removeDataFile(File f) {
        if (!f.delete()) {
            this.fileCleaner.addFile(f);
        }
    }
}

