/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestLoader;
import org.exoplatform.services.jcr.ext.script.groovy.NodeScriptKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GroovyScript2RestUpdateListener
implements EventListener {
    private static final Log LOG = ExoLogger.getLogger((String)GroovyScript2RestUpdateListener.class.getName());
    private final String repository;
    private final String workspace;
    private final GroovyScript2RestLoader groovyScript2RestLoader;
    private final Session session;

    public GroovyScript2RestUpdateListener(String repository, String workspace, GroovyScript2RestLoader groovyScript2RestLoader, Session session) {
        this.repository = repository;
        this.workspace = workspace;
        this.groovyScript2RestLoader = groovyScript2RestLoader;
        this.session = session;
    }

    public void onEvent(EventIterator eventIterator) {
        try {
            while (eventIterator.hasNext()) {
                Node node;
                Event event = eventIterator.nextEvent();
                String path = event.getPath();
                if (!path.endsWith("/jcr:data")) continue;
                if (event.getType() == 8) {
                    this.unloadScript(path.substring(0, path.lastIndexOf(47)));
                    continue;
                }
                if (event.getType() != 4 && event.getType() != 16 || !(node = this.session.getItem(path).getParent()).getProperty("exo:autoload").getBoolean()) continue;
                this.loadScript(node);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Process event failed. ", (Throwable)e);
        }
    }

    private void loadScript(Node node) throws Exception {
        NodeScriptKey key = new NodeScriptKey(this.repository, this.workspace, node);
        if (this.groovyScript2RestLoader.isLoaded(key)) {
            this.groovyScript2RestLoader.unloadScript(key);
        }
        this.groovyScript2RestLoader.loadScript(key, node.getPath(), node.getProperty("jcr:data").getStream());
    }

    private void unloadScript(String path) throws Exception {
        NodeScriptKey key = new NodeScriptKey(this.repository, this.workspace, path);
        if (this.groovyScript2RestLoader.isLoaded(key)) {
            this.groovyScript2RestLoader.unloadScript(key);
        }
    }
}

