/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.repository.creation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.database.creator.DBConnectionInfo;
import org.exoplatform.services.database.creator.DBCreator;
import org.exoplatform.services.database.creator.DBCreatorException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.backup.BackupConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChainLog;
import org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationException;
import org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationService;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.BeanBuilder;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCreationServiceImpl
implements RepositoryCreationService,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryCreationService");
    private final RepositoryService repositoryService;
    private final RPCService rpcService;
    private final BackupManager backupManager;
    private final DBCreator dbCreator;
    private final InitialContextInitializer initialContextInitializer;
    private final Map<String, String> pendingRepositories = new ConcurrentHashMap<String, String>();
    private RemoteCommand reserveRepositoryName;
    private RemoteCommand createRepository;
    private RemoteCommand startRepository;

    public RepositoryCreationServiceImpl(RepositoryService repositoryService, BackupManager backupManager, DBCreator dbCreator, InitialContextInitializer initialContextInitializer) {
        this.repositoryService = repositoryService;
        this.backupManager = backupManager;
        this.rpcService = null;
        this.dbCreator = dbCreator;
        this.initialContextInitializer = initialContextInitializer;
        LOG.warn((Object)"RepositoryCreationService initialized without RPCService, so other cluser nodes will not be notified about new repositories.");
    }

    public RepositoryCreationServiceImpl(RepositoryService repositoryService, BackupManager backupManager, DBCreator dbCreator, InitialContextInitializer initialContextInitializer, final RPCService rpcService) {
        this.repositoryService = repositoryService;
        this.backupManager = backupManager;
        this.rpcService = rpcService;
        this.dbCreator = dbCreator;
        this.initialContextInitializer = initialContextInitializer;
        this.reserveRepositoryName = rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationServiceImpl-reserveRepositoryName";
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                String repositoryName = (String)((Object)args[0]);
                return RepositoryCreationServiceImpl.this.reserveRepositoryNameLocally(repositoryName);
            }
        });
        this.createRepository = rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationServiceImpl-createRepository";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Serializable execute(Serializable[] args) throws Throwable {
                String backupId = (String)((Object)args[0]);
                String stringRepositoryEntry = (String)((Object)args[1]);
                String rToken = (String)((Object)args[2]);
                try {
                    RepositoryEntry rEntry = (RepositoryEntry)RepositoryCreationServiceImpl.this.getObject(RepositoryEntry.class, stringRepositoryEntry.getBytes("UTF-8"));
                    RepositoryCreationServiceImpl.this.createRepositoryLocally(backupId, rEntry, rToken);
                    Serializable serializable = null;
                    return serializable;
                }
                finally {
                    RepositoryCreationServiceImpl.this.pendingRepositories.remove(rToken);
                }
            }
        });
        this.startRepository = rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationServiceImpl-startRepository";
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                if (!rpcService.isCoordinator()) {
                    String stringRepositoryEntry = (String)((Object)args[0]);
                    RepositoryEntry rEntry = (RepositoryEntry)RepositoryCreationServiceImpl.this.getObject(RepositoryEntry.class, stringRepositoryEntry.getBytes("UTF-8"));
                    RepositoryCreationServiceImpl.this.startRepository(rEntry);
                }
                return null;
            }
        });
    }

    @Override
    public void createRepository(String backupId, RepositoryEntry rEntry) throws RepositoryConfigurationException, RepositoryCreationException {
        String rToken = this.reserveRepositoryName(rEntry.getName());
        this.createRepository(backupId, rEntry, rToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRepository(String backupId, RepositoryEntry rEntry, String rToken) throws RepositoryConfigurationException, RepositoryCreationException {
        if (this.rpcService != null) {
            String stringRepositoryEntry = null;
            try {
                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                JsonValue json = generatorImpl.createJsonObject((Object)rEntry);
                stringRepositoryEntry = json.toString();
            }
            catch (JsonException e) {
                throw new RepositoryCreationException("Can not serialize repository entry: " + e.getMessage(), e);
            }
            try {
                Object result = this.rpcService.executeCommandOnCoordinator(this.createRepository, true, new Serializable[]{backupId, stringRepositoryEntry, rToken});
                if (result != null) {
                    throw new RepositoryCreationException("CreateRepository command must not return any results.");
                }
            }
            catch (RPCException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RepositoryCreationException) {
                    throw (RepositoryCreationException)cause;
                }
                if (cause instanceof RepositoryConfigurationException) {
                    throw (RepositoryConfigurationException)cause;
                }
                throw new RepositoryCreationException(e.getMessage(), e);
            }
            try {
                List results = this.rpcService.executeCommandOnAllNodes(this.startRepository, true, new Serializable[]{stringRepositoryEntry});
                for (Object result : results) {
                    Throwable cause;
                    if (result instanceof RPCException && (cause = ((RPCException)((Object)result)).getCause()) instanceof RepositoryCreationException) {
                        throw new RepositoryCreationException("Repository " + rEntry.getName() + " created on coordinator, but can not be started at other cluster nodes: " + cause.getMessage(), cause);
                    }
                    if (!(result instanceof Throwable)) continue;
                    throw new RepositoryCreationException("Repository " + rEntry.getName() + " created on coordinator, but can not be started at other cluster nodes: " + ((Throwable)result).getMessage(), (Throwable)result);
                }
            }
            catch (RPCException e) {
                throw new RepositoryCreationException("Repository " + rEntry.getName() + " created on coordinator, can not be started at other cluster node: " + e.getMessage(), e);
            }
        }
        try {
            this.createRepositoryLocally(backupId, rEntry, rToken);
        }
        finally {
            this.pendingRepositories.remove(rToken);
        }
    }

    @Override
    public String reserveRepositoryName(String repositoryName) throws RepositoryCreationException {
        if (this.rpcService != null) {
            try {
                if (this.repositoryService.getRepository(repositoryName) != null) {
                    throw new RepositoryCreationException("Repository " + repositoryName + " already exists.");
                }
            }
            catch (RepositoryConfigurationException e) {
                throw new RepositoryCreationException("Can not check does repository " + repositoryName + " exists: " + e.getMessage(), e);
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            try {
                Object result = this.rpcService.executeCommandOnCoordinator(this.reserveRepositoryName, true, new Serializable[]{repositoryName});
                if (result instanceof String) {
                    return (String)result;
                }
                throw new RepositoryCreationException("ReserveRepositoryName command returns unknown type result.");
            }
            catch (RPCException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RepositoryCreationException) {
                    throw (RepositoryCreationException)cause;
                }
                throw new RepositoryCreationException("Can not reserve repository name " + repositoryName + " since: " + e.getMessage(), e);
            }
        }
        return this.reserveRepositoryNameLocally(repositoryName);
    }

    protected String reserveRepositoryNameLocally(String repositoryName) throws RepositoryCreationException {
        try {
            if (this.repositoryService.getRepository(repositoryName) != null) {
                throw new RepositoryCreationException("Repository " + repositoryName + " already exists.");
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryCreationException("Can not check does repository " + repositoryName + " exists: " + e.getMessage(), e);
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        if (!this.pendingRepositories.containsValue(repositoryName)) {
            String rToken = repositoryName + IdGenerator.generate();
            this.pendingRepositories.put(rToken, repositoryName);
            return rToken;
        }
        throw new RepositoryCreationException("Repository name " + repositoryName + " already reserved.");
    }

    protected void createRepositoryLocally(String backupId, RepositoryEntry rEntry, String rToken) throws RepositoryConfigurationException, RepositoryCreationException {
        if (!this.pendingRepositories.containsKey(rToken)) {
            throw new RepositoryCreationException("Token " + rToken + " does not registered.");
        }
        Set<String> dataSourceNames = this.extractDataSourceNames(rEntry, true);
        for (String dataSource : dataSourceNames) {
            Map refAddr = null;
            try {
                DBConnectionInfo dbConnectionInfo = this.dbCreator.createDatabase(rEntry.getName() + (dataSourceNames.size() == 1 ? "" : "_" + dataSource));
                refAddr = dbConnectionInfo.getProperties();
            }
            catch (DBCreatorException e) {
                throw new RepositoryCreationException("Can not create new database for " + rEntry.getName() + " repository.", e);
            }
            try {
                this.initialContextInitializer.bind(dataSource, "javax.sql.DataSource", "org.apache.commons.dbcp.BasicDataSourceFactory", null, refAddr);
            }
            catch (NamingException e) {
                throw new RepositoryCreationException(e.getMessage(), e);
            }
            catch (FileNotFoundException e) {
                throw new RepositoryCreationException(e.getMessage(), e);
            }
            catch (XMLStreamException e) {
                throw new RepositoryCreationException(e.getMessage(), e);
            }
        }
        RepositoryBackupChainLog backupChain = null;
        for (RepositoryBackupChainLog chainLog : this.backupManager.getRepositoryBackupsLogs()) {
            if (!chainLog.getBackupId().equals(backupId)) continue;
            backupChain = chainLog;
            break;
        }
        if (backupChain == null) {
            throw new RepositoryCreationException("BackupChain by id " + backupId + " does not exists.");
        }
        File backLog = new File(backupChain.getLogFilePath());
        if (backLog != null && PrivilegedFileHelper.exists((File)backLog)) {
            try {
                this.backupManager.restore(backupChain, rEntry, false);
            }
            catch (BackupOperationException e) {
                throw new RepositoryCreationException(e.getLocalizedMessage(), e);
            }
            catch (BackupConfigurationException e) {
                throw new RepositoryCreationException(e.getLocalizedMessage(), e);
            }
            catch (RepositoryException e) {
                throw new RepositoryCreationException(e.getLocalizedMessage(), e);
            }
        } else {
            throw new RepositoryCreationException("Backup log file by id " + backupId + (backLog != null ? " and file path=" + PrivilegedFileHelper.getAbsolutePath((File)backLog) : "") + " do not exists.");
        }
    }

    protected void startRepository(RepositoryEntry repositoryEntry) throws RepositoryCreationException {
        try {
            Set<String> dataSourceNames = this.extractDataSourceNames(repositoryEntry, false);
            for (String dataSource : dataSourceNames) {
                Map refAddr = null;
                try {
                    DBConnectionInfo dbConnectionInfo = this.dbCreator.getDBConnectionInfo(repositoryEntry.getName() + "_" + dataSource);
                    refAddr = dbConnectionInfo.getProperties();
                }
                catch (DBCreatorException e) {
                    throw new RepositoryCreationException("Can not fetch database information associated with " + repositoryEntry.getName() + " repository and " + dataSource + " datasource.", e);
                }
                try {
                    this.initialContextInitializer.bind(dataSource, "javax.sql.DataSource", "org.apache.commons.dbcp.BasicDataSourceFactory", null, refAddr);
                }
                catch (NamingException e) {
                    throw new RepositoryCreationException(e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    throw new RepositoryCreationException(e.getMessage(), e);
                }
                catch (XMLStreamException e) {
                    throw new RepositoryCreationException(e.getMessage(), e);
                }
            }
            this.repositoryService.createRepository(repositoryEntry);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryCreationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new RepositoryCreationException(e.getMessage(), e);
        }
    }

    private Set<String> extractDataSourceNames(RepositoryEntry repositoryEntry, boolean checkDataSourceExistance) throws RepositoryConfigurationException, RepositoryCreationException {
        HashSet<String> dataSourceNames = new HashSet<String>();
        for (WorkspaceEntry wsEntry : repositoryEntry.getWorkspaceEntries()) {
            boolean isMultiDB = Boolean.parseBoolean(wsEntry.getContainer().getParameterValue("multi-db"));
            String dbSourceName = wsEntry.getContainer().getParameterValue("source-name");
            if (isMultiDB && dataSourceNames.contains(dbSourceName)) {
                throw new RepositoryCreationException("RepositoryEntry for new " + repositoryEntry.getName() + " repository contains workspaces that marked as multiDB but have same datasource " + dbSourceName + ".");
            }
            if (checkDataSourceExistance) {
                try {
                    DataSource ds = (DataSource)this.initialContextInitializer.getInitialContext().lookup(dbSourceName);
                    if (ds != null) {
                        throw new RepositoryConfigurationException("RepositoryEntry for new " + repositoryEntry.getName() + " repository contains already binded datasource " + dbSourceName + ".");
                    }
                }
                catch (NameNotFoundException e) {
                }
                catch (NamingException e) {
                    throw new RepositoryConfigurationException(e.getMessage(), (Throwable)e);
                }
            }
            dataSourceNames.add(dbSourceName);
        }
        return dataSourceNames;
    }

    private Object getObject(Class cl, byte[] data) throws Exception {
        JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
        JsonParserImpl jsonParser = new JsonParserImpl();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        jsonParser.parse((InputStream)inputStream, (JsonHandler)jsonHandler);
        JsonValue jsonValue = jsonHandler.getJsonObject();
        return new BeanBuilder().createObject(cl, jsonValue);
    }

    public void start() {
    }

    public void stop() {
        if (this.rpcService != null) {
            this.rpcService.unregisterCommand(this.reserveRepositoryName);
            this.rpcService.unregisterCommand(this.createRepository);
            this.rpcService.unregisterCommand(this.startRepository);
        }
    }
}

