/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.ext.replication.AbstractWorkspaceDataReceiver;
import org.exoplatform.services.jcr.ext.replication.PersistentWorkspaceDataReceiver;
import org.exoplatform.services.jcr.ext.replication.ProxyWorkspaceDataReceiver;
import org.exoplatform.services.jcr.ext.replication.ReplicationChannelManager;
import org.exoplatform.services.jcr.ext.replication.WorkspaceDataManagerProxy;
import org.exoplatform.services.jcr.ext.replication.WorkspaceDataTransmitter;
import org.exoplatform.services.jcr.ext.replication.recovery.ConnectionFailDetector;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryManager;
import org.exoplatform.services.jcr.ext.replication.recovery.backup.BackupCreator;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.stack.Protocol;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@ManagedDescription(value="JCR replication service")
@NameTemplate(value={@Property(key="service", value="replication")})
public class ReplicationService
implements Startable,
ManagementAware {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.ReplicationService");
    private static final String SERVICE_NAME = "Replication";
    private static final String IP_ADRESS_TEMPLATE = "[$]bind-ip-address";
    private static final String PERSISTENT_MODE = "persistent";
    private static final String PROXY_MODE = "proxy";
    public static final String PRIORITY_STATIC_TYPE = "static";
    public static final String PRIORITY_DYNAMIC_TYPE = "dynamic";
    public static final String PRIORITY_GENERIC_TYPE = "generic";
    public static final int FILE_CLEANRE_TIMEOUT = 30030;
    private RepositoryService repoService;
    private RegistryService registryService;
    private InitParams initParams;
    private String testMode;
    private String enabled;
    private String mode;
    private String bindIPAddress;
    private String channelConfig;
    private String channelName;
    private List<String> repoNamesList;
    private File recoveryDir;
    private String recDir;
    private String ownName;
    private List<String> participantsClusterList;
    private String participantsCluster;
    private long waitConfirmation;
    private String sWaitConfirmation;
    private boolean backupEnabled;
    private String sBackupEnabled;
    private File backupDir;
    private String sBackupDir;
    private long backupDelayTime = 0L;
    private String sDelayTime;
    private List<BackupCreator> backupCreatorList;
    private boolean started = false;
    private String priprityType;
    private int ownPriority;
    private String ownValue;
    private ManagementContext managementContext;

    public ReplicationService(RepositoryService repoService, InitParams params) throws RepositoryConfigurationException {
        this(repoService, params, null);
    }

    public ReplicationService(RepositoryService repoService, InitParams params, RegistryService registryService) throws RepositoryConfigurationException {
        this.repoService = repoService;
        this.registryService = registryService;
        this.initParams = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.registryService != null && !this.registryService.getForceXMLConfigurationValue(this.initParams)) {
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            try {
                this.readParamsFromRegistryService(sessionProvider);
            }
            catch (Exception e) {
                this.readParamsFromFile();
                try {
                    this.writeParamsToRegistryService(sessionProvider);
                }
                catch (Exception exc) {
                    log.error((Object)"Cannot write init configuration to RegistryService.", (Throwable)exc);
                }
            }
            finally {
                sessionProvider.close();
            }
        } else {
            this.readParamsFromFile();
        }
        try {
            for (int rIndex = 0; rIndex < this.repoNamesList.size(); ++rIndex) {
                int wIndex;
                RepositoryImpl jcrRepository = (RepositoryImpl)this.repoService.getRepository(this.repoNamesList.get(rIndex));
                String[] workspaces = jcrRepository.getWorkspaceNames();
                if (this.enabled.equals("true")) {
                    if (this.testMode != null && "true".equals(this.testMode)) {
                        this.ownName = rIndex == 0 ? "cluster_node_1" : "cluster_node_2";
                        this.participantsClusterList = new ArrayList<String>();
                        if (rIndex == 0) {
                            this.ownPriority = 100;
                            this.participantsClusterList.add("cluster_node_2");
                        } else {
                            this.ownPriority = 50;
                            this.participantsClusterList.add("cluster_node_1");
                        }
                    }
                    for (wIndex = 0; wIndex < workspaces.length; ++wIndex) {
                        try {
                            File dir = new File(PrivilegedFileHelper.getAbsolutePath((File)this.recoveryDir) + File.separator + this.repoNamesList.get(rIndex) + "_" + workspaces[wIndex]);
                            PrivilegedFileHelper.mkdirs((File)dir);
                            String systemId = IdGenerator.generate();
                            String props = this.channelConfig.replaceAll(IP_ADRESS_TEMPLATE, this.bindIPAddress);
                            WorkspaceContainer wContainer = (WorkspaceContainer)jcrRepository.getSystemSession(workspaces[wIndex]).getContainer();
                            String uniqueNoame = jcrRepository.getName() + "_" + workspaces[wIndex];
                            if (this.testMode != null && "true".equals(this.testMode)) {
                                uniqueNoame = "Test_Channel234";
                            }
                            ReplicationChannelManager channelManager = new ReplicationChannelManager(props, this.channelName + (this.channelName.equals("") ? "" : "_") + uniqueNoame);
                            WorkspaceContainerFacade wsFacade = jcrRepository.getWorkspaceContainer(workspaces[wIndex]);
                            WorkspaceEntry wconf = (WorkspaceEntry)wsFacade.getComponent(WorkspaceEntry.class);
                            int maxBufferSize = wconf.getContainer().getParameterInteger("max-buffer-size", Integer.valueOf(204800));
                            FileCleanerHolder wfcleaner = (FileCleanerHolder)wsFacade.getComponent(FileCleanerHolder.class);
                            FileCleaner fileCleaner = wfcleaner.getFileCleaner();
                            RecoveryManager recoveryManager = new RecoveryManager(dir, this.ownName, systemId, this.participantsClusterList, this.waitConfirmation, jcrRepository.getName(), workspaces[wIndex], channelManager, fileCleaner, maxBufferSize, new ReaderSpoolFileHolder());
                            PersistentDataManager dataManager = (PersistentDataManager)wsFacade.getComponent(PersistentDataManager.class);
                            ConnectionFailDetector failDetector = new ConnectionFailDetector(channelManager, dataManager, recoveryManager, this.ownPriority, this.participantsClusterList, this.ownName, this.priprityType, workspaces[wIndex]);
                            channelManager.addStateListener(failDetector);
                            wContainer.registerComponentImplementation(WorkspaceDataTransmitter.class);
                            WorkspaceDataTransmitter dataTransmitter = (WorkspaceDataTransmitter)wContainer.getComponentInstanceOfType(WorkspaceDataTransmitter.class);
                            dataTransmitter.init(channelManager, systemId, this.ownName, recoveryManager);
                            AbstractWorkspaceDataReceiver dataReceiver = null;
                            if (this.mode.equals(PROXY_MODE)) {
                                wContainer.registerComponentImplementation(WorkspaceDataManagerProxy.class);
                                wContainer.registerComponentImplementation(ProxyWorkspaceDataReceiver.class);
                                dataReceiver = (ProxyWorkspaceDataReceiver)wContainer.getComponentInstanceOfType(ProxyWorkspaceDataReceiver.class);
                            } else if (this.mode.equals(PERSISTENT_MODE)) {
                                wContainer.registerComponentImplementation(PersistentWorkspaceDataReceiver.class);
                                dataReceiver = (PersistentWorkspaceDataReceiver)wContainer.getComponentInstanceOfType(PersistentWorkspaceDataReceiver.class);
                            }
                            recoveryManager.setDataKeeper(dataReceiver.getDataKeeper());
                            dataReceiver.init(channelManager, systemId, this.ownName, recoveryManager);
                            channelManager.connect();
                            if (this.managementContext != null) {
                                this.managementContext.register((Object)recoveryManager);
                            }
                            dataReceiver.start();
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)("Can not start replication on " + this.repoNamesList.get(rIndex) + "_" + workspaces[wIndex] + " \n" + e), (Throwable)e);
                        }
                    }
                }
                if (!this.backupEnabled) continue;
                for (wIndex = 0; wIndex < workspaces.length; ++wIndex) {
                    this.backupCreatorList.add(this.initWorkspaceBackup(this.repoNamesList.get(rIndex), workspaces[wIndex]));
                }
            }
        }
        catch (RepositoryException re) {
            log.error((Object)("Can not start ReplicationService \n" + (Object)((Object)re)), (Throwable)re);
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)("Can not start ReplicationService \n" + (Object)((Object)e)), (Throwable)e);
        }
        this.started = true;
    }

    private BackupCreator initWorkspaceBackup(String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository manageableRepository = this.repoService.getRepository(repositoryName);
        BackupCreator backupCreator = new BackupCreator(this.backupDelayTime, workspaceName, this.backupDir, manageableRepository);
        return backupCreator;
    }

    public void stop() {
    }

    public boolean isStarted() {
        return this.started;
    }

    private void writeParamsToRegistryService(SessionProvider sessionProvider) throws ParserConfigurationException, RepositoryException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement(SERVICE_NAME);
        doc.appendChild(root);
        StringBuilder reps = new StringBuilder();
        for (String rep : this.repoNamesList) {
            reps.append(rep).append(";");
        }
        Element element = doc.createElement("repositories");
        this.setAttributeSmart(element, "repositories", reps.toString());
        root.appendChild(element);
        element = doc.createElement("replication-properties");
        this.setAttributeSmart(element, "test-mode", this.testMode);
        this.setAttributeSmart(element, "enabled", this.enabled);
        this.setAttributeSmart(element, "mode", this.mode);
        this.setAttributeSmart(element, "bind-ip-address", this.bindIPAddress);
        this.setAttributeSmart(element, "channel-config", this.channelConfig);
        this.setAttributeSmart(element, "channel-name", this.channelName);
        this.setAttributeSmart(element, "recovery-dir", this.recDir);
        this.setAttributeSmart(element, "node-name", this.ownName);
        this.setAttributeSmart(element, "other-participants", this.participantsCluster);
        this.setAttributeSmart(element, "wait-confirmation", this.sWaitConfirmation);
        root.appendChild(element);
        element = doc.createElement("replication-snapshot-properties");
        this.setAttributeSmart(element, "snapshot-enabled", this.sBackupEnabled);
        this.setAttributeSmart(element, "snapshot-enabled", this.sBackupDir);
        this.setAttributeSmart(element, "snapshot-enabled", this.sDelayTime);
        root.appendChild(element);
        element = doc.createElement("replication-priority-properties");
        this.setAttributeSmart(element, "priority-type", this.priprityType);
        this.setAttributeSmart(element, "node-priority", this.ownValue);
        root.appendChild(element);
        RegistryEntry serviceEntry = new RegistryEntry(doc);
        this.registryService.createEntry(sessionProvider, "exo:services", serviceEntry);
    }

    private void readParamsFromRegistryService(SessionProvider sessionProvider) throws RepositoryException {
        String[] reps;
        String entryPath = "exo:services/Replication/repositories";
        RegistryEntry entry = this.registryService.getEntry(sessionProvider, entryPath);
        Document doc = entry.getDocument();
        Element element = doc.getDocumentElement();
        String repositories = this.getAttributeSmart(element, "repositories");
        this.repoNamesList = new ArrayList<String>();
        for (String rep : reps = repositories.split(";")) {
            if (rep.equals("")) continue;
            this.repoNamesList.add(rep);
        }
        entryPath = "exo:services/Replication/replication-properties";
        entry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = entry.getDocument();
        element = doc.getDocumentElement();
        this.testMode = this.getAttributeSmart(element, "test-mode");
        this.enabled = this.getAttributeSmart(element, "enabled");
        this.mode = this.getAttributeSmart(element, "mode");
        this.bindIPAddress = this.getAttributeSmart(element, "bind-ip-address");
        this.channelConfig = this.getAttributeSmart(element, "channel-config");
        this.channelName = this.getAttributeSmart(element, "channel-name");
        this.recDir = this.getAttributeSmart(element, "recovery-dir");
        this.ownName = this.getAttributeSmart(element, "node-name");
        this.participantsCluster = this.getAttributeSmart(element, "other-participants");
        this.sWaitConfirmation = this.getAttributeSmart(element, "wait-confirmation");
        entryPath = "exo:services/Replication/replication-snapshot-properties";
        entry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = entry.getDocument();
        element = doc.getDocumentElement();
        this.sBackupEnabled = this.getAttributeSmart(element, "snapshot-enabled");
        this.sBackupDir = this.getAttributeSmart(element, "snapshot-dir");
        this.sDelayTime = this.getAttributeSmart(element, "delay-time");
        entryPath = "exo:services/Replication/replication-priority-properties";
        entry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = entry.getDocument();
        element = doc.getDocumentElement();
        this.priprityType = this.getAttributeSmart(element, "priority-type");
        this.ownValue = this.getAttributeSmart(element, "node-priority");
        log.info((Object)"Params is read from RegistryService");
        this.checkParams();
    }

    private String getAttributeSmart(Element element, String attr) {
        return element.hasAttribute(attr) ? element.getAttribute(attr) : null;
    }

    private void setAttributeSmart(Element element, String attr, String value) {
        if (value == null) {
            element.removeAttribute(attr);
        } else {
            element.setAttribute(attr, value);
        }
    }

    private void readParamsFromFile() {
        PropertiesParam pps = this.initParams.getPropertiesParam("replication-properties");
        this.testMode = pps.getProperty("test-mode");
        this.enabled = pps.getProperty("enabled");
        this.mode = pps.getProperty("mode");
        this.bindIPAddress = pps.getProperty("bind-ip-address");
        this.channelConfig = pps.getProperty("channel-config");
        this.channelName = pps.getProperty("channel-name");
        this.recDir = pps.getProperty("recovery-dir");
        this.ownName = pps.getProperty("node-name");
        this.participantsCluster = pps.getProperty("other-participants");
        this.sWaitConfirmation = pps.getProperty("wait-confirmation");
        ValuesParam vp = this.initParams.getValuesParam("repositories");
        this.repoNamesList = vp.getValues();
        if (vp == null || vp.getValues().size() == 0) {
            throw new RuntimeException("repositories not specified");
        }
        PropertiesParam backuParams = this.initParams.getPropertiesParam("replication-snapshot-properties");
        if (backuParams != null) {
            this.sBackupEnabled = backuParams.getProperty("snapshot-enabled");
            this.sBackupDir = backuParams.getProperty("snapshot-dir");
            this.sDelayTime = backuParams.getProperty("delay-time");
        } else {
            this.backupEnabled = false;
        }
        PropertiesParam priorityParams = this.initParams.getPropertiesParam("replication-priority-properties");
        if (priorityParams != null) {
            this.priprityType = priorityParams.getProperty("priority-type");
            this.ownValue = priorityParams.getProperty("node-priority");
        }
        log.info((Object)"Params is read from configuration file");
        this.checkParams();
    }

    private void checkParams() {
        if (this.enabled == null) {
            throw new RuntimeException("enabled not specified");
        }
        if (this.mode == null) {
            throw new RuntimeException("mode not specified");
        }
        if (!this.mode.equals(PERSISTENT_MODE) && !this.mode.equals(PROXY_MODE)) {
            throw new RuntimeException("Parameter 'mode' (persistent|proxy) required for replication configuration");
        }
        if (this.bindIPAddress == null) {
            throw new RuntimeException("bind-ip-address not specified");
        }
        if (this.channelConfig == null) {
            throw new RuntimeException("channel-config not specified");
        }
        if (this.channelName == null) {
            this.channelName = "";
        }
        if (this.testMode != null && "true".equals(this.testMode)) {
            this.channelName = IdGenerator.generate();
        }
        if (this.recDir == null) {
            throw new RuntimeException("Recovery dir not specified");
        }
        this.recoveryDir = new File(this.recDir);
        if (!PrivilegedFileHelper.exists((File)this.recoveryDir)) {
            PrivilegedFileHelper.mkdirs((File)this.recoveryDir);
        }
        if (this.mode.equals(PERSISTENT_MODE)) {
            if (this.ownName == null) {
                throw new RuntimeException("Node name not specified");
            }
            if (this.participantsCluster == null) {
                throw new RuntimeException("Other participants not specified");
            }
            this.participantsClusterList = new ArrayList<String>();
            String[] pc = this.participantsCluster.split(";");
            for (int i = 0; i < pc.length; ++i) {
                if (pc[i].equals("")) continue;
                this.participantsClusterList.add(pc[i]);
            }
        } else {
            boolean isTCPPing;
            boolean isMPing = this.isMPingConfigured();
            if (!(isMPing | (isTCPPing = this.isTCPPingConfigured()))) {
                throw new RuntimeException("The discovery protocol should be configured MPING or TCPPING protocol.");
            }
            if (this.ownName == null && isMPing) {
                throw new RuntimeException("Node name not specified");
            }
            if (this.participantsCluster == null && isMPing) {
                throw new RuntimeException("Other participants not specified");
            }
            this.participantsClusterList = new ArrayList<String>();
            if (isMPing) {
                String[] pc = this.participantsCluster.split(";");
                for (int i = 0; i < pc.length; ++i) {
                    if (pc[i].equals("")) continue;
                    this.participantsClusterList.add(pc[i]);
                }
            } else {
                List<String> initialHosts = this.getInitialHosts();
                if (this.participantsCluster != null) {
                    log.warn((Object)"The perameter 'other-participants' not use for TCPPING.");
                }
                if (this.ownName != null) {
                    log.warn((Object)"The perameter 'node-name' not use for TCPPING.");
                }
                for (String host : initialHosts) {
                    if (host.equals(this.bindIPAddress)) continue;
                    this.participantsClusterList.add(host);
                }
                this.ownName = this.bindIPAddress;
            }
        }
        if (this.sWaitConfirmation == null) {
            throw new RuntimeException("Wait confirmation not specified");
        }
        this.waitConfirmation = Long.valueOf(this.sWaitConfirmation);
        boolean bl = this.backupEnabled = this.sBackupEnabled == null ? false : Boolean.valueOf(this.sBackupEnabled);
        if (this.backupEnabled) {
            if (this.sBackupDir == null && this.backupEnabled) {
                throw new RuntimeException("Backup dir not specified");
            }
            if (this.backupEnabled) {
                this.backupDir = new File(this.sBackupDir);
                if (!PrivilegedFileHelper.exists((File)this.backupDir)) {
                    PrivilegedFileHelper.mkdirs((File)this.backupDir);
                }
            }
            if (this.sDelayTime == null && this.backupEnabled) {
                throw new RuntimeException("Backup dir not specified");
            }
            if (this.backupEnabled) {
                this.backupDelayTime = Long.parseLong(this.sDelayTime);
            }
            this.backupCreatorList = new ArrayList<BackupCreator>();
        }
        if (this.mode.equals(PERSISTENT_MODE)) {
            if (this.priprityType == null) {
                throw new RuntimeException("Priority type not specified");
            }
            if (!this.priprityType.equals(PRIORITY_STATIC_TYPE) && !this.priprityType.equals(PRIORITY_DYNAMIC_TYPE)) {
                throw new RuntimeException("Parameter 'priority-type' (static|dynamic) required for replication configuration");
            }
            if (this.ownValue == null) {
                throw new RuntimeException("Own Priority not specified");
            }
            this.ownPriority = Integer.valueOf(this.ownValue);
        } else {
            if (this.priprityType != null && !this.priprityType.equals(PRIORITY_GENERIC_TYPE)) {
                log.warn((Object)"The parameter 'replication-priority-properties' not use for proxy replication.");
            }
            this.priprityType = PRIORITY_GENERIC_TYPE;
        }
    }

    private List<String> getInitialHosts() {
        JChannel jChannel = null;
        try {
            jChannel = new JChannel(this.channelConfig.replaceAll(IP_ADRESS_TEMPLATE, this.bindIPAddress));
        }
        catch (ChannelException e) {
            throw new RuntimeException("Can not initialize the JChannel form 'channel-config'.", e);
        }
        String initial_hosts = null;
        for (Protocol p : jChannel.getProtocolStack().getProtocols()) {
            if (!p.getName().equals("TCPPING")) continue;
            Properties props = p.getProperties();
            initial_hosts = props.getProperty("initial_hosts");
        }
        if (initial_hosts == null) {
            throw new RuntimeException("The propery 'initial_hosts' not specified in TCPPING ");
        }
        ArrayList<String> initialHosts = new ArrayList<String>();
        for (String host : initial_hosts.split(",")) {
            initialHosts.add(host.substring(0, host.indexOf("[")));
        }
        return initialHosts;
    }

    private boolean isTCPPingConfigured() {
        return this.channelConfig.contains("TCPPING");
    }

    private boolean isMPingConfigured() {
        return this.channelConfig.contains("MPING");
    }

    public void setContext(ManagementContext context) {
        this.managementContext = context;
    }
}

