/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.hierarchy.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.HierarchyConfig;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewGroupListener
extends GroupEventListener {
    private HierarchyConfig config_;
    private RepositoryService jcrService_;
    private String groupsPath_;
    static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String GROUPS_PATH = "groupsPath";

    public NewGroupListener(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreatorService, InitParams params) throws Exception {
        this.jcrService_ = jcrService;
        this.config_ = (HierarchyConfig)params.getObjectParamValues(HierarchyConfig.class).get(0);
        this.groupsPath_ = nodeHierarchyCreatorService.getJcrPath(GROUPS_PATH);
    }

    public void preSave(Group group, boolean isNew) throws Exception {
        String groupId = null;
        String parentId = group.getParentId();
        groupId = parentId == null || parentId.length() == 0 ? "/" + group.getGroupName() : parentId + "/" + group.getGroupName();
        List repositories = this.jcrService_.getConfig().getRepositoryConfigurations();
        for (RepositoryEntry repo : repositories) {
            this.buildGroupStructure(repo.getName(), groupId);
        }
    }

    public void preDelete(Group group) throws Exception {
        String groupId = null;
        String parentId = group.getParentId();
        groupId = parentId == null || parentId.length() == 0 ? "/" + group.getGroupName() : parentId + "/" + group.getGroupName();
        List repositories = this.jcrService_.getConfig().getRepositoryConfigurations();
        for (RepositoryEntry repo : repositories) {
            try {
                this.removeGroup(repo.getName(), groupId);
            }
            catch (Exception e) {}
        }
    }

    private void removeGroup(String repoName, String groupId) throws Exception {
        ManageableRepository manageableRepository = this.jcrService_.getRepository(repoName);
        String systemWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        Session session = manageableRepository.getSystemSession(systemWorkspace);
        Node groupsHome = (Node)session.getItem(this.groupsPath_);
        Node groupNode = (Node)session.getItem(this.groupsPath_ + groupId);
        groupNode.remove();
        groupsHome.save();
        session.save();
        session.logout();
    }

    private void buildGroupStructure(String repository, String groupId) throws Exception {
        ManageableRepository manageableRepository = this.jcrService_.getRepository(repository);
        String systemWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        Session session = manageableRepository.getSystemSession(systemWorkspace);
        Node groupsHome = (Node)session.getItem(this.groupsPath_);
        Node groupNode = null;
        try {
            groupNode = (Node)session.getItem(this.groupsPath_ + groupId);
        }
        catch (PathNotFoundException e) {
            groupNode = groupsHome.addNode(groupId.substring(1, groupId.length()));
        }
        List<HierarchyConfig.JcrPath> jcrPaths = this.config_.getJcrPaths();
        for (HierarchyConfig.JcrPath jcrPath : jcrPaths) {
            this.createNode(groupNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), this.getPermissions(jcrPath.getPermissions(), groupId));
        }
        groupsHome.save();
        session.save();
        session.logout();
    }

    private void createNode(Node rootNode, String path, String nodeType, List<String> mixinTypes, Map permissions) throws Exception {
        Node node = rootNode;
        for (String token : path.split("/")) {
            try {
                node = node.getNode(token);
            }
            catch (PathNotFoundException e) {
                if (nodeType == null || nodeType.length() == 0) {
                    nodeType = NT_UNSTRUCTURED;
                }
                if ((node = node.addNode(token, nodeType)).canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                }
                if (permissions != null) {
                    ((ExtendedNode)node).setPermissions(permissions);
                }
                if (mixinTypes.size() <= 0) continue;
                for (String mixin : mixinTypes) {
                    if (!node.canAddMixin(mixin)) continue;
                    node.addMixin(mixin);
                }
            }
        }
    }

    private Map getPermissions(List<HierarchyConfig.Permission> permissions, String groupId) {
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        String groupIdentity = "*:".concat(groupId);
        permissionsMap.put(groupIdentity, PermissionType.ALL);
        for (HierarchyConfig.Permission permission : permissions) {
            StringBuilder strPer = new StringBuilder();
            if ("true".equals(permission.getRead())) {
                strPer.append("read");
            }
            if ("true".equals(permission.getAddNode())) {
                strPer.append(",").append("add_node");
            }
            if ("true".equals(permission.getSetProperty())) {
                strPer.append(",").append("set_property");
            }
            if ("true".equals(permission.getRemove())) {
                strPer.append(",").append("remove");
            }
            permissionsMap.put(permission.getIdentity(), strPer.toString().split(","));
        }
        return permissionsMap;
    }
}

