/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.security.impl.CredentialsImpl;

public class SessionProvider {
    private Map<String, Session> cache = new HashMap<String, Session>();
    private Credentials credentials;

    public SessionProvider(Credentials cred) {
        this.credentials = cred;
    }

    public static SessionProvider createSystemProvider() {
        return new SessionProvider((Credentials)new CredentialsImpl(SystemIdentity.SYSTEM, "".toCharArray()));
    }

    public static SessionProvider createAnonimProvider() {
        return new SessionProvider((Credentials)new CredentialsImpl(SystemIdentity.ANONIM, "".toCharArray()));
    }

    public Session getSession(String workspaceName, ManageableRepository repository) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (workspaceName == null) {
            throw new NullPointerException("Workspace Name is null");
        }
        String repositoryName = repository.getConfiguration().getName();
        Session session = this.cache.get(repositoryName + workspaceName);
        if (session == null) {
            session = this.credentials == null ? repository.login(workspaceName) : repository.login(this.credentials, workspaceName);
            this.cache.put(repositoryName + workspaceName, session);
        }
        return session;
    }

    public void close() {
        Collection<Session> cachedSessions = this.cache.values();
        for (Session curSession : cachedSessions) {
            curSession.logout();
        }
        this.cache.clear();
    }
}

