/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.exoplatform.services.jcr.ext.replication.FixupStream;

public class Packet
implements Externalizable {
    public static final int MAX_PACKET_SIZE = 16384;
    private byte[] buffer_;
    private long size_;
    private int type_;
    private long offset_;
    private String identifier;
    private FixupStream fixupStream;

    public Packet() {
    }

    public Packet(int type, long size, byte[] buffer, String identifier_) {
        this.identifier = identifier_;
        this.type_ = type;
        this.size_ = size;
        this.buffer_ = new byte[buffer.length];
        for (int i = 0; i < buffer.length; ++i) {
            this.buffer_[i] = buffer[i];
        }
        this.fixupStream = new FixupStream();
    }

    public Packet(int type, String identifier_) {
        this.type_ = type;
        this.identifier = identifier_;
        this.buffer_ = new byte[1];
        this.fixupStream = new FixupStream();
    }

    public Packet(int type, FixupStream fs, String identifier_) {
        this.type_ = type;
        this.fixupStream = fs;
        this.identifier = identifier_;
        this.buffer_ = new byte[1];
    }

    public Packet(int type, FixupStream fs, String identifier_, byte[] buf) {
        this.type_ = type;
        this.fixupStream = fs;
        this.identifier = identifier_;
        this.buffer_ = new byte[buf.length];
        for (int i = 0; i < buf.length; ++i) {
            this.buffer_[i] = buf[i];
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.buffer_.length);
        out.write(this.buffer_);
        out.writeLong(this.size_);
        out.writeInt(this.type_);
        out.writeLong(this.offset_);
        out.writeInt(this.identifier.getBytes().length);
        out.write(this.identifier.getBytes());
        out.writeInt(this.fixupStream.getItemSateId());
        out.writeInt(this.fixupStream.getValueDataId());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int bufSize = in.readInt();
        this.buffer_ = new byte[bufSize];
        in.readFully(this.buffer_);
        this.size_ = in.readLong();
        this.type_ = in.readInt();
        this.offset_ = in.readLong();
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        this.identifier = new String(buf);
        int item = in.readInt();
        int value = in.readInt();
        this.fixupStream = new FixupStream(item, value);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public byte[] getByteArray() {
        return this.buffer_;
    }

    public long getSize() {
        return this.size_;
    }

    public int getPacketType() {
        return this.type_;
    }

    public long getOffset() {
        return this.offset_;
    }

    public void setOffset(long offset) {
        this.offset_ = offset;
    }

    public FixupStream getFixupStream() {
        return this.fixupStream;
    }

    public void setFixupStream(FixupStream fs) {
        this.fixupStream = fs;
    }

    public static byte[] getAsByteArray(Packet packet) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(packet);
        byte[] bArray = os.toByteArray();
        return bArray;
    }

    public static Packet getAsPacket(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
        ObjectInputStream ois = new ObjectInputStream(is);
        Packet objRead = (Packet)ois.readObject();
        return objRead;
    }

    public class PacketType {
        public static final int ItemDataChangesLog = 1;
        public static final int First_ItemDataChangesLog_with_Streams = 2;
        public static final int First_Packet_of_Stream = 3;
        public static final int Packet_of_Stream = 4;
        public static final int Last_Packet_of_Stream = 5;
        public static final int Last_ItemDataChangesLog_with_Streams = 6;
        public static final int ItemDataChangesLog_First_Packet = 7;
        public static final int ItemDataChangesLog_Middle_Packet = 8;
        public static final int ItemDataChangesLog_Last_Packet = 9;
        public static final int ItemDataChangesLog_with_Stream_First_Packet = 10;
        public static final int ItemDataChangesLog_with_Stream_Middle_Packet = 11;
        public static final int ItemDataChangesLog_with_Stream_Last_Packet = 12;
    }
}

