/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditRecord;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.log.ExoLogger;

public class AuditServiceImpl
implements AuditService {
    private static Log log = ExoLogger.getLogger((String)"jcr.AuditService");
    private List<String> adminIdentitys = null;

    public AuditServiceImpl(InitParams params, RepositoryService repService) throws RepositoryConfigurationException {
        ValueParam valParam = null;
        String adminIdentity = null;
        if (params != null && (valParam = params.getValueParam("adminIdentity")) != null) {
            adminIdentity = valParam.getValue();
        }
        if (adminIdentity == null) {
            throw new RepositoryConfigurationException("Admin identity is not configured");
        }
        StringTokenizer listTokenizer = new StringTokenizer(adminIdentity, ";");
        if (listTokenizer.countTokens() < 1) {
            throw new RepositoryConfigurationException("AccessControlList " + adminIdentity + " is empty or have a bad format");
        }
        this.adminIdentitys = new ArrayList<String>(listTokenizer.countTokens());
        while (listTokenizer.hasMoreTokens()) {
            this.adminIdentitys.add(listTokenizer.nextToken());
        }
    }

    public void addRecord(Item item, int eventType) throws RepositoryException {
        NodeData vancestor;
        String auditRecordName;
        this.checkIfAuditable(item);
        AuditSession auditSession = new AuditSession(item);
        SessionImpl session = (SessionImpl)item.getSession();
        SessionDataManager dataManager = auditSession.getDataManager();
        NodeData auditHistory = auditSession.getAuditHistoryNodeData();
        if (auditHistory == null) {
            throw new PathNotFoundException("Audit history not found for " + item.getPath());
        }
        if (auditHistory == null) {
            throw new RepositoryException("Audit history for  " + item.getPath() + "not found");
        }
        QPath path = QPath.makeChildPath((QPath)auditHistory.getQPath(), (InternalQName)AuditService.EXO_AUDITHISTORY_LASTRECORD);
        PropertyData pData = (PropertyData)dataManager.getItemData(path);
        try {
            auditRecordName = String.valueOf((int)ValueDataConvertor.readLong((ValueData)((ValueData)pData.getValues().get(0))) + 1);
        }
        catch (Exception e) {
            throw new RepositoryException("Error on add audit record. Problem in calculating new record name. " + e.getLocalizedMessage());
        }
        TransientNodeData arNode = TransientNodeData.createNodeData((NodeData)auditHistory, (InternalQName)new InternalQName(null, auditRecordName), (InternalQName)AuditService.EXO_AUDITRECORD);
        ArrayList<AccessControlEntry> access = new ArrayList<AccessControlEntry>();
        access.add(new AccessControlEntry(SystemIdentity.ANY, "set_property"));
        access.add(new AccessControlEntry(SystemIdentity.ANY, "read"));
        for (String identity : this.adminIdentitys) {
            access.add(new AccessControlEntry(identity, "remove"));
        }
        AccessControlList exoAuditRecordAccessControlList = new AccessControlList(session.getUserID(), access);
        arNode.setACL(exoAuditRecordAccessControlList);
        arNode.setOrderNumber(Integer.parseInt(auditRecordName));
        dataManager.update(new ItemState((ItemData)arNode, 1, true, ((ItemImpl)item).getInternalPath()), true);
        TransientPropertyData arPrType = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)Constants.JCR_PRIMARYTYPE, (int)7, (boolean)false);
        arPrType.setValue((ValueData)new TransientValueData(arNode.getPrimaryTypeName()));
        TransientPropertyData arUser = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_USER, (int)1, (boolean)false);
        arUser.setValue((ValueData)new TransientValueData(session.getUserID()));
        TransientPropertyData arCreated = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_CREATED, (int)5, (boolean)false);
        arCreated.setValue((ValueData)new TransientValueData(dataManager.getTransactManager().getStorageDataManager().getCurrentTime()));
        TransientPropertyData arEventType = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_EVENTTYPE, (int)3, (boolean)false);
        arEventType.setValue((ValueData)new TransientValueData((long)eventType));
        dataManager.update(new ItemState((ItemData)arPrType, 1, true, ((ItemImpl)item).getInternalPath()), true);
        dataManager.update(new ItemState((ItemData)arUser, 1, true, ((ItemImpl)item).getInternalPath()), true);
        dataManager.update(new ItemState((ItemData)arCreated, 1, true, ((ItemImpl)item).getInternalPath()), true);
        dataManager.update(new ItemState((ItemData)arEventType, 1, true, ((ItemImpl)item).getInternalPath()), true);
        if (item.isNode()) {
            vancestor = ((NodeImpl)item).getVersionableAncestor();
        } else {
            vancestor = ((NodeImpl)((Property)item).getParent()).getVersionableAncestor();
            TransientPropertyData propertyNameData = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)EXO_AUDITRECORD_PROPERTYNAME, (int)1, (boolean)false);
            propertyNameData.setValue((ValueData)new TransientValueData(((ItemImpl)item).getInternalName()));
            dataManager.update(new ItemState((ItemData)propertyNameData, 1, true, ((ItemImpl)item).getInternalPath()), true);
        }
        if (vancestor != null) {
            String versionName;
            String versionUUID;
            PropertyData bvProp = (PropertyData)dataManager.getItemData(vancestor, new QPathEntry(Constants.JCR_BASEVERSION, 1));
            try {
                versionUUID = ValueDataConvertor.readString((ValueData)((ValueData)bvProp.getValues().get(0)));
                Version version = (Version)dataManager.getItemByIdentifier(versionUUID, false);
                versionName = version.getName();
                VersionHistory versionHistory = (VersionHistory)dataManager.getItemByIdentifier(version.getParent().getUUID(), false);
                String[] labels = versionHistory.getVersionLabels(version);
                for (int i = 0; i < labels.length; ++i) {
                    String vl = labels[i];
                    if (i == 0) {
                        versionName = versionName + " ";
                    }
                    versionName = versionName + "'" + vl + "' ";
                }
            }
            catch (IOException e) {
                throw new RepositoryException("Can't read jcr:baseVersion property, error " + e, (Throwable)e);
            }
            TransientPropertyData auditVersion = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)EXO_AUDITRECORD_AUDITVERSION, (int)1, (boolean)false, (ValueData)new TransientValueData(versionUUID));
            TransientPropertyData auditVersionName = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)EXO_AUDITRECORD_AUDITVERSIONNAME, (int)1, (boolean)false, (ValueData)new TransientValueData(versionName));
            dataManager.update(new ItemState((ItemData)auditVersion, 1, true, ((ItemImpl)item).getInternalPath()), true);
            dataManager.update(new ItemState((ItemData)auditVersionName, 1, true, ((ItemImpl)item).getInternalPath()), true);
        }
        TransientPropertyData pLastRecord = (TransientPropertyData)auditSession.getDataManager().getItemData(QPath.makeChildPath((QPath)auditHistory.getQPath(), (InternalQName)EXO_AUDITHISTORY_LASTRECORD));
        pLastRecord.setValue((ValueData)new TransientValueData(String.valueOf(auditRecordName)));
        dataManager.update(new ItemState((ItemData)pLastRecord, 2, true, ((ItemImpl)item).getInternalPath()), true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add audit record:  Item path=" + ((ItemImpl)item).getLocation().getInternalPath().getAsString() + " User=" + session.getUserID() + " EventType=" + eventType));
        }
    }

    public void createHistory(Node node) throws RepositoryException {
        this.checkIfAuditable((Item)node);
        AuditSession auditSession = new AuditSession((Item)node);
        NodeData storage = auditSession.getAuditStorage();
        SessionImpl session = (SessionImpl)node.getSession();
        InternalQName aiName = new InternalQName(null, ((ItemImpl)node).getData().getIdentifier());
        TransientNodeData ahNode = TransientNodeData.createNodeData((NodeData)storage, (InternalQName)aiName, (InternalQName)AuditService.EXO_AUDITHISTORY);
        ArrayList<AccessControlEntry> access = new ArrayList<AccessControlEntry>();
        access.add(new AccessControlEntry(SystemIdentity.ANY, "add_node"));
        access.add(new AccessControlEntry(SystemIdentity.ANY, "read"));
        access.add(new AccessControlEntry(SystemIdentity.ANY, "set_property"));
        for (String identity : this.adminIdentitys) {
            access.add(new AccessControlEntry(identity, "remove"));
        }
        AccessControlList exoAuditHistoryAccessControlList = new AccessControlList(session.getUserID(), access);
        ahNode.setACL(exoAuditHistoryAccessControlList);
        ahNode.setMixinTypeNames(new InternalQName[]{Constants.MIX_REFERENCEABLE, Constants.EXO_PRIVILEGEABLE});
        TransientPropertyData aPrType = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.JCR_PRIMARYTYPE, (int)7, (boolean)false);
        aPrType.setValue((ValueData)new TransientValueData(ahNode.getPrimaryTypeName()));
        TransientPropertyData ahUuid = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.JCR_UUID, (int)1, (boolean)false);
        ahUuid.setValue((ValueData)new TransientValueData(ahNode.getIdentifier()));
        TransientPropertyData ahMixinTypes = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.JCR_MIXINTYPES, (int)7, (boolean)false);
        ArrayList<TransientValueData> mixValues = new ArrayList<TransientValueData>();
        mixValues.add(new TransientValueData(Constants.MIX_REFERENCEABLE));
        mixValues.add(new TransientValueData(Constants.EXO_PRIVILEGEABLE));
        ahMixinTypes.setValues(mixValues);
        ArrayList<TransientValueData> permsValues = new ArrayList<TransientValueData>();
        for (int i = 0; i < ahNode.getACL().getPermissionEntries().size(); ++i) {
            AccessControlEntry entry = (AccessControlEntry)ahNode.getACL().getPermissionEntries().get(i);
            permsValues.add(new TransientValueData(entry));
        }
        TransientPropertyData exoAuditPerms = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.EXO_PERMISSIONS, (int)100, (boolean)true, permsValues);
        TransientPropertyData ahTargetNode = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)AuditService.EXO_AUDITHISTORY_TARGETNODE, (int)9, (boolean)false);
        ahTargetNode.setValue((ValueData)new TransientValueData(((ItemImpl)node).getData().getIdentifier()));
        TransientPropertyData ahLastRecord = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)AuditService.EXO_AUDITHISTORY_LASTRECORD, (int)1, (boolean)false);
        ahLastRecord.setValue((ValueData)new TransientValueData("0"));
        TransientPropertyData pAuditHistory = TransientPropertyData.createPropertyData((NodeData)((NodeData)((ItemImpl)node).getData()), (InternalQName)AuditService.EXO_AUDITHISTORY, (int)1, (boolean)false);
        pAuditHistory.setValue((ValueData)new TransientValueData(new Identifier(ahNode.getIdentifier())));
        session.getTransientNodesManager().update(new ItemState((ItemData)ahNode, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)aPrType, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahUuid, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahMixinTypes, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)exoAuditPerms, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahTargetNode, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahLastRecord, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)pAuditHistory, 1, true, ((ItemImpl)node).getInternalPath()), true);
    }

    public AuditHistory getHistory(Node node) throws RepositoryException, UnsupportedOperationException {
        AuditSession auditSession = new AuditSession((Item)node);
        SessionDataManager dm = auditSession.getDataManager();
        NodeData auditHistory = auditSession.getAuditHistoryNodeData();
        if (auditHistory != null) {
            ArrayList<AuditRecord> auditRecords = new ArrayList<AuditRecord>();
            ValueFactoryImpl vf = (ValueFactoryImpl)node.getSession().getValueFactory();
            List auditRecordsNodeData = dm.getChildNodesData(auditHistory);
            for (NodeData nodeData : auditRecordsNodeData) {
                List auditRecordNodeData = dm.getChildPropertiesData(nodeData);
                String user = null;
                InternalQName propertyName = null;
                int eventType = -1;
                Calendar date = null;
                String version = null;
                String versionName = null;
                try {
                    for (PropertyData propertyData : auditRecordNodeData) {
                        ValueData value = (ValueData)propertyData.getValues().get(0);
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_USER)) {
                            user = ValueDataConvertor.readString((ValueData)value);
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_EVENTTYPE)) {
                            eventType = (int)ValueDataConvertor.readLong((ValueData)value);
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_CREATED)) {
                            date = ValueDataConvertor.readDate((ValueData)value);
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_PROPERTYNAME)) {
                            propertyName = InternalQName.parse((String)ValueDataConvertor.readString((ValueData)value));
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_AUDITVERSION)) {
                            version = ValueDataConvertor.readString((ValueData)value);
                            continue;
                        }
                        if (!propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_AUDITVERSIONNAME)) continue;
                        versionName = ValueDataConvertor.readString((ValueData)value);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RepositoryException((Throwable)e);
                }
                catch (IllegalStateException e) {
                    throw new RepositoryException((Throwable)e);
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
                catch (IllegalNameException e) {
                    throw new RepositoryException((Throwable)e);
                }
                auditRecords.add(new AuditRecord(user, eventType, date, propertyName, version, versionName));
            }
            return new AuditHistory(node, auditRecords);
        }
        throw new PathNotFoundException("Audit history not found for " + node.getPath());
    }

    public boolean hasHistory(Node node) {
        NodeData data;
        try {
            AuditSession auditSession = new AuditSession((Item)node);
            data = auditSession.getAuditHistoryNodeData();
        }
        catch (RepositoryException e) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Audit history for " + node.getPath() + " not accessible due to error " + (Object)((Object)e)), (Throwable)e);
                }
            }
            catch (RepositoryException e1) {
                log.error((Object)("Can't read node path for " + node), (Throwable)e1);
            }
            return false;
        }
        return data != null;
    }

    public void removeHistory(Node node) throws RepositoryException {
        AuditSession auditSession = new AuditSession((Item)node);
        NodeData auditHistory = auditSession.getAuditHistoryNodeData();
        if (auditHistory == null) {
            throw new PathNotFoundException("Audit history not found for " + node.getPath());
        }
        SessionImpl session = (SessionImpl)node.getSession();
        session.getTransientNodesManager().delete((ItemData)auditHistory);
    }

    private void checkIfAuditable(Item item) throws RepositoryException, UnsupportedOperationException {
        NodeImpl node;
        NodeImpl nodeImpl = node = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        if (!node.isNodeType("exo:auditable")) {
            throw new ConstraintViolationException("exo:auditable node expected at: " + node.getPath());
        }
    }

    private class AuditSession {
        private final SessionImpl session;
        private final SessionDataManager dataManager;
        private ExtendedNode node;

        private AuditSession(Item item) throws RepositoryException {
            this.session = (SessionImpl)item.getSession();
            this.node = item.isNode() ? (ExtendedNode)item : (ExtendedNode)item.getParent();
            if (!this.node.isNodeType(AuditService.EXO_AUDITABLE)) {
                throw new RepositoryException("Node is not exo:auditable " + this.node.getPath());
            }
            this.dataManager = this.session.getTransientNodesManager();
        }

        private NodeData getAuditHistoryNodeData() throws RepositoryException {
            PropertyData pData = (PropertyData)this.dataManager.getItemData((NodeData)((NodeImpl)this.node).getData(), new QPathEntry(AuditService.EXO_AUDITHISTORY, 0));
            if (pData != null) {
                try {
                    String ahUuid = ValueDataConvertor.readString((ValueData)((ValueData)pData.getValues().get(0)));
                    return (NodeData)this.dataManager.getItemData(ahUuid);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RepositoryException("Error of exo:auditHistory read", (Throwable)e);
                }
                catch (IllegalStateException e) {
                    throw new RepositoryException("Error of exo:auditHistory read", (Throwable)e);
                }
                catch (IOException e) {
                    throw new RepositoryException("Error of exo:auditHistory read", (Throwable)e);
                }
            }
            return null;
        }

        private NodeData getAuditStorage() throws RepositoryException {
            ItemData storage = this.session.getTransientNodesManager().getItemData("00exo0jcr0audit0storage0id000000");
            if (storage == null) {
                SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
                TransientNodeData exoAuditNode = TransientNodeData.createNodeData((NodeData)((NodeData)((NodeImpl)this.session.getRootNode()).getData()), (InternalQName)AuditService.EXO_AUDIT, (InternalQName)AuditService.EXO_AUDITSTORAGE, (String)"00exo0jcr0audit0storage0id000000");
                ArrayList<AccessControlEntry> access = new ArrayList<AccessControlEntry>();
                access.add(new AccessControlEntry(SystemIdentity.ANY, "add_node"));
                for (String identity : AuditServiceImpl.this.adminIdentitys) {
                    access.add(new AccessControlEntry(identity, "read"));
                }
                access.add(new AccessControlEntry(SystemIdentity.ANY, "remove"));
                AccessControlList exoAuditAccessControlList = new AccessControlList(SystemIdentity.SYSTEM, access);
                exoAuditNode.setACL(exoAuditAccessControlList);
                InternalQName[] mixins = new InternalQName[]{Constants.EXO_PRIVILEGEABLE, Constants.MIX_REFERENCEABLE};
                exoAuditNode.setMixinTypeNames(mixins);
                TransientPropertyData exoAuditPrType = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.JCR_PRIMARYTYPE, (int)7, (boolean)false);
                exoAuditPrType.setValue((ValueData)new TransientValueData(exoAuditNode.getPrimaryTypeName()));
                TransientPropertyData exoAuditUuid = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.JCR_UUID, (int)1, (boolean)false);
                exoAuditUuid.setValue((ValueData)new TransientValueData(exoAuditNode.getIdentifier()));
                TransientPropertyData exoAuditMixinTypes = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.JCR_MIXINTYPES, (int)7, (boolean)true);
                ArrayList<TransientValueData> mixValues = new ArrayList<TransientValueData>();
                mixValues.add(new TransientValueData(Constants.MIX_REFERENCEABLE));
                mixValues.add(new TransientValueData(Constants.EXO_PRIVILEGEABLE));
                exoAuditMixinTypes.setValues(mixValues);
                ArrayList<TransientValueData> permsValues = new ArrayList<TransientValueData>();
                for (int i = 0; i < exoAuditNode.getACL().getPermissionEntries().size(); ++i) {
                    AccessControlEntry entry = (AccessControlEntry)exoAuditNode.getACL().getPermissionEntries().get(i);
                    permsValues.add(new TransientValueData(entry));
                }
                TransientPropertyData exoAuditPerms = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.EXO_PERMISSIONS, (int)100, (boolean)true, permsValues);
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditNode));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditPrType));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditUuid));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditMixinTypes));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditPerms));
                this.session.getTransientNodesManager().getTransactManager().save((ItemStateChangesLog)changesLog);
                storage = this.session.getTransientNodesManager().getItemData("00exo0jcr0audit0storage0id000000");
            }
            if (!storage.isNode()) {
                throw new RepositoryException("Item with uuid 00exo0jcr0audit0storage0id000000 should be node  ");
            }
            return (NodeData)storage;
        }

        private SessionDataManager getDataManager() {
            return this.dataManager;
        }
    }
}

