/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.replication.AbstractWorkspaceDataReceiver;
import org.exoplatform.services.jcr.ext.replication.PersistentWorkspaceDataReceiver;
import org.exoplatform.services.jcr.ext.replication.ProxyWorkspaceDataReceiver;
import org.exoplatform.services.jcr.ext.replication.WorkspaceDataManagerProxy;
import org.exoplatform.services.jcr.ext.replication.WorkspaceDataTransmitter;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryManager;
import org.exoplatform.services.jcr.ext.replication.recovery.backup.BackupCreator;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.MessageDispatcher;
import org.picocontainer.Startable;

public class ReplicationService
implements Startable {
    protected static Log log = ExoLogger.getLogger((String)"ext.ReplicationService");
    private static final String IP_ADRESS_TEMPLATE = "[$]bind-ip-address";
    private static final String PERSISTENT_MODE = "persistent";
    private static final String PROXY_MODE = "proxy";
    private RepositoryService repoService;
    private String testMode;
    private String enabled;
    private String mode;
    private String bindIPAdaress;
    private String channelConfig;
    private List<String> repoNamesList;
    private File recoveryDir;
    private String ownName;
    private List<String> participantsClusterList;
    private long waitConformation;
    private boolean backupEnabled;
    private File backupDir;
    private long backupDelayTime = 0L;
    private List<BackupCreator> backupCreatorList;

    public ReplicationService(RepositoryService repoService, InitParams params) throws RepositoryConfigurationException {
        this.repoService = repoService;
        PropertiesParam pps = params.getPropertiesParam("replication-properties");
        this.testMode = pps.getProperty("test-mode");
        this.enabled = pps.getProperty("enabled");
        if (this.enabled == null) {
            throw new RepositoryConfigurationException("enabled not specified");
        }
        this.mode = pps.getProperty("mode");
        if (this.mode == null) {
            throw new RepositoryConfigurationException("mode not specified");
        }
        if (!this.mode.equals(PERSISTENT_MODE) && !this.mode.equals(PROXY_MODE)) {
            throw new RepositoryConfigurationException("Parameter 'mode' (persistent|proxy) required for replication configuration");
        }
        this.bindIPAdaress = pps.getProperty("bind-ip-address");
        if (this.bindIPAdaress == null) {
            throw new RepositoryConfigurationException("bind-ip-address not specified");
        }
        this.channelConfig = pps.getProperty("channel-config");
        if (this.channelConfig == null) {
            throw new RepositoryConfigurationException("channel-config not specified");
        }
        ValuesParam vp = params.getValuesParam("repositories");
        if (vp == null || vp.getValues().size() == 0) {
            throw new RepositoryConfigurationException("repositories not specified");
        }
        this.repoNamesList = vp.getValues();
        String rDir = pps.getProperty("recovery-dir");
        if (rDir == null) {
            throw new RepositoryConfigurationException("Recovery dir not specified");
        }
        this.recoveryDir = new File(rDir);
        if (!this.recoveryDir.exists()) {
            this.recoveryDir.mkdirs();
        }
        this.ownName = pps.getProperty("node-name");
        if (this.ownName == null) {
            throw new RepositoryConfigurationException("Node name not specified");
        }
        String participantsCluster = pps.getProperty("other-participants");
        if (participantsCluster == null) {
            throw new RepositoryConfigurationException("Other participants not specified");
        }
        this.participantsClusterList = new ArrayList<String>();
        String[] pc = participantsCluster.split(";");
        for (int i = 0; i < pc.length; ++i) {
            if (pc[i].equals("")) continue;
            this.participantsClusterList.add(pc[i]);
        }
        String sWaitConformation = pps.getProperty("wait-confirmation");
        if (sWaitConformation == null) {
            throw new RepositoryConfigurationException("Wait conformation not specified");
        }
        this.waitConformation = Long.valueOf(sWaitConformation);
        PropertiesParam backuParams = params.getPropertiesParam("replication-snapshot-properties");
        if (backuParams != null) {
            String sDelayTime;
            String sBackupEnabled = backuParams.getProperty("snapshot-enabled");
            this.backupEnabled = sBackupEnabled == null ? false : Boolean.valueOf(sBackupEnabled);
            String sBackupDir = backuParams.getProperty("snapshot-dir");
            if (sBackupDir == null && this.backupEnabled) {
                throw new RepositoryConfigurationException("Backup dir not specified");
            }
            if (this.backupEnabled) {
                this.backupDir = new File(sBackupDir);
                if (!this.backupDir.exists()) {
                    this.backupDir.mkdirs();
                }
            }
            if ((sDelayTime = backuParams.getProperty("delay-time")) == null && this.backupEnabled) {
                throw new RepositoryConfigurationException("Backup dir not specified");
            }
            if (this.backupEnabled) {
                this.backupDelayTime = Long.parseLong(sDelayTime);
            }
            this.backupCreatorList = new ArrayList<BackupCreator>();
        } else {
            this.backupEnabled = false;
        }
    }

    public void start() {
        try {
            for (int rIndex = 0; rIndex < this.repoNamesList.size(); ++rIndex) {
                int wIndex;
                RepositoryImpl jcrRepository = (RepositoryImpl)this.repoService.getRepository(this.repoNamesList.get(rIndex));
                String[] workspaces = jcrRepository.getWorkspaceNames();
                if (this.enabled.equals("true")) {
                    if (this.testMode != null && "true".equals(this.testMode)) {
                        this.ownName = rIndex == 0 ? "cluster_node_1" : "cluster_node_2";
                        this.participantsClusterList = new ArrayList<String>();
                        if (rIndex == 0) {
                            this.participantsClusterList.add("cluster_node_2");
                        } else {
                            this.participantsClusterList.add("cluster_node_1");
                        }
                    }
                    for (wIndex = 0; wIndex < workspaces.length; ++wIndex) {
                        try {
                            File dir = new File(this.recoveryDir.getAbsolutePath() + File.separator + this.repoNamesList.get(rIndex) + "_" + workspaces[wIndex]);
                            dir.mkdirs();
                            String systemId = IdGenerator.generate();
                            String props = this.channelConfig.replaceAll(IP_ADRESS_TEMPLATE, this.bindIPAdaress);
                            JChannel channel = new JChannel(props);
                            MessageDispatcher disp = new MessageDispatcher((Channel)channel, null, null, null);
                            RecoveryManager recoveryManager = new RecoveryManager(dir, this.ownName, systemId, this.participantsClusterList, this.waitConformation, jcrRepository.getName(), workspaces[wIndex], disp);
                            WorkspaceContainer wContainer = (WorkspaceContainer)jcrRepository.getSystemSession(workspaces[wIndex]).getContainer();
                            wContainer.registerComponentImplementation(WorkspaceDataTransmitter.class);
                            WorkspaceDataTransmitter dataTransmitter = (WorkspaceDataTransmitter)wContainer.getComponentInstanceOfType(WorkspaceDataTransmitter.class);
                            dataTransmitter.init(disp, systemId, this.ownName, recoveryManager);
                            String uniqueNoame = jcrRepository.getName() + "_" + workspaces[wIndex];
                            if (this.testMode != null && "true".equals(this.testMode)) {
                                uniqueNoame = "Test_Channel";
                            }
                            AbstractWorkspaceDataReceiver dataReceiver = null;
                            if (this.mode.equals(PROXY_MODE)) {
                                wContainer.registerComponentImplementation(WorkspaceDataManagerProxy.class);
                                wContainer.registerComponentImplementation(ProxyWorkspaceDataReceiver.class);
                                dataReceiver = (ProxyWorkspaceDataReceiver)wContainer.getComponentInstanceOfType(ProxyWorkspaceDataReceiver.class);
                            } else if (this.mode.equals(PERSISTENT_MODE)) {
                                wContainer.registerComponentImplementation(PersistentWorkspaceDataReceiver.class);
                                dataReceiver = (PersistentWorkspaceDataReceiver)wContainer.getComponentInstanceOfType(PersistentWorkspaceDataReceiver.class);
                            }
                            recoveryManager.setDataKeeper(dataReceiver.getDataKeeper());
                            dataReceiver.init(disp, systemId, this.ownName, recoveryManager);
                            channel.connect(uniqueNoame);
                            dataReceiver.start();
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)("Can not start replication on " + this.repoNamesList.get(rIndex) + "_" + workspaces[wIndex] + " \n" + e), (Throwable)e);
                        }
                    }
                }
                if (!this.backupEnabled) continue;
                for (wIndex = 0; wIndex < workspaces.length; ++wIndex) {
                    this.backupCreatorList.add(this.initWorkspaceBackup(this.repoNamesList.get(rIndex), workspaces[wIndex]));
                }
            }
        }
        catch (RepositoryException re) {
            log.error((Object)("Can not start ReplicationService \n" + (Object)((Object)re)), (Throwable)re);
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)("Can not start ReplicationService \n" + (Object)((Object)e)), (Throwable)e);
        }
    }

    private String getUniqueName(RepositoryEntry configuration, String workspaceName) {
        List wEntrys = configuration.getWorkspaceEntries();
        for (WorkspaceEntry wEntry : wEntrys) {
            if (!workspaceName.equals(wEntry.getName())) continue;
            return wEntry.getUniqueName();
        }
        return null;
    }

    private BackupCreator initWorkspaceBackup(String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository manageableRepository = this.repoService.getRepository(repositoryName);
        BackupCreator backupCreator = new BackupCreator(this.backupDelayTime, workspaceName, this.backupDir, manageableRepository);
        return backupCreator;
    }

    public void stop() {
    }
}

