/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test;

import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.replication.ReplicationService;
import org.exoplatform.services.jcr.ext.replication.test.CopyMoveTestCase;
import org.exoplatform.services.jcr.ext.replication.test.DeleteTestCase;
import org.exoplatform.services.jcr.ext.replication.test.LockTestCase;
import org.exoplatform.services.jcr.ext.replication.test.NtFileTestCase;
import org.exoplatform.services.jcr.ext.replication.test.VersionTestCase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryTemplate;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;

@URITemplate(value="/replication-test/")
@OutputTransformer(value=StringOutputTransformer.class)
public class ReplicationTestService
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger((String)"ext.ReplicationTestService");
    private RepositoryService repositoryService;
    private BackupManager backupManager;

    public ReplicationTestService(RepositoryService repoService, ReplicationService replicationService, BackupManager backupManager, InitParams params) {
        this.repositoryService = repoService;
        this.backupManager = backupManager;
        log.info((Object)"ReplicationTestService inited");
    }

    public ReplicationTestService(RepositoryService repoService, BackupManager backupManager, InitParams params) {
        this(repoService, null, backupManager, params);
    }

    @QueryTemplate(value="operation=addNTFile")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/{fileName}/{fileSize}/")
    public Response addNTFile(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath, @URIParam(value="fileName") String fileName, @URIParam(value="fileSize") Long fileSize) {
        NtFileTestCase ntFileTestCase = new NtFileTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = ntFileTestCase.addNtFile(repoPath, fileName, fileSize);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=checkNTFile")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/{fileName}/{fileSize}/")
    public Response checkNTFile(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath, @URIParam(value="fileName") String fileName, @URIParam(value="fileSize") Long fileSize) {
        NtFileTestCase ntFileTestCase = new NtFileTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = ntFileTestCase.checkNtFile(repoPath, fileName, fileSize);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=startBackup")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{incementalPeriod}/")
    public Response startBackup(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="incementalPeriod") Long incementalPeriod) {
        BackupConfig config = new BackupConfig();
        config.setRepository(repositoryName);
        config.setWorkspace(workspaceName);
        config.setFullBackupType("org.exoplatform.services.jcr.ext.backup.impl.fs.FullBackupJob");
        config.setIncrementalBackupType("org.exoplatform.services.jcr.ext.backup.impl.fs.IncrementalBackupJob");
        config.setBackupDir(this.backupManager.getBackupDirectory());
        config.setIncrementalJobPeriod(incementalPeriod);
        String result = "ok";
        try {
            this.backupManager.startBackup(config);
        }
        catch (Exception e) {
            result = "fail";
            log.error((Object)"Can't start backup", (Throwable)e);
        }
        return Response.Builder.ok((Object)result, (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=lock")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/")
    public Response lock(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath) {
        LockTestCase lockTestCase = new LockTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = lockTestCase.lock(repoPath);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=checkLock")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/")
    public Response checkLock(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath) {
        LockTestCase lockTestCase = new LockTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = lockTestCase.isLocked(repoPath);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=addVersionNode")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/{value}/")
    public Response addVersionNode(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath, @URIParam(value="value") String value) {
        VersionTestCase versionTestCase = new VersionTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = versionTestCase.addVersionNode(repoPath, value);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=checkVersionNode")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/{checkedValue}/")
    public Response checkVersionNode(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath, @URIParam(value="checkedValue") String checkedValue) {
        VersionTestCase versionTestCase = new VersionTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = versionTestCase.checkVersionNode(repoPath, checkedValue);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=addNewVersion")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/{newValue}/")
    public Response addNewVersion(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath, @URIParam(value="newValue") String newValue) {
        VersionTestCase versionTestCase = new VersionTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = versionTestCase.addNewVersion(repoPath, newValue);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=restorePreviousVersion")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/")
    public Response restorePreviousVersion(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath) {
        VersionTestCase versionTestCase = new VersionTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = versionTestCase.restorePreviousVersion(repoPath);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=restoreBaseVersion")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/")
    public Response restoreBaseVersion(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath) {
        VersionTestCase versionTestCase = new VersionTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = versionTestCase.restoreBaseVersion(repoPath);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=delete")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/{nodeName}/")
    public Response delete(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath, @URIParam(value="nodeName") String nodeName) {
        DeleteTestCase deleteTestCase = new DeleteTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = deleteTestCase.delete(repoPath, nodeName);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=checkDelete")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/{nodeName}/")
    public Response checkDelete(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="repoPath") String repoPath, @URIParam(value="nodeName") String nodeName) {
        DeleteTestCase deleteTestCase = new DeleteTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = deleteTestCase.checkDelete(repoPath, nodeName);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=workspaceCopy")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{srcRepoPath}/{nodeName}/{destNodeName}/{contentSize}/")
    public Response workspaceCopy(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="srcRepoPath") String srcRepoPath, @URIParam(value="nodeName") String nodeName, @URIParam(value="destNodeName") String destNodeName, @URIParam(value="contentSize") Long contentSize) {
        CopyMoveTestCase copyMoveTestCase = new CopyMoveTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = copyMoveTestCase.workspaceCopy(srcRepoPath, nodeName, destNodeName, contentSize);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=workspaceMove")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{srcRepoPath}/{nodeName}/{destNodeName}/{contentSize}/")
    public Response workspaceMove(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="srcRepoPath") String srcRepoPath, @URIParam(value="nodeName") String nodeName, @URIParam(value="destNodeName") String destNodeName, @URIParam(value="contentSize") Long contentSize) {
        CopyMoveTestCase copyMoveTestCase = new CopyMoveTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = copyMoveTestCase.workspaceMove(srcRepoPath, nodeName, destNodeName, contentSize);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=sessionMove")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{srcRepoPath}/{nodeName}/{destNodeName}/{contentSize}/")
    public Response sessionMove(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="srcRepoPath") String srcRepoPath, @URIParam(value="nodeName") String nodeName, @URIParam(value="destNodeName") String destNodeName, @URIParam(value="contentSize") Long contentSize) {
        CopyMoveTestCase copyMoveTestCase = new CopyMoveTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = copyMoveTestCase.sessionMove(srcRepoPath, nodeName, destNodeName, contentSize);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    @QueryTemplate(value="operation=checkCopyMoveNode")
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{srcRepoPath}/{nodeName}/{destNodeName}/{contentSize}/")
    public Response checkCopyMoveNode(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="userName") String userName, @URIParam(value="password") String password, @URIParam(value="srcRepoPath") String srcRepoPath, @URIParam(value="nodeName") String nodeName, @URIParam(value="destNodeName") String destNodeName, @URIParam(value="contentSize") Long contentSize) {
        CopyMoveTestCase copyMoveTestCase = new CopyMoveTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = copyMoveTestCase.checkCopyMoveNode(srcRepoPath, nodeName, destNodeName, contentSize);
        return Response.Builder.ok((Object)sb.toString(), (String)"text/plain").build();
    }

    public class Constants {
        public static final String BASE_URL = "/rest/replication-test";
        public static final String OPERATION_PREFIX = "?operation=";

        public class OperationType {
            public static final String ADD_NT_FILE = "addNTFile";
            public static final String CHECK_NT_FILE = "checkNTFile";
            public static final String START_BACKUP = "startBackup";
            public static final String SET_LOCK = "lock";
            public static final String CECK_LOCK = "checkLock";
            public static final String ADD_VERSIONODE = "addVersionNode";
            public static final String CHECK_VERSION_NODE = "checkVersionNode";
            public static final String ADD_NEW_VERSION = "addNewVersion";
            public static final String RESTORE_RPEVIOUS_VERSION = "restorePreviousVersion";
            public static final String RESTORE_BASE_VERSION = "restoreBaseVersion";
            public static final String DELETE = "delete";
            public static final String CHECK_DELETE = "checkDelete";
            public static final String WORKSPACE_COPY = "workspaceCopy";
            public static final String WORKSPASE_MOVE = "workspaceMove";
            public static final String SESSION_MOVE = "sessionMove";
            public static final String CHECK_COPY_MOVE_NODE = "checkCopyMoveNode";
        }
    }
}

