/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.app;

import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class ThreadLocalSessionProviderService
implements SessionProviderService {
    private static ThreadLocal<SessionProvider> sessionProviderKeeper;
    private static ThreadLocal<SessionProvider> systemSessionProviderKeeper;

    public ThreadLocalSessionProviderService() {
        sessionProviderKeeper = new ThreadLocal();
        systemSessionProviderKeeper = new ThreadLocal();
    }

    public SessionProvider getSessionProvider(Object key) {
        if (sessionProviderKeeper.get() != null) {
            return sessionProviderKeeper.get();
        }
        return null;
    }

    public SessionProvider getSystemSessionProvider(Object key) {
        if (systemSessionProviderKeeper.get() != null) {
            return systemSessionProviderKeeper.get();
        }
        SessionProvider ssp = SessionProvider.createSystemProvider();
        systemSessionProviderKeeper.set(ssp);
        return ssp;
    }

    public void setSessionProvider(Object key, SessionProvider sessionProvider) {
        sessionProviderKeeper.set(sessionProvider);
    }

    public void removeSessionProvider(Object key) {
        this.getSessionProvider(key).close();
        sessionProviderKeeper.set(null);
        if (systemSessionProviderKeeper.get() != null) {
            systemSessionProviderKeeper.get().close();
            systemSessionProviderKeeper.set(null);
        }
    }
}

