/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource.representation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NtResourceNodeRepresentation
implements NodeRepresentation {
    protected Node node;

    public NtResourceNodeRepresentation(Node node) throws RepositoryException {
        this.node = node;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public long getContentLenght() throws RepositoryException {
        return this.node.getProperty("jcr:data").getLength();
    }

    @Override
    public String getMediaType() throws RepositoryException {
        return this.node.getProperty("jcr:mimeType").getString();
    }

    @Override
    public long getLastModified() throws RepositoryException {
        return this.node.getProperty("jcr:lastModified").getLong();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public HierarchicalProperty getProperty(String name) throws RepositoryException {
        String value;
        if ("jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name) || "jcr:data".equals(name) || "jcr:uuid".equals(name)) {
            return null;
        }
        try {
            value = this.node.getProperty(name).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        String ns = ((ExtendedSession)this.node.getSession()).getLocationFactory().parseJCRName(name).getNamespace();
        return new HierarchicalProperty(name, value, ns);
    }

    @Override
    public Collection<String> getPropertyNames() throws RepositoryException {
        PropertyIterator iter = this.node.getProperties();
        ArrayList<String> props = new ArrayList<String>();
        while (iter.hasNext()) {
            String name = iter.nextProperty().getName();
            if ("jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name) || "jcr:data".equals(name) || "jcr:uuid".equals(name)) continue;
            props.add(name);
        }
        return props;
    }

    @Override
    public InputStream getInputStream() throws IOException, RepositoryException {
        return this.node.getProperty("jcr:data").getStream();
    }
}

