/*
 * Copyright (C) 2003-2008 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

/**
 * Created by The eXo Platform SAS
 * @author <a href="mailto:alex.reshetnyak@exoplatform.com.ua">Alex Reshetnyak</a> 
 * @version $Id: AbstractFSAccess.java 16481 2008-06-26 13:23:34Z rainf0x $
 */
public class AbstractFSAccess {
  public final static String DATA_DIR_NAME       = "data";

  public final static String PREFIX_REMOVED_DATA = "---";

  public final static String PREFIX_CHAR         = "-";

  public final static String REMOVED_SUFFIX      = ".remove";

  protected int              BUFFER_1KB          = 1024;

  protected File getAsFile(InputStream is) throws IOException {
    byte[] buf = new byte[BUFFER_1KB * 20];

    File tempFile = File.createTempFile("" + System.currentTimeMillis(), "" + System.nanoTime());
    FileOutputStream fos = new FileOutputStream(tempFile);
    int len;

    while ((len = is.read(buf)) > 0)
      fos.write(buf, 0, len);

    fos.flush();
    fos.close();

    return tempFile;
  }

  protected File getAsFile(ObjectInputStream ois, long fileSize) throws IOException {
    int bufferSize = BUFFER_1KB * 8;
    byte[] buf = new byte[bufferSize];

    File tempFile = File.createTempFile("" + System.currentTimeMillis(), "" + System.nanoTime());
    FileOutputStream fos = new FileOutputStream(tempFile);
    long readBytes = fileSize;

    while (readBytes > 0) {
      if (readBytes >= bufferSize) {
        ois.readFully(buf);
        fos.write(buf);
      } else if (readBytes < bufferSize) {
        ois.readFully(buf, 0, (int) readBytes);
        fos.write(buf, 0, (int) readBytes);
      }
      readBytes -= bufferSize;
    }

    fos.flush();
    fos.close();

    return tempFile;
  }
}
