/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.priority;

import java.util.List;
import org.exoplatform.services.jcr.ext.replication.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.priority.AbstractPriorityChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticPriorityChecker
extends AbstractPriorityChecker {
    public StaticPriorityChecker(ChannelManager channelManagerpu, int ownPriority, String ownName, List<String> otherParticipants) {
        super(channelManagerpu, ownPriority, ownName, otherParticipants);
    }

    @Override
    public void receive(Packet packet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" ------->>> receive from " + packet.getOwnerName() + ", byte == " + packet.getByteArray().length));
        }
        try {
            if (!this.ownName.equals(packet.getOwnerName())) {
                switch (packet.getPacketType()) {
                    case 30: {
                        Packet pktMyPriority = new Packet(31, this.ownName, this.ownPriority, packet.getIdentifier());
                        this.channelManager.sendPacket(pktMyPriority);
                        break;
                    }
                    case 31: {
                        if (this.identifier.equals(packet.getIdentifier())) {
                            this.currentPartisipants.put(packet.getOwnerName(), (int)packet.getSize());
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(this.channelManager.getChannel().getClusterName() + " : " + this.identifier + " : added member :"));
                                log.debug((Object)("   +" + packet.getOwnerName() + ":" + this.currentPartisipants.get(packet.getOwnerName())));
                            }
                            if (this.otherPartisipants.size() == this.currentPartisipants.size()) {
                                this.memberListener.memberRejoin();
                            }
                        }
                        if (!log.isDebugEnabled()) break;
                        this.printOnlineMembers();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"An error in processing packet : ", (Throwable)e);
        }
    }

    @Override
    public boolean isMaxPriority() {
        return this.ownPriority == MAX_PRIORITY;
    }
}

