/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource.representation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NtFileNodeRepresentation
implements NodeRepresentation {
    private Node node;
    private NodeRepresentation content;

    public NtFileNodeRepresentation(Node node, NodeRepresentation content) throws RepositoryException {
        this.node = node;
        this.content = content;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public long getContentLenght() throws RepositoryException {
        return this.content.getContentLenght();
    }

    @Override
    public String getMediaType() throws RepositoryException {
        return this.content.getMediaType();
    }

    @Override
    public long getLastModified() throws RepositoryException {
        return this.content.getLastModified();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public HierarchicalProperty getProperty(String name) throws RepositoryException {
        if ("jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name)) {
            return null;
        }
        if (this.content == null) {
            return null;
        }
        if (this.content.getProperty(name) != null) {
            return this.content.getProperty(name);
        }
        try {
            String value = this.node.getProperty(name).getString();
            String ns = ((ExtendedSession)this.node.getSession()).getLocationFactory().parseJCRName(name).getNamespace();
            return new HierarchicalProperty(name, value, ns);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    @Override
    public Collection<HierarchicalProperty> getProperties(String name) throws RepositoryException {
        ArrayList<HierarchicalProperty> props = new ArrayList<HierarchicalProperty>();
        props.add(this.getProperty(name));
        return props;
    }

    @Override
    public Collection<String> getPropertyNames() throws RepositoryException {
        PropertyIterator iter = this.node.getProperties();
        ArrayList<String> props = new ArrayList<String>();
        while (iter.hasNext()) {
            String name = iter.nextProperty().getName();
            if ("jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name)) continue;
            props.add(name);
        }
        props.addAll(this.content.getPropertyNames());
        return props;
    }

    @Override
    public InputStream getInputStream() throws IOException, RepositoryException {
        return this.content.getInputStream();
    }
}

