/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.distribution.impl;

import java.util.List;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractDataDistributionType
implements DataDistributionType {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.AbstractDataDistributionType");
    private static final String DEFAULT_NODE_TYPE = "nt:unstructured".intern();

    @Override
    public Node getDataNode(Node rootNode, String dataId) throws PathNotFoundException, RepositoryException {
        return rootNode.getNode(this.getRelativePath(dataId));
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId) throws RepositoryException {
        return this.getOrCreateDataNode(rootNode, dataId, null);
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId, String nodeType) throws RepositoryException {
        return this.getOrCreateDataNode(rootNode, dataId, nodeType, null);
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId, String nodeType, List<String> mixinTypes) throws RepositoryException {
        return this.getOrCreateDataNode(rootNode, dataId, nodeType, mixinTypes, null);
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws RepositoryException {
        try {
            return this.getDataNode(rootNode, dataId);
        }
        catch (PathNotFoundException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            Node node = rootNode;
            List<String> ancestors = this.getAncestors(dataId);
            int length = ancestors.size();
            for (int i = 0; i < length; ++i) {
                String nodeName = ancestors.get(i);
                try {
                    node = node.getNode(nodeName);
                    continue;
                }
                catch (PathNotFoundException e2) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("An exception occurred: " + e2.getMessage()));
                    }
                    node = this.createNode(node, nodeName, nodeType, mixinTypes, permissions, i == length - 1, true);
                }
            }
            return node;
        }
    }

    @Override
    public void removeDataNode(Node rootNode, String dataId) throws RepositoryException {
        block5: {
            Node parentNode = null;
            try {
                Node node = this.getDataNode(rootNode, dataId);
                parentNode = node.getParent();
                node.remove();
                parentNode.save();
            }
            catch (InvalidItemStateException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
                if (parentNode != null) {
                    parentNode.refresh(false);
                }
            }
            catch (PathNotFoundException e) {
                if (!LOG.isTraceEnabled()) break block5;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
    }

    @Override
    public void migrate(Node rootNode) throws RepositoryException {
        throw new UnsupportedOperationException("The method is not supported");
    }

    @Override
    public void migrate(Node rootNode, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws RepositoryException {
        throw new UnsupportedOperationException("The method is not supported");
    }

    protected Node createNode(Node parentNode, String nodeName, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions, boolean isLeaf, boolean callSave) throws RepositoryException {
        boolean useParameters = !this.useParametersOnLeafOnly() || this.useParametersOnLeafOnly() && isLeaf;
        Node node = nodeType == null || nodeType.isEmpty() || !useParameters ? parentNode.addNode(nodeName, DEFAULT_NODE_TYPE) : parentNode.addNode(nodeName, nodeType);
        if (node.getIndex() > 1) {
            parentNode.refresh(false);
            return parentNode.getNode(nodeName);
        }
        if (useParameters) {
            if (permissions != null && !permissions.isEmpty()) {
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)node).setPermissions(permissions);
            }
            if (mixinTypes != null) {
                int length = mixinTypes.size();
                for (int i = 0; i < length; ++i) {
                    String mixin = mixinTypes.get(i);
                    if (!node.canAddMixin(mixin)) continue;
                    node.addMixin(mixin);
                }
            }
        }
        if (callSave) {
            try {
                parentNode.save();
            }
            catch (ItemExistsException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
                parentNode.refresh(false);
                while (!parentNode.hasNode(nodeName)) {
                }
                return parentNode.getNode(nodeName);
            }
        }
        return node;
    }

    protected String getRelativePath(String dataId) {
        StringBuilder buffer = new StringBuilder(256);
        List<String> ancestors = this.getAncestors(dataId);
        int length = ancestors.size();
        for (int i = 0; i < length; ++i) {
            buffer.append(ancestors.get(i));
            if (i == length - 1) continue;
            buffer.append('/');
        }
        return buffer.toString();
    }

    protected abstract List<String> getAncestors(String var1);

    protected abstract boolean useParametersOnLeafOnly();
}

