/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.backup.RepositoryRestoreExeption;
import org.exoplatform.services.jcr.ext.backup.impl.BackupManagerImpl;
import org.exoplatform.services.jcr.ext.backup.impl.JobRepositoryRestore;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;

public class JobExistingRepositoryRestore
extends JobRepositoryRestore {
    public JobExistingRepositoryRestore(RepositoryService repoService, BackupManagerImpl backupManagerImpl, RepositoryEntry repositoryEntry, Map<String, File> workspacesMapping, File backupChainLogFile) {
        this(repoService, backupManagerImpl, repositoryEntry, workspacesMapping, backupChainLogFile, false);
    }

    public JobExistingRepositoryRestore(RepositoryService repoService, BackupManagerImpl backupManagerImpl, RepositoryEntry repositoryEntry, Map<String, File> workspacesMapping, File backupChainLogFile, boolean removeJobOnceOver) {
        super(repoService, backupManagerImpl, repositoryEntry, workspacesMapping, backupChainLogFile, removeJobOnceOver);
    }

    @Override
    protected void restoreRepository() throws RepositoryRestoreExeption {
        ArrayList backupable = new ArrayList();
        try {
            RepositoryEntry repositoryEntry = this.repositoryService.getConfig().getRepositoryConfiguration(this.repositoryEntry.getName());
            if (repositoryEntry == null) {
                throw new RepositoryRestoreExeption("Current repository configuration " + this.repositoryEntry.getName() + " did not found");
            }
            boolean isDefault = this.repositoryService.getDefaultRepository().getConfiguration().getName().equals(repositoryEntry.getName());
            String systemWsName = this.repositoryService.getRepository(this.repositoryEntry.getName()).getConfiguration().getSystemWorkspaceName();
            ArrayList workspaceList = new ArrayList();
            workspaceList.addAll(repositoryEntry.getWorkspaceEntries());
            for (WorkspaceEntry wEntry : workspaceList) {
                backupable.addAll(this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponentInstancesOfType(Backupable.class));
            }
            LOG.info((Object)"Trying to close all the current sessions of all the workspaces of the repository");
            for (WorkspaceEntry wEntry : workspaceList) {
                this.forceCloseSession(repositoryEntry.getName(), wEntry.getName());
            }
            LOG.info((Object)("Trying to remove the repository '" + repositoryEntry.getName() + "'"));
            this.repositoryService.removeRepository(repositoryEntry.getName());
            for (Backupable component : backupable) {
                component.clean();
            }
            super.restoreRepository();
        }
        catch (Throwable t) {
            throw new RepositoryRestoreExeption("Repository " + this.repositoryEntry.getName() + " was not restored", t);
        }
    }

    @Override
    protected void removeRepository(RepositoryService repositoryService, String repositoryName) throws RepositoryException, RepositoryConfigurationException {
    }

    private int forceCloseSession(String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository mr = this.repositoryService.getRepository(repositoryName);
        WorkspaceContainerFacade wc = mr.getWorkspaceContainer(workspaceName);
        SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
        return sessionRegistry.closeSessions(workspaceName);
    }
}

