/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.access;

import java.util.ArrayList;
import java.util.Random;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AccessContextTest
extends BaseStandaloneTest {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.AccessContextTest");
    private static final int MULTI_THIARD_OPERATIONS = 100;
    private static final int THREAD_COUNT = 300;

    public void testAccessMenedgerContextMultiThread() throws RepositoryException, InterruptedException {
        Node multiACTNode = this.root.addNode("testMultiACT");
        Random random = new Random();
        int nextInt = 0;
        for (int i = 0; i < 100; ++i) {
            nextInt = random.nextInt(100);
            if (nextInt % 2 == 0) {
                multiACTNode.setProperty("deny" + i, (long)i);
                continue;
            }
            multiACTNode.setProperty("someNode" + i, (long)i);
        }
        this.session.save();
        ArrayList<JCRClient4AccessContext> clients = new ArrayList<JCRClient4AccessContext>();
        for (int i = 0; i < 300; ++i) {
            JCRClient4AccessContext jcrClient = new JCRClient4AccessContext();
            jcrClient.start();
            clients.add(jcrClient);
        }
        boolean isNeedWait = true;
        while (isNeedWait) {
            isNeedWait = false;
            for (int i = 0; i < 300; ++i) {
                JCRClient4AccessContext curClient = (JCRClient4AccessContext)clients.get(i);
                if (!curClient.isAlive()) continue;
                isNeedWait = true;
                break;
            }
            Thread.sleep(100L);
        }
    }

    protected class JCRClient4AccessContext
    extends Thread {
        private SessionImpl systemSession;
        private SessionImpl adminSession;
        private SessionImpl userSession;
        private Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.JCRClient4AccessContextTest");

        public JCRClient4AccessContext() {
            try {
                this.systemSession = AccessContextTest.this.repository.getSystemSession();
                this.adminSession = AccessContextTest.this.repository.getSystemSession();
                this.userSession = (SessionImpl)AccessContextTest.this.repository.login((Credentials)AccessContextTest.this.credentials, "ws");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void SequentialReadProperty() throws RepositoryException {
            Node sysNode = this.systemSession.getRootNode().getNode("testMultiACT");
            Node adminNode = this.adminSession.getRootNode().getNode("testMultiACT");
            Node userNode = this.userSession.getRootNode().getNode("testMultiACT");
            PropertyIterator i = userNode.getProperties();
            while (i.hasNext()) {
                i.nextProperty();
            }
        }

        private void SequentialReadNode() throws RepositoryException {
            Property prop;
            Node sysNode = this.systemSession.getRootNode().getNode("testMultiACT");
            Node adminNode = this.systemSession.getRootNode().getNode("testMultiACT");
            Node userNode = this.systemSession.getRootNode().getNode("testMultiACT");
            NodeIterator i = sysNode.getNodes();
            while (i.hasNext()) {
                i.nextNode();
            }
            i = adminNode.getProperties();
            while (i.hasNext()) {
                prop = i.nextProperty();
                try {
                    prop.getValue().getString();
                }
                catch (RepositoryException e) {
                    this.log.error((Object)"Exception must not to throw");
                }
            }
            i = userNode.getProperties();
            while (i.hasNext()) {
                prop = i.nextProperty();
                try {
                    prop.getValue().getString();
                    if (prop.getName().indexOf("deny") <= -1) continue;
                    this.log.error((Object)"Exception must throw");
                }
                catch (RepositoryException repositoryException) {}
            }
        }

        private void ParalelRead() {
            for (int i = 0; i < 100; ++i) {
            }
        }

        @Override
        public void run() {
            try {
                this.SequentialReadProperty();
                this.ParalelRead();
            }
            catch (RepositoryException e) {
                e.printStackTrace();
                this.log.error((Object)"Error");
            }
        }
    }
}

