/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScriptAddRepoPlugin;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyClassLoaderProvider;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyResourceLoader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.groovy.SourceFile;
import org.exoplatform.services.rest.ext.groovy.SourceFolder;
import org.picocontainer.Startable;

public class JcrGroovyCompiler
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(JcrGroovyCompiler.class);
    protected final JcrGroovyClassLoaderProvider classLoaderProvider;
    protected List<GroovyScriptAddRepoPlugin> addRepoPlugins;

    public JcrGroovyCompiler(JcrGroovyClassLoaderProvider classLoaderProvider) {
        this.classLoaderProvider = classLoaderProvider;
    }

    public JcrGroovyCompiler() {
        this(new JcrGroovyClassLoaderProvider());
    }

    public Class<?>[] compile(UnifiedNodeReference ... sourceReferences) throws IOException {
        return this.compile((SourceFolder[])null, sourceReferences);
    }

    public Class<?>[] compile(SourceFolder[] src, UnifiedNodeReference ... sourceReferences) throws IOException {
        SourceFile[] files = new SourceFile[sourceReferences.length];
        for (int i = 0; i < sourceReferences.length; ++i) {
            files[i] = new SourceFile(sourceReferences[i].getURL());
        }
        return this.doCompile((JcrGroovyClassLoaderProvider.JcrGroovyClassLoader)this.classLoaderProvider.getGroovyClassLoader(src), files);
    }

    public Class<?>[] compile(SourceFolder[] src, SourceFile[] files) throws IOException {
        return this.doCompile((JcrGroovyClassLoaderProvider.JcrGroovyClassLoader)this.classLoaderProvider.getGroovyClassLoader(src), files);
    }

    public Class<?>[] compile(SourceFile[] files) throws IOException {
        return this.doCompile((JcrGroovyClassLoaderProvider.JcrGroovyClassLoader)this.classLoaderProvider.getGroovyClassLoader(), files);
    }

    private Class<?>[] doCompile(JcrGroovyClassLoaderProvider.JcrGroovyClassLoader cl, SourceFile[] files) throws IOException {
        return cl.parseClasses(files);
    }

    public URL[] getDependencies(SourceFolder[] sources, SourceFile[] files) throws IOException {
        return ((JcrGroovyClassLoaderProvider.JcrGroovyClassLoader)this.classLoaderProvider.getGroovyClassLoader()).findDependencies(sources, files);
    }

    public void start() {
        if (this.addRepoPlugins != null && this.addRepoPlugins.size() > 0) {
            try {
                HashSet<URL> repos = new HashSet<URL>();
                for (GroovyScriptAddRepoPlugin pl : this.addRepoPlugins) {
                    repos.addAll(pl.getRepositories());
                }
                this.classLoaderProvider.getGroovyClassLoader().setResourceLoader((GroovyResourceLoader)new JcrGroovyResourceLoader(repos.toArray(new URL[repos.size()])));
            }
            catch (MalformedURLException e) {
                LOG.error((Object)"Unable add groovy script repository. ", (Throwable)e);
            }
        }
    }

    public void stop() {
    }
}

