/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.ItemExistsException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.ContainerRequestUserRole;
import org.exoplatform.services.jcr.ext.backup.ExtendedBackupManager;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChain;
import org.exoplatform.services.jcr.ext.backup.RepositoryRestoreExeption;
import org.exoplatform.services.jcr.ext.backup.WorkspaceRestoreException;
import org.exoplatform.services.jcr.ext.backup.impl.BackupManagerImpl;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanService;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.jcr.util.TesterConfigurationHelper;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.InputHeadersMap;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.BeanBuilder;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public abstract class AbstractBackupTestCase
extends BaseStandaloneTest {
    protected TesterConfigurationHelper helper = TesterConfigurationHelper.getInstance();
    protected File blob;
    protected ExtendedBackupManager backup;
    protected File backupDir;
    protected RequestHandler handler;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.backup = this.getBackupManager();
        this.forceStopAutoStopperThreads();
        this.blob = this.createBLOBTempFile(300);
        this.backupDir = new File("target/temp/backup/" + System.currentTimeMillis());
        this.backupDir.mkdirs();
        this.handler = (RequestHandler)this.container.getComponentInstanceOfType(RequestHandler.class);
        SessionProviderService sessionProviderService = (SessionProviderService)this.container.getComponentInstanceOfType(SessionProviderService.class);
        AbstractBackupTestCase.assertNotNull((Object)sessionProviderService);
        sessionProviderService.setSessionProvider(null, new SessionProvider(new ConversationState(new Identity("root"))));
    }

    private void forceStopAutoStopperThreads() {
        ((BackupManagerImpl)this.backup).stop();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.blob.delete();
    }

    protected abstract ExtendedBackupManager getBackupManager();

    protected ExtendedBackupManager getJCRBackupManager() {
        if (this.backup == null) {
            InitParams initParams = new InitParams();
            PropertiesParam pps = new PropertiesParam();
            pps.setProperty("full-backup-type", "org.exoplatform.services.jcr.ext.backup.impl.fs.FullBackupJob");
            pps.setProperty("incremental-backup-type", "org.exoplatform.services.jcr.ext.backup.impl.fs.IncrementalBackupJob");
            pps.setProperty("backup-dir", "target/backup");
            pps.setProperty("default-incremental-job-period", "3600");
            initParams.put((Object)"backup-properties", (Object)pps);
            BackupManagerImpl backup = new BackupManagerImpl(initParams, this.repositoryService);
            backup.start();
            return backup;
        }
        return this.backup;
    }

    protected ExtendedBackupManager getRDBMSBackupManager() {
        if (this.backup == null) {
            InitParams initParams = new InitParams();
            PropertiesParam pps = new PropertiesParam();
            pps.setProperty("full-backup-type", "org.exoplatform.services.jcr.ext.backup.impl.rdbms.FullBackupJob");
            pps.setProperty("incremental-backup-type", "org.exoplatform.services.jcr.ext.backup.impl.fs.IncrementalBackupJob");
            pps.setProperty("backup-dir", "target/backup");
            pps.setProperty("default-incremental-job-period", "3600");
            initParams.put((Object)"backup-properties", (Object)pps);
            BackupManagerImpl backup = new BackupManagerImpl(initParams, this.repositoryService);
            backup.start();
            return backup;
        }
        return this.backup;
    }

    protected void addContent(Node node, int startIndex, int stopIndex, long sleepTime) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, ItemExistsException, PathNotFoundException, RepositoryException, InterruptedException {
        for (int i = startIndex; i <= stopIndex; ++i) {
            node.addNode("node_" + i).setProperty("exo:data", "property-" + i);
            Thread.sleep(sleepTime);
            if (i % 10 != 0) continue;
            node.save();
        }
        node.save();
    }

    protected void waitTime(Date time) throws InterruptedException {
        while (Calendar.getInstance().getTime().before(time)) {
            Thread.yield();
            Thread.sleep(50L);
        }
        Thread.sleep(250L);
    }

    protected void removeWorkspaceFully(String repositoryName, String workspaceName) throws Exception {
        WorkspaceEntry wEntry = null;
        for (WorkspaceEntry entry : this.repositoryService.getRepository(repositoryName).getConfiguration().getWorkspaceEntries()) {
            if (!entry.getName().equals(workspaceName)) continue;
            wEntry = entry;
            break;
        }
        if (wEntry == null) {
            throw new WorkspaceRestoreException("Workspace " + workspaceName + " did not found in current repository " + repositoryName + " configuration");
        }
        boolean isSystem = this.repositoryService.getRepository(repositoryName).getConfiguration().getSystemWorkspaceName().equals(wEntry.getName());
        this.forceCloseSession(repositoryName, wEntry.getName());
        this.repositoryService.getRepository(repositoryName).removeWorkspace(wEntry.getName());
        DBCleanService.cleanWorkspaceData((WorkspaceEntry)wEntry);
        if (wEntry.getContainer().getValueStorages() != null) {
            for (ValueStorageEntry valueStorage : wEntry.getContainer().getValueStorages()) {
                DirectoryHelper.removeDirectory((File)new File(valueStorage.getParameterValue("path")));
            }
        }
        if (wEntry.getQueryHandler() != null) {
            DirectoryHelper.removeDirectory((File)new File(wEntry.getQueryHandler().getParameterValue("index-dir", null)));
            if (isSystem) {
                DirectoryHelper.removeDirectory((File)new File(wEntry.getQueryHandler().getParameterValue("index-dir", null) + "_system"));
            }
        }
    }

    protected void removeWorkspaceFullySingleDB(String repositoryName, String workspaceName) throws Exception {
        WorkspaceEntry wEntry = null;
        for (WorkspaceEntry entry : this.repositoryService.getRepository(repositoryName).getConfiguration().getWorkspaceEntries()) {
            if (!entry.getName().equals(workspaceName)) continue;
            wEntry = entry;
            break;
        }
        if (wEntry == null) {
            throw new WorkspaceRestoreException("Workspace " + workspaceName + " did not found in current repository " + repositoryName + " configuration");
        }
        boolean isSystem = this.repositoryService.getRepository(repositoryName).getConfiguration().getSystemWorkspaceName().equals(wEntry.getName());
        this.forceCloseSession(repositoryName, wEntry.getName());
        this.repositoryService.getRepository(repositoryName).removeWorkspace(wEntry.getName());
        DBCleanService.cleanWorkspaceData((WorkspaceEntry)wEntry);
        if (wEntry.getContainer().getValueStorages() != null) {
            for (ValueStorageEntry valueStorage : wEntry.getContainer().getValueStorages()) {
                DirectoryHelper.removeDirectory((File)new File(valueStorage.getParameterValue("path")));
            }
        }
        if (wEntry.getQueryHandler() != null) {
            DirectoryHelper.removeDirectory((File)new File(wEntry.getQueryHandler().getParameterValue("index-dir", null)));
            if (isSystem) {
                DirectoryHelper.removeDirectory((File)new File(wEntry.getQueryHandler().getParameterValue("index-dir", null) + "_system"));
            }
        }
    }

    protected void removeRepositoryFully(String repositoryName) throws Exception {
        RepositoryEntry repositoryEntry = this.repositoryService.getConfig().getRepositoryConfiguration(repositoryName);
        if (repositoryEntry == null) {
            throw new RepositoryRestoreExeption("Current repository configuration " + repositoryName + " did not found");
        }
        ArrayList workspaceList = new ArrayList();
        workspaceList.addAll(repositoryEntry.getWorkspaceEntries());
        for (WorkspaceEntry wEntry : workspaceList) {
            this.forceCloseSession(repositoryEntry.getName(), wEntry.getName());
        }
        String systemWorkspaceName = this.repositoryService.getRepository(repositoryName).getConfiguration().getSystemWorkspaceName();
        this.repositoryService.removeRepository(repositoryEntry.getName());
        for (WorkspaceEntry wEntry : workspaceList) {
            DBCleanService.cleanWorkspaceData((WorkspaceEntry)wEntry);
            if (wEntry.getContainer().getValueStorages() != null) {
                for (ValueStorageEntry valueStorage : wEntry.getContainer().getValueStorages()) {
                    DirectoryHelper.removeDirectory((File)new File(valueStorage.getParameterValue("path")));
                }
            }
            boolean isSystem = systemWorkspaceName.equals(wEntry.getName());
            if (wEntry.getQueryHandler() == null) continue;
            DirectoryHelper.removeDirectory((File)new File(wEntry.getQueryHandler().getParameterValue("index-dir", null)));
            if (!isSystem) continue;
            DirectoryHelper.removeDirectory((File)new File(wEntry.getQueryHandler().getParameterValue("index-dir", null) + "_system"));
        }
    }

    private int forceCloseSession(String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository mr = this.repositoryService.getRepository(repositoryName);
        WorkspaceContainerFacade wc = mr.getWorkspaceContainer(workspaceName);
        SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
        return sessionRegistry.closeSessions(workspaceName);
    }

    public void waitEndOfBackup(BackupChain bch) throws Exception {
        while (bch.getFullBackupState() != 4) {
            Thread.yield();
            Thread.sleep(50L);
        }
    }

    public void waitEndOfBackup(RepositoryBackupChain bch) throws Exception {
        while (bch.getState() != 4 && bch.getState() != 16) {
            Thread.yield();
            Thread.sleep(50L);
        }
    }

    public void waitEndOfRestore(String repositoryName) throws Exception {
        while (this.backup.getLastRepositoryRestore(repositoryName).getStateRestore() != 2 && this.backup.getLastRepositoryRestore(repositoryName).getStateRestore() != 3) {
            Thread.sleep(50L);
        }
    }

    public void waitEndOfRestore(String repositoryName, String workspaceName) throws Exception {
        while (this.backup.getLastRestore(repositoryName, workspaceName).getStateRestore() != 2 && this.backup.getLastRestore(repositoryName, workspaceName).getStateRestore() != 3) {
            Thread.sleep(50L);
        }
    }

    public void addIncrementalConent(ManageableRepository repository, String wsName) throws Exception {
        SessionImpl session = (SessionImpl)repository.login((Credentials)this.credentials, wsName);
        Node rootNode = session.getRootNode().addNode("testIncremental");
        rootNode.addNode("node1").setProperty("prop1", "value1");
        rootNode.addNode("node2").setProperty("prop2", (InputStream)new FileInputStream(this.blob));
        rootNode.addNode("node3").addMixin("mix:lockable");
        session.save();
    }

    public void addConent(ManageableRepository repository, String wsName) throws Exception {
        SessionImpl session = (SessionImpl)repository.login((Credentials)this.credentials, wsName);
        Node rootNode = session.getRootNode().addNode("test");
        rootNode.addNode("node1").setProperty("prop1", "value1");
        rootNode.addNode("node2").setProperty("prop2", (InputStream)new FileInputStream(this.blob));
        rootNode.addNode("node3").addMixin("mix:lockable");
        session.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConent(ManageableRepository repository, String wsName) throws Exception {
        SessionImpl session = (SessionImpl)repository.login((Credentials)this.credentials, wsName);
        Node rootNode = session.getRootNode().getNode("test");
        AbstractBackupTestCase.assertEquals((String)rootNode.getNode("node1").getProperty("prop1").getString(), (String)"value1");
        try (InputStream in = rootNode.getNode("node2").getProperty("prop2").getStream();){
            this.compareStream(new FileInputStream(this.blob), in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIncrementalConent(ManageableRepository repository, String wsName) throws Exception {
        SessionImpl session = (SessionImpl)repository.login((Credentials)this.credentials, wsName);
        Node rootNode = session.getRootNode().getNode("testIncremental");
        AbstractBackupTestCase.assertEquals((String)rootNode.getNode("node1").getProperty("prop1").getString(), (String)"value1");
        try (InputStream in = rootNode.getNode("node2").getProperty("prop2").getStream();){
            this.compareStream(new FileInputStream(this.blob), in);
        }
    }

    protected RepoInfo createRepositoryAndGetSession() throws Exception {
        ManageableRepository repository = this.helper.createRepository((ExoContainer)this.container, JDBCDataContainerConfig.DatabaseStructureType.MULTI, null);
        WorkspaceEntry wsEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, null);
        this.helper.addWorkspace(repository, wsEntry);
        RepoInfo rInfo = new RepoInfo(this);
        rInfo.rName = repository.getConfiguration().getName();
        rInfo.wsName = wsEntry.getName();
        rInfo.sysWsName = repository.getConfiguration().getSystemWorkspaceName();
        rInfo.session = this.repositoryService.getRepository(rInfo.rName).login((Credentials)this.credentials, rInfo.wsName);
        return rInfo;
    }

    protected boolean isRepositoryExists(String rName) {
        return this.isWorkspaceExists(rName, null);
    }

    protected boolean isWorkspaceExists(String rName, String wsName) {
        ManageableRepository repository = null;
        try {
            repository = this.repositoryService.getRepository(rName);
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (RepositoryConfigurationException e) {
            return false;
        }
        try {
            repository.login((Credentials)this.credentials, wsName);
        }
        catch (LoginException e) {
            return false;
        }
        catch (NoSuchWorkspaceException e) {
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
        return true;
    }

    protected Object getObject(Class cl, byte[] data) throws Exception {
        JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
        JsonParserImpl jsonParser = new JsonParserImpl();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        jsonParser.parse((InputStream)inputStream, (JsonHandler)jsonHandler);
        JsonValue jsonValue = jsonHandler.getJsonObject();
        return new BeanBuilder().createObject(cl, jsonValue);
    }

    protected TesterContainerResponce makeGetRequest(URI uri) throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        ContainerRequestUserRole creq = new ContainerRequestUserRole("GET", uri, new URI(""), null, (MultivaluedMap<String, String>)new InputHeadersMap((Map)headers));
        ByteArrayContainerResponseWriter responseWriter = new ByteArrayContainerResponseWriter();
        TesterContainerResponce cres = new TesterContainerResponce(this, responseWriter);
        this.handler.handleRequest((GenericContainerRequest)creq, (GenericContainerResponse)cres);
        return cres;
    }

    protected TesterContainerResponce makePostRequest(URI uri, Object object) throws Exception {
        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
        JsonValue json = generatorImpl.createJsonObject(object);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/json; charset=UTF-8");
        ContainerRequestUserRole creq = new ContainerRequestUserRole("POST", uri, new URI(""), new ByteArrayInputStream(json.toString().getBytes("UTF-8")), (MultivaluedMap<String, String>)new InputHeadersMap((Map)headers));
        ByteArrayContainerResponseWriter responseWriter = new ByteArrayContainerResponseWriter();
        TesterContainerResponce cres = new TesterContainerResponce(this, responseWriter);
        this.handler.handleRequest((GenericContainerRequest)creq, (GenericContainerResponse)cres);
        return cres;
    }

    protected class RepoInfo {
        public String rName;
        public String wsName;
        public String sysWsName;
        public Session session;

        protected RepoInfo(AbstractBackupTestCase this$0) {
        }
    }

    protected class TesterContainerResponce
    extends ContainerResponse {
        public ByteArrayContainerResponseWriter responseWriter;

        public TesterContainerResponce(AbstractBackupTestCase this$0, ByteArrayContainerResponseWriter responseWriter) {
            super((ContainerResponseWriter)responseWriter);
            this.responseWriter = responseWriter;
        }
    }
}

