/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.distribution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import junit.framework.TestCase;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;

public class TestDataDistributionManager
extends BaseStandaloneTest {
    private DataDistributionManager manager;
    private Node parentNode;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = (DataDistributionManager)this.container.getComponentInstanceOfType(DataDistributionManager.class);
        this.parentNode = this.root.addNode("TestDataDistributionManager");
        this.session.save();
    }

    @Override
    protected void tearDown() throws Exception {
        this.manager = null;
        if (this.parentNode != null) {
            this.parentNode.remove();
            this.session.save();
            this.parentNode = null;
        }
        super.tearDown();
    }

    public void testDataDistributionModeNone() throws Exception {
        DataDistributionType type = this.manager.getDataDistributionType(DataDistributionMode.NONE);
        String dataId = "/a/a/a/a/";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        Node node = type.getOrCreateDataNode(this.parentNode, dataId);
        TestDataDistributionManager.assertTrue((boolean)node.isSame((Item)type.getOrCreateDataNode(this.parentNode, dataId)));
        TestDataDistributionManager.assertEquals((long)1L, (long)node.getParent().getNodes().getSize());
        Node node2 = type.getDataNode(this.parentNode, dataId);
        TestDataDistributionManager.assertTrue((boolean)node.isSame((Item)node2));
        Node node3 = this.parentNode.getNode("a/a/a/a");
        TestDataDistributionManager.assertTrue((boolean)node.isSame((Item)node3));
        Node node4 = type.getOrCreateDataNode(this.parentNode, "a/a/a/b", "nt:folder");
        TestDataDistributionManager.assertFalse((boolean)node.isSame((Item)node4));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().isSame((Item)node4.getParent()));
        TestDataDistributionManager.assertTrue((boolean)node4.isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node4.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node4.canAddMixin("exo:privilegeable"));
        dataId = "b/a/a/a";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        Node node5 = type.getOrCreateDataNode(this.parentNode, dataId, "nt:folder", Collections.singletonList("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node.isSame((Item)node5));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().isSame((Item)node5.getParent()));
        TestDataDistributionManager.assertTrue((boolean)node5.isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node5.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node5.canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node5.getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node5.getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node5.getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node5.getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node5.getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node5.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node5.getParent().getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node5.getParent().getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node5.getParent().getParent().getParent().canAddMixin("exo:privilegeable"));
        Map<String, String[]> permissions = Collections.singletonMap("root", PermissionType.ALL);
        type.removeDataNode(this.parentNode, dataId);
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        dataId = "c/a/a/a";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        Node node6 = type.getOrCreateDataNode(this.parentNode, dataId, "nt:folder", Collections.singletonList("mix:referenceable"), permissions);
        TestDataDistributionManager.assertFalse((boolean)node.isSame((Item)node6));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().isSame((Item)node6.getParent()));
        TestDataDistributionManager.assertTrue((boolean)node6.isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node6.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node6.canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node6).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node6).getACL().getPermissions("root"));
        TestDataDistributionManager.assertTrue((boolean)node6.getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node6.getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node6.getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node6.getParent()).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node6.getParent()).getACL().getPermissions("root"));
        TestDataDistributionManager.assertTrue((boolean)node6.getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node6.getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node6.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node6.getParent().getParent()).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node6.getParent().getParent()).getACL().getPermissions("root"));
        TestDataDistributionManager.assertTrue((boolean)node6.getParent().getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node6.getParent().getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node6.getParent().getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node6.getParent().getParent().getParent()).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node6.getParent().getParent().getParent()).getACL().getPermissions("root"));
        type.removeDataNode(this.parentNode, dataId);
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testDataDistributionModeReadable() throws Exception {
        DataDistributionType type = this.manager.getDataDistributionType(DataDistributionMode.READABLE);
        String dataId = "john.smith";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        Map<String, String[]> permissions = Collections.singletonMap("root", PermissionType.ALL);
        Node node = type.getOrCreateDataNode(this.parentNode, dataId, "nt:folder", Collections.singletonList("mix:referenceable"), permissions);
        TestDataDistributionManager.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("root"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node.getPath().endsWith("j___/jo___/joh___/john.smith"));
        dataId = "bob";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        node = type.getOrCreateDataNode(this.parentNode, dataId, "nt:folder", Collections.singletonList("mix:referenceable"), permissions);
        TestDataDistributionManager.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("root"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node.getPath().endsWith("b___/bo___/bob"));
        dataId = "john___";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        node = type.getOrCreateDataNode(this.parentNode, dataId, "nt:folder", Collections.singletonList("mix:referenceable"), permissions);
        TestDataDistributionManager.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("root"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node.getPath().endsWith("j___/jo___/joh___/john___"));
        dataId = "joh___";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        node = type.getOrCreateDataNode(this.parentNode, dataId, "nt:folder", Collections.singletonList("mix:referenceable"), permissions);
        TestDataDistributionManager.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("root"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node.getPath().endsWith("j___/jo___/joh___/joh___"));
        dataId = "jo___";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        node = type.getOrCreateDataNode(this.parentNode, dataId, "nt:folder", Collections.singletonList("mix:referenceable"), permissions);
        TestDataDistributionManager.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("root"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node.getPath().endsWith("j___/jo___/jo____/jo___"));
        dataId = "j___";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        node = type.getOrCreateDataNode(this.parentNode, dataId, "nt:folder", Collections.singletonList("mix:referenceable"), permissions);
        TestDataDistributionManager.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("root"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node.getPath().endsWith("j___/j____/j_____/j___"));
        type.removeDataNode(this.parentNode, dataId);
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testDataDistributionModeOptimized() throws Exception {
        DataDistributionType type = this.manager.getDataDistributionType(DataDistributionMode.OPTIMIZED);
        String dataId = "john.smith";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        Map<String, String[]> permissions = Collections.singletonMap("root", PermissionType.ALL);
        Node node = type.getOrCreateDataNode(this.parentNode, dataId, "nt:folder", Collections.singletonList("mix:referenceable"), permissions);
        TestDataDistributionManager.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("root"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node.getPath().endsWith("1/2/s/john.smith"));
        dataId = "mary";
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        node = type.getOrCreateDataNode(this.parentNode, dataId, "nt:folder", Collections.singletonList("mix:referenceable"), permissions);
        TestDataDistributionManager.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestDataDistributionManager.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("root"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertFalse((boolean)node.getParent().getParent().getParent().isNodeType("nt:folder"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("mix:referenceable"));
        TestDataDistributionManager.assertTrue((boolean)node.getParent().getParent().getParent().canAddMixin("exo:privilegeable"));
        TestDataDistributionManager.assertTrue((boolean)node.getPath().endsWith("5/o/s/mary"));
        type.removeDataNode(this.parentNode, dataId);
        try {
            type.getDataNode(this.parentNode, dataId);
            TestDataDistributionManager.fail((String)"a PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testMultiThreadingNone() throws Throwable {
        this.testMultiThreading(this.manager.getDataDistributionType(DataDistributionMode.NONE), "key/");
    }

    public void testMultiThreadingReadable() throws Throwable {
        this.testMultiThreading(this.manager.getDataDistributionType(DataDistributionMode.READABLE), "key-");
    }

    public void testMultiThreadingOptimized() throws Throwable {
        this.testMultiThreading(this.manager.getDataDistributionType(DataDistributionMode.OPTIMIZED), "");
    }

    public void testMultiThreading(final DataDistributionType type, final String dataIdPrefix) throws Throwable {
        int totalElement = 20;
        int totalTimes = 3;
        int reader = 8;
        int writer = 4;
        int remover = 2;
        final CountDownLatch startSignalWriter = new CountDownLatch(1);
        final CountDownLatch startSignalOthers = new CountDownLatch(1);
        final CountDownLatch doneSignal = new CountDownLatch(reader + writer + remover);
        final List<Throwable> errors = Collections.synchronizedList(new ArrayList());
        int i = 0;
        while (i < writer) {
            final int index = i++;
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Session session = null;
                    try {
                        startSignalWriter.await();
                        for (int j = 0; j < 3; ++j) {
                            session = TestDataDistributionManager.this.repository.login((Credentials)TestDataDistributionManager.this.credentials, "ws");
                            Node node = (Node)session.getItem(TestDataDistributionManager.this.parentNode.getPath());
                            for (int i = 0; i < 20; ++i) {
                                try {
                                    Node n = type.getOrCreateDataNode(node, dataIdPrefix + i);
                                    TestCase.assertFalse((String)("The path " + n.getPath() + " should not contain any indexes"), (boolean)n.getPath().contains("["));
                                    continue;
                                }
                                catch (RepositoryException repositoryException) {
                                    // empty catch block
                                }
                            }
                            if (index == 0 && j == 0) {
                                startSignalOthers.countDown();
                            }
                            session.logout();
                            1.sleep(50L);
                        }
                    }
                    catch (Throwable e) {
                        errors.add(e);
                        startSignalOthers.countDown();
                    }
                    finally {
                        doneSignal.countDown();
                        if (session != null) {
                            session.logout();
                            session = null;
                        }
                    }
                }
            };
            thread.start();
        }
        startSignalWriter.countDown();
        for (i = 0; i < reader; ++i) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Session session = null;
                    try {
                        startSignalOthers.await();
                        for (int j = 0; j < 3; ++j) {
                            session = TestDataDistributionManager.this.repository.login((Credentials)TestDataDistributionManager.this.credentials, "ws");
                            Node node = (Node)session.getItem(TestDataDistributionManager.this.parentNode.getPath());
                            for (int i = 0; i < 20; ++i) {
                                try {
                                    Node n = type.getDataNode(node, dataIdPrefix + i);
                                    TestCase.assertFalse((String)("The path " + n.getPath() + " should not contain any indexes"), (boolean)n.getPath().contains("["));
                                    continue;
                                }
                                catch (PathNotFoundException pathNotFoundException) {
                                    // empty catch block
                                }
                            }
                            session.logout();
                            2.sleep(50L);
                        }
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal.countDown();
                        if (session != null) {
                            session.logout();
                            session = null;
                        }
                    }
                }
            };
            thread.start();
        }
        for (i = 0; i < remover; ++i) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Session session = null;
                    try {
                        startSignalOthers.await();
                        for (int j = 0; j < 3; ++j) {
                            session = TestDataDistributionManager.this.repository.login((Credentials)TestDataDistributionManager.this.credentials, "ws");
                            Node node = (Node)session.getItem(TestDataDistributionManager.this.parentNode.getPath());
                            for (int i = 0; i < 20; ++i) {
                                try {
                                    type.removeDataNode(node, dataIdPrefix + i);
                                    continue;
                                }
                                catch (RepositoryException repositoryException) {
                                    // empty catch block
                                }
                            }
                            session.logout();
                            3.sleep(50L);
                        }
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal.countDown();
                        if (session != null) {
                            session.logout();
                            session = null;
                        }
                    }
                }
            };
            thread.start();
        }
        doneSignal.await();
        for (i = 0; i < 20; ++i) {
            type.removeDataNode(this.parentNode, dataIdPrefix + i);
        }
        for (i = 0; i < 20; ++i) {
            try {
                type.getDataNode(this.parentNode, dataIdPrefix + i);
                TestDataDistributionManager.fail((String)"The node should be removed");
                continue;
            }
            catch (PathNotFoundException thread) {
                // empty catch block
            }
        }
        for (i = 0; i < 20; ++i) {
            Node n = type.getOrCreateDataNode(this.parentNode, dataIdPrefix + i);
            TestDataDistributionManager.assertFalse((String)("The path " + n.getPath() + " should not contain any indexes"), (boolean)n.getPath().contains("["));
        }
        if (!errors.isEmpty()) {
            for (Throwable e : errors) {
                e.printStackTrace();
            }
            throw errors.get(0);
        }
    }

    public void testMigration() throws Exception {
        Node rootNode = this.session.getRootNode().addNode("testRoot");
        rootNode.addNode("a").setProperty("a", "a");
        rootNode.addNode("bob").setProperty("bob", "bob");
        rootNode.addNode("john.smith").setProperty("john.smith", "john.smith");
        rootNode.addNode("joiv").setProperty("joiv", "joiv");
        rootNode.addNode("bonjov").setProperty("bonjov", "bonjov");
        rootNode.addNode("anatoliy.bazko").setProperty("anatoliy.bazko", "anatoliy.bazko");
        rootNode.getSession().save();
        this.manager.getDataDistributionType(DataDistributionMode.READABLE).migrate(rootNode);
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("a"));
        TestDataDistributionManager.assertFalse((boolean)rootNode.hasNode("bob"));
        TestDataDistributionManager.assertFalse((boolean)rootNode.hasNode("john.smith"));
        TestDataDistributionManager.assertFalse((boolean)rootNode.hasNode("joiv"));
        TestDataDistributionManager.assertFalse((boolean)rootNode.hasNode("bonjov"));
        TestDataDistributionManager.assertFalse((boolean)rootNode.hasNode("anatoliy.bazko"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("b___/bo___/bob"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("j___/jo___/joh___/john.smith"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("j___/jo___/joi___/joiv"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("b___/bo___/bon___/bonjov"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("a___/an___/ana___/anatoliy.bazko"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("a").hasProperty("a"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("b___/bo___/bob").hasProperty("bob"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("j___/jo___/joh___/john.smith").hasProperty("john.smith"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("j___/jo___/joi___/joiv").hasProperty("joiv"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("b___/bo___/bon___/bonjov").hasProperty("bonjov"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("a___/an___/ana___/anatoliy.bazko").hasProperty("anatoliy.bazko"));
        this.manager.getDataDistributionType(DataDistributionMode.READABLE).migrate(rootNode);
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("a"));
        TestDataDistributionManager.assertFalse((boolean)rootNode.hasNode("bob"));
        TestDataDistributionManager.assertFalse((boolean)rootNode.hasNode("john.smith"));
        TestDataDistributionManager.assertFalse((boolean)rootNode.hasNode("joiv"));
        TestDataDistributionManager.assertFalse((boolean)rootNode.hasNode("bonjov"));
        TestDataDistributionManager.assertFalse((boolean)rootNode.hasNode("anatoliy.bazko"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("b___/bo___/bob"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("j___/jo___/joh___/john.smith"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("j___/jo___/joi___/joiv"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("b___/bo___/bon___/bonjov"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.hasNode("a___/an___/ana___/anatoliy.bazko"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("a").hasProperty("a"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("b___/bo___/bob").hasProperty("bob"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("j___/jo___/joh___/john.smith").hasProperty("john.smith"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("j___/jo___/joi___/joiv").hasProperty("joiv"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("b___/bo___/bon___/bonjov").hasProperty("bonjov"));
        TestDataDistributionManager.assertTrue((boolean)rootNode.getNode("a___/an___/ana___/anatoliy.bazko").hasProperty("anatoliy.bazko"));
    }
}

