/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.metadata;

import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;

public class MetaDataActionTest
extends BaseStandaloneTest {
    public void testAddContent() throws Exception {
        InputStream is = MetaDataActionTest.class.getResourceAsStream("/test_index.xls");
        Node rootNode = this.session.getRootNode().addNode("MetaDataActionTest");
        this.session.save();
        Node contentNode = rootNode.addNode("testAddContent", "nt:resource");
        contentNode.setProperty("jcr:data", is);
        contentNode.setProperty("jcr:mimeType", "application/excel");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        this.root.save();
        Node testNode = this.repository.getSystemSession().getRootNode().getNode("MetaDataActionTest/testAddContent");
        MetaDataActionTest.assertTrue((boolean)testNode.hasProperty("dc:creator"));
        MetaDataActionTest.assertTrue((boolean)testNode.hasProperty("dc:date"));
        MetaDataActionTest.assertTrue((boolean)testNode.hasProperty("dc:contributor"));
    }

    public void testSetMetaData() throws Exception {
        Node rootNode = this.session.getRootNode().addNode("MetaDataActionTest");
        this.session.save();
        Node contentNode = rootNode.addNode("testSetMetaData");
        rootNode.save();
        MetaDataActionTest.assertTrue((boolean)contentNode.hasProperty("dc:creator"));
        MetaDataActionTest.assertTrue((boolean)contentNode.hasProperty("dc:date"));
        MetaDataActionTest.assertEquals((String)this.session.getUserID(), (String)contentNode.getProperty("dc:creator").getValues()[0].getString());
    }

    public void testDontSetMetaData() throws Exception {
        Node rootNode = this.session.getRootNode().addNode("MetaDataActionTest");
        this.session.save();
        Node contentNode = rootNode.addNode("testDontSetMetaData");
        contentNode.setProperty("prop", "prop 1");
        rootNode.save();
        MetaDataActionTest.assertFalse((boolean)contentNode.hasProperty("dc:creator"));
        MetaDataActionTest.assertFalse((boolean)contentNode.hasProperty("dc:date"));
        MetaDataActionTest.assertFalse((boolean)contentNode.hasProperty("dc:creator"));
    }

    public void testDontSetMetaDataNtFile() throws Exception {
        Node rootNode = this.session.getRootNode().addNode("MetaDataActionTest");
        this.session.save();
        Node node = rootNode.addNode("testDontSetMetaDataNtFile", "nt:file");
        Node contentNode = node.addNode("jcr:content", "nt:unstructured");
        contentNode.setProperty("jcr:data", MetaDataActionTest.class.getResourceAsStream("/test_index.xls"));
        contentNode.setProperty("jcr:mimeType", "application/vnd.ms-excel");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        rootNode.save();
        MetaDataActionTest.assertFalse((boolean)contentNode.hasProperty("dc:creator"));
        MetaDataActionTest.assertFalse((boolean)contentNode.hasProperty("dc:date"));
        MetaDataActionTest.assertFalse((boolean)contentNode.hasProperty("dc:creator"));
    }

    public void testDontSetMetaDataAnywhere() throws Exception {
        Node rootNode = this.session.getRootNode().addNode("MetaDataActionTest");
        this.session.save();
        Node contentNode = this.session.getRootNode().addNode("testDontSetMetaDataAnywhere");
        contentNode.setProperty("prop", "prop 1");
        rootNode.save();
        MetaDataActionTest.assertFalse((boolean)contentNode.hasProperty("dc:creator"));
        MetaDataActionTest.assertFalse((boolean)contentNode.hasProperty("dc:date"));
        MetaDataActionTest.assertFalse((boolean)contentNode.hasProperty("dc:creator"));
    }

    public void _testUpdatePDF() throws Exception {
        InputStream is = MetaDataActionTest.class.getResourceAsStream("/test_1.pdf");
        Node rootNode = this.session.getRootNode().addNode("MetaDataActionTest");
        Node contentNode = rootNode.addNode("testAddContent", "nt:resource");
        contentNode.setProperty("jcr:data", is);
        contentNode.setProperty("jcr:encoding", "UTF-8");
        contentNode.setProperty("jcr:mimeType", "application/pdf");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        this.session.save();
        Node testNode = this.repository.getSystemSession().getRootNode().getNode("MetaDataActionTest/testAddContent");
        MetaDataActionTest.assertTrue((boolean)testNode.hasProperty("dc:title"));
        MetaDataActionTest.assertTrue((boolean)testNode.hasProperty("dc:creator"));
        MetaDataActionTest.assertEquals((String)"Title_1", (String)testNode.getProperty("dc:title").getValues()[0].getString());
        MetaDataActionTest.assertEquals((String)"Author_1", (String)testNode.getProperty("dc:creator").getValues()[0].getString());
        is = MetaDataActionTest.class.getResourceAsStream("/test_2.pdf");
        contentNode.setProperty("jcr:data", is);
        this.session.save();
        testNode = this.repository.getSystemSession().getRootNode().getNode("MetaDataActionTest/testAddContent");
        MetaDataActionTest.assertTrue((boolean)testNode.hasProperty("dc:title"));
        MetaDataActionTest.assertTrue((boolean)testNode.hasProperty("dc:creator"));
        MetaDataActionTest.assertEquals((String)"Title_2", (String)testNode.getProperty("dc:title").getValues()[0].getString());
        MetaDataActionTest.assertEquals((String)"Author_2", (String)testNode.getProperty("dc:creator").getValues()[0].getString());
        is = MetaDataActionTest.class.getResourceAsStream("/test_3.pdf");
        contentNode.setProperty("jcr:data", is);
        this.session.save();
        testNode = this.repository.getSystemSession().getRootNode().getNode("MetaDataActionTest/testAddContent");
        MetaDataActionTest.assertFalse((boolean)testNode.hasProperty("dc:title"));
        MetaDataActionTest.assertFalse((boolean)testNode.hasProperty("dc:creator"));
    }

    public void testJcrSetPropertyTestCase() throws Exception {
        Node rootNode = this.session.getRootNode().addNode("MetaDataActionTest");
        Node contentNode = rootNode.addNode("testAddContent", "nt:resource");
        contentNode.setProperty("jcr:mimeType", "");
        contentNode.setProperty("jcr:data", "");
        contentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        this.session.save();
        contentNode.setProperty("jcr:mimeType", "image/jpeg");
        this.session.save();
    }

    public void testCheckMetaDataIfChangeMimeTypeAndData() throws Exception {
        Node rootNode = this.session.getRootNode().addNode("MetaDataActionTest");
        Node nodeWithDOC = rootNode.addNode("testAddContent", "nt:resource");
        nodeWithDOC.setProperty("jcr:mimeType", "application/msword");
        nodeWithDOC.setProperty("jcr:data", MetaDataActionTest.class.getResourceAsStream("/testDOC.doc"));
        nodeWithDOC.setProperty("jcr:lastModified", Calendar.getInstance());
        Node nodeWithPDF = rootNode.addNode("testAddContent2", "nt:resource");
        nodeWithPDF.setProperty("jcr:mimeType", "application/pdf");
        nodeWithPDF.setProperty("jcr:data", MetaDataActionTest.class.getResourceAsStream("/testPDF.pdf"));
        nodeWithPDF.setProperty("jcr:lastModified", Calendar.getInstance());
        this.session.save();
        nodeWithDOC.setProperty("jcr:mimeType", "application/pdf");
        nodeWithDOC.setProperty("jcr:data", MetaDataActionTest.class.getResourceAsStream("/testPDF.pdf"));
        this.session.save();
        HashMap<String, Property> map = new HashMap<String, Property>();
        PropertyIterator props = nodeWithDOC.getProperties();
        while (props.hasNext()) {
            Property prop = props.nextProperty();
            map.put(prop.getName(), prop);
        }
        this.evalProps(nodeWithPDF.getProperties(), map);
    }

    private void evalProps(PropertyIterator etalon, HashMap<String, Property> testedProps) throws RepositoryException {
        while (etalon.hasNext()) {
            Property prop = etalon.nextProperty();
            String propertyName = prop.getName();
            if (!propertyName.startsWith("dc:")) continue;
            Property testProperty = testedProps.get(propertyName);
            MetaDataActionTest.assertNotNull((String)(propertyName + " property not founded. "), (Object)testProperty);
            MetaDataActionTest.assertEquals((String)(propertyName + " property value is incorrect"), (Object)testProperty.getValues()[0], (Object)prop.getValues()[0]);
        }
    }
}

