/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup;

import java.io.File;
import java.util.Calendar;
import junit.framework.TestCase;
import org.exoplatform.services.jcr.ext.backup.impl.FileNameProducer;

public class TestFileNameProduser
extends TestCase {
    private File tempDir;
    private String backupsetName;
    private Calendar calendar;

    public void setUp() throws Exception {
        super.setUp();
        this.backupsetName = String.valueOf(System.currentTimeMillis());
        this.calendar = Calendar.getInstance();
    }

    public void testGetNextNameJCRBackup() throws Exception {
        this.tempDir = new File("target" + File.separator + "temp" + File.separator + "fileProduser1");
        this.tempDir.mkdirs();
        FileNameProducer nameProducer = new FileNameProducer(this.backupsetName, this.tempDir.getAbsolutePath(), this.calendar, true, false);
        File file = nameProducer.getNextFile();
        TestFileNameProduser.assertTrue((boolean)file.isFile());
        TestFileNameProduser.assertTrue((boolean)file.getName().endsWith(".0"));
        nameProducer = new FileNameProducer(this.backupsetName, this.tempDir.getAbsolutePath(), this.calendar, false, false);
        file = nameProducer.getNextFile();
        TestFileNameProduser.assertTrue((boolean)file.isFile());
        TestFileNameProduser.assertTrue((boolean)file.getName().endsWith(".1"));
        TestFileNameProduser.assertTrue((boolean)nameProducer.getNextFile().getName().endsWith(".2"));
        TestFileNameProduser.assertTrue((boolean)nameProducer.getNextFile().getName().endsWith(".3"));
    }

    public void testGetNextNameRDBMSBackup() throws Exception {
        this.tempDir = new File("target" + File.separator + "temp" + File.separator + "fileProduser2");
        this.tempDir.mkdirs();
        FileNameProducer nameProducer = new FileNameProducer(this.backupsetName, this.tempDir.getAbsolutePath(), this.calendar, true, true);
        File file = nameProducer.getNextFile();
        TestFileNameProduser.assertTrue((boolean)file.isDirectory());
        TestFileNameProduser.assertTrue((boolean)file.getName().endsWith(".0"));
        nameProducer = new FileNameProducer(this.backupsetName, this.tempDir.getAbsolutePath(), this.calendar, false, false);
        file = nameProducer.getNextFile();
        TestFileNameProduser.assertTrue((boolean)file.isFile());
        TestFileNameProduser.assertTrue((boolean)file.getName().endsWith(".1"));
        TestFileNameProduser.assertTrue((boolean)nameProducer.getNextFile().getName().endsWith(".2"));
        TestFileNameProduser.assertTrue((boolean)nameProducer.getNextFile().getName().endsWith(".3"));
    }
}

