/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Calendar;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileNameProducer {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.FileNameProducer");
    private String backupSetName;
    private File backupSetDir;
    private boolean isFullBackup;
    private boolean isDirectoryForFullBackup;

    public FileNameProducer(String backupSetName, String backupDir, Calendar timeStamp, boolean isFullBackup, boolean isDirectory) {
        this.backupSetName = backupSetName;
        this.isFullBackup = isFullBackup;
        this.isDirectoryForFullBackup = isDirectory;
        this.backupSetDir = new File(backupDir);
        if (!this.backupSetDir.exists()) {
            this.backupSetDir.mkdirs();
        }
    }

    public static File generateBackupSetDir(String repositoryName, String workspaceName, String backupDir, Calendar timeStamp) {
        FileNameProducer fileNameProducer = new FileNameProducer();
        String sTime = "-" + fileNameProducer.getStrDate(timeStamp) + "_" + fileNameProducer.getStrTime(timeStamp);
        File fBackupSetDir = new File(backupDir + File.separator + repositoryName + "_" + workspaceName + sTime);
        if (!fBackupSetDir.exists()) {
            fBackupSetDir.mkdirs();
        } else {
            int i = 2;
            while ((fBackupSetDir = new File(backupDir + File.separator + repositoryName + "_" + workspaceName + sTime + "_" + i++)).exists()) {
            }
        }
        return fBackupSetDir;
    }

    public FileNameProducer(String repositoryName, String workspaceName, String backupDir, Calendar timeStamp, boolean isFullBackup, boolean isDirectory) {
        this(repositoryName + "_" + workspaceName, backupDir, timeStamp, isFullBackup, isDirectory);
    }

    public FileNameProducer(String repositoryName, String workspaceName, String backupDir, Calendar timeStamp, boolean isFullBackup) {
        this(repositoryName + "_" + workspaceName, backupDir, timeStamp, isFullBackup, false);
    }

    public FileNameProducer() {
    }

    public File getNextFile() {
        File nextFile = null;
        try {
            String sNextName = this.generateName();
            nextFile = new File(String.valueOf(this.backupSetDir.getAbsoluteFile()) + File.separator + sNextName);
            if (this.isFullBackup && this.isDirectoryForFullBackup) {
                if (!nextFile.exists()) {
                    nextFile.mkdirs();
                }
            } else {
                nextFile.createNewFile();
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Can nit get next file : " + e.getLocalizedMessage()), (Throwable)e);
        }
        return nextFile;
    }

    private String generateName() {
        Calendar date = Calendar.getInstance();
        String sDate = this.getStrDate(date);
        String sTime = this.getStrTime(date);
        StringBuilder fileName = new StringBuilder(this.backupSetName).append("-").append(sDate).append("_").append(sTime).append(".");
        if (this.isFullBackup) {
            fileName.append("0");
        } else {
            fileName.append(this.getNextSufix());
        }
        return fileName.toString();
    }

    private String getNextSufix() {
        String[] fileList = this.backupSetDir.list(new SkipBackupLogFilter(this));
        int sufix = 0;
        for (int i = 0; i < fileList.length; ++i) {
            String[] stringArray = fileList[i].split("[.]");
            int currentSufix = Integer.valueOf(stringArray[stringArray.length - 1]);
            if (currentSufix <= sufix) continue;
            sufix = currentSufix;
        }
        return String.valueOf(++sufix);
    }

    private String getStrDate(Calendar c) {
        int m = c.get(2) + 1;
        int d = c.get(5);
        return c.get(1) + String.valueOf(m < 10 ? "0" + m : Integer.valueOf(m)) + String.valueOf(d < 10 ? "0" + d : Integer.valueOf(d));
    }

    private String getStrTime(Calendar c) {
        int h = c.get(10);
        int m = c.get(12);
        int s = c.get(13);
        return String.valueOf(h < 10 ? "0" + h : Integer.valueOf(h)) + String.valueOf(m < 10 ? "0" + m : Integer.valueOf(m)) + String.valueOf(s < 10 ? "0" + s : Integer.valueOf(s));
    }

    public File getBackupSetDir() {
        return this.backupSetDir;
    }

    class SkipBackupLogFilter
    implements FilenameFilter {
        SkipBackupLogFilter(FileNameProducer this$0) {
        }

        @Override
        public boolean accept(File dir, String name) {
            return !name.endsWith(".xml");
        }
    }
}

