/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.StringTokenizer;
import org.exoplatform.services.ftp.BaseStandaloneTest;
import org.exoplatform.services.ftp.FtpConst;

public abstract class BaseFtpTest
extends BaseStandaloneTest {
    protected Socket commandConn;
    protected String user = "root";
    protected String password = "exo";
    protected String host = "localhost";
    protected int port = 2122;
    protected BufferedReader inputCommand;
    protected BufferedWriter outputCommand;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.root.addNode("ftp-root", "nt:folder");
        this.session.save();
    }

    protected void connect() throws IOException {
        this.commandConn = new Socket(this.host, this.port);
        this.inputCommand = new BufferedReader(new InputStreamReader(this.commandConn.getInputStream()));
        this.outputCommand = new BufferedWriter(new OutputStreamWriter(this.commandConn.getOutputStream()));
        String response = this.readResponse();
        BaseFtpTest.assertTrue((boolean)response.startsWith(FtpConst.EXO_LOGO[0]));
        this.sendCommand("USER " + this.user);
        response = this.readResponse();
        BaseFtpTest.assertTrue((boolean)response.startsWith("331 "));
        this.sendCommand("PASS " + this.password);
        response = this.readResponse();
        BaseFtpTest.assertTrue((boolean)response.startsWith("230 "));
    }

    protected void disconnect() throws IOException {
        try {
            this.sendCommand("QUIT");
        }
        finally {
            this.inputCommand.close();
            this.outputCommand.close();
            this.commandConn.close();
        }
    }

    protected String pwd() throws IOException {
        this.sendCommand("PWD");
        String response = this.readResponse();
        BaseFtpTest.assertTrue((boolean)response.startsWith("257 "));
        int q1 = response.indexOf(34);
        int q2 = response.indexOf(34, q1 + 1);
        return response.substring(q1 + 1, q2);
    }

    protected void cwd(String dir) throws IOException {
        this.sendCommand("CWD " + dir);
        String response = this.readResponse();
        BaseFtpTest.assertTrue((boolean)response.startsWith("250 "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stor(byte[] data, String filename) throws IOException {
        String response = this.pasv();
        int begin = response.indexOf(40);
        int end = response.indexOf(41, begin + 1);
        String address = response.substring(begin + 1, end);
        StringTokenizer tokens = new StringTokenizer(address, ",");
        String _host = tokens.nextToken() + "." + tokens.nextToken() + "." + tokens.nextToken() + "." + tokens.nextToken();
        int _port = Integer.parseInt(tokens.nextToken()) * 256 + Integer.parseInt(tokens.nextToken());
        this.sendCommand("STOR " + filename);
        Socket dataConn = new Socket(_host, _port);
        response = this.readResponse();
        BaseFtpTest.assertTrue((boolean)response.startsWith("125 "));
        OutputStream output = null;
        try {
            output = dataConn.getOutputStream();
            output.write(data);
            output.flush();
        }
        finally {
            if (this.outputCommand != null) {
                output.close();
            }
        }
        response = this.readResponse();
        dataConn.close();
        BaseFtpTest.assertTrue((boolean)response.startsWith("226 "));
    }

    protected void bin() throws IOException {
        this.type('I');
    }

    protected void ascii() throws IOException {
        this.type('A');
    }

    protected void type(char type) throws IOException {
        this.sendCommand("TYPE " + type);
        String response = this.readResponse();
        BaseFtpTest.assertTrue((boolean)response.startsWith("200 "));
    }

    protected String pasv() throws IOException {
        this.sendCommand("PASV");
        String response = this.readResponse();
        BaseFtpTest.assertTrue((boolean)response.startsWith("227 "));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] retr(String filename) throws IOException {
        String response = this.pasv();
        int begin = response.indexOf(40);
        int end = response.indexOf(41, begin + 1);
        String address = response.substring(begin + 1, end);
        StringTokenizer tokens = new StringTokenizer(address, ",");
        String _host = tokens.nextToken() + "." + tokens.nextToken() + "." + tokens.nextToken() + "." + tokens.nextToken();
        int _port = Integer.parseInt(tokens.nextToken()) * 256 + Integer.parseInt(tokens.nextToken());
        this.sendCommand("RETR " + filename);
        Socket dataConn = new Socket(_host, _port);
        response = this.readResponse();
        BaseFtpTest.assertTrue((boolean)response.startsWith("125 "));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        try (InputStream input = null;){
            input = dataConn.getInputStream();
            int bytes = -1;
            while ((bytes = input.read(buff)) != -1) {
                output.write(buff, 0, bytes);
            }
        }
        response = this.readResponse();
        dataConn.close();
        BaseFtpTest.assertTrue((boolean)response.startsWith("226 "));
        return output.toByteArray();
    }

    protected void sendCommand(String command) throws IOException {
        try {
            this.outputCommand.write(command + "\r\n");
            this.outputCommand.flush();
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    protected String readResponse() throws IOException {
        StringBuffer buff = new StringBuffer();
        String line = this.inputCommand.readLine();
        BaseFtpTest.assertTrue((line.length() >= 3 ? 1 : 0) != 0);
        buff.append(line);
        if (line.length() > 3 && line.charAt(3) == '-') {
            do {
                buff.append('\n');
                buff.append(line);
            } while (!BaseFtpTest.isLastLine(line = this.inputCommand.readLine()));
        }
        String response = buff.toString();
        return response;
    }

    private static boolean isLastLine(String line) {
        return Character.isDigit(line.charAt(0)) && Character.isDigit(line.charAt(1)) && Character.isDigit(line.charAt(2)) && line.charAt(3) == ' ';
    }
}

